/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.List;
import java.util.Properties;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.MarkerGroup;
import org.xmind.core.internal.dom.MarkerImpl;
import org.xmind.core.internal.dom.MarkerSheetImpl;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerGroupImpl
extends MarkerGroup
implements ICoreEventSource {
    private Element implementation;
    private MarkerSheetImpl ownedSheet;

    public MarkerGroupImpl(Element implementation, MarkerSheetImpl ownedSheet) {
        this.implementation = DOMUtils.addIdAttribute(implementation);
        this.ownedSheet = ownedSheet;
    }

    public Element getImplementation() {
        return this.implementation;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == Element.class || adapter == Node.class) {
            return this.implementation;
        }
        return super.getAdapter(adapter);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof MarkerGroupImpl)) {
            return false;
        }
        MarkerGroupImpl that = (MarkerGroupImpl)obj;
        return this.implementation == that.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        return DOMUtils.toString(this.implementation);
    }

    @Override
    public String getName() {
        Properties properties;
        String name = this.implementation.getAttribute("name");
        if (name.startsWith("%") && (properties = this.ownedSheet.getProperties()) != null) {
            String key = name.substring(1);
            name = properties.getProperty(key, name);
        }
        return name;
    }

    @Override
    public IMarkerSheet getOwnedSheet() {
        return this.ownedSheet;
    }

    @Override
    public IMarkerSheet getParent() {
        Node p = this.implementation.getParentNode();
        if (p == this.ownedSheet.getSheetElement()) {
            return this.ownedSheet;
        }
        return null;
    }

    @Override
    public boolean isSingleton() {
        return Boolean.parseBoolean(this.implementation.getAttribute("singleton"));
    }

    @Override
    public boolean isHidden() {
        return Boolean.parseBoolean(this.implementation.getAttribute("hidden"));
    }

    @Override
    public void setName(String name) {
        String oldName = this.implementation.hasAttribute("name") ? this.getName() : null;
        DOMUtils.setAttribute(this.implementation, "name", name);
        String newName = this.implementation.hasAttribute("name") ? this.getName() : null;
        this.fireValueChange("name", oldName, newName);
    }

    @Override
    public void setSingleton(boolean singleton) {
        DOMUtils.setAttribute(this.implementation, "singleton", Boolean.toString(singleton));
    }

    @Override
    public void setHidden(boolean hidden) {
        DOMUtils.setAttribute(this.implementation, "hidden", Boolean.toString(hidden));
    }

    @Override
    public String getId() {
        return this.implementation.getAttribute("id");
    }

    @Override
    public List<IMarker> getMarkers() {
        return DOMUtils.getChildList(this.implementation, "marker", this.ownedSheet.getElementAdapterProvider());
    }

    @Override
    public void addMarker(IMarker marker) {
        int index;
        Element m = ((MarkerImpl)marker).getImplementation();
        Node n = this.implementation.appendChild(m);
        if (n != null && (index = DOMUtils.getElementIndex(this.implementation, "marker", m)) >= 0) {
            this.fireIndexedTargetChange("markerAdd", marker, index);
        }
    }

    @Override
    public void removeMarker(IMarker marker) {
        Node n;
        int index;
        Element m = ((MarkerImpl)marker).getImplementation();
        if (m != null && m.getParentNode() == this.implementation && (index = DOMUtils.getElementIndex(this.implementation, "marker", m)) >= 0 && (n = this.implementation.removeChild(m)) != null) {
            this.fireIndexedTargetChange("markerRemove", marker, index);
        }
    }

    @Override
    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener(this, type, listener);
    }

    private void fireValueChange(String type, Object oldValue, Object newValue) {
        this.getCoreEventSupport().dispatchValueChange(this, type, oldValue, newValue);
    }

    private void fireIndexedTargetChange(String type, Object target, int index) {
        this.getCoreEventSupport().dispatchIndexedTargetChange(this, type, target, index);
    }

    @Override
    public ICoreEventSupport getCoreEventSupport() {
        return this.ownedSheet.getCoreEventSupport();
    }
}

