/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IAdaptable;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.ElementRegistry;
import org.xmind.core.internal.MarkerSheet;
import org.xmind.core.internal.dom.INodeAdaptableFactory;
import org.xmind.core.internal.dom.INodeAdaptableProvider;
import org.xmind.core.internal.dom.InternalDOMUtils;
import org.xmind.core.internal.dom.MarkerGroupImpl;
import org.xmind.core.internal.dom.MarkerImpl;
import org.xmind.core.internal.dom.MarkerResourceProvider;
import org.xmind.core.internal.dom.NS;
import org.xmind.core.internal.dom.NodeAdaptableProvider;
import org.xmind.core.internal.event.CoreEventSupport;
import org.xmind.core.internal.zip.ZipFileInputSource;
import org.xmind.core.io.DirectoryInputSource;
import org.xmind.core.io.IInputSource;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerResource;
import org.xmind.core.marker.IMarkerResourceProvider;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.IPropertiesProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkerSheetImpl
extends MarkerSheet
implements INodeAdaptableFactory,
ICoreEventSource,
IPropertiesProvider {
    private Document implementation;
    private IMarkerResourceProvider realResourceProvider;
    private ElementRegistry elementRegistry = null;
    private NodeAdaptableProvider elementAdaptableProvider = null;
    private CoreEventSupport coreEventSupport = null;
    private Properties properties = null;
    private static final String OLD_MARKERLISTS_XML = "markerlists.xml";
    private static final String OLD_TAG_MARKER_LISTS = "markerLists";
    private static final String OLD_TAG_MARKER_LIST = "markerList";
    private static final String OLD_TAG_MARKER = "marker";
    private static final String OLD_ATT_NAME = "name";
    private static final String OLD_ATT_ID = "id";
    private static final String OLD_ATT_FILE = "file";

    public MarkerSheetImpl(Document implementation, IMarkerResourceProvider resourceProvider) {
        this.implementation = implementation;
        this.realResourceProvider = resourceProvider;
        this.init();
    }

    private void init() {
        Element m = DOMUtils.ensureChildElement(this.implementation, "marker-sheet");
        NS.setNS(NS.Marker, m, new NS[0]);
        InternalDOMUtils.addVersion(this.implementation);
    }

    public Document getImplementation() {
        return this.implementation;
    }

    public Element getSheetElement() {
        return this.implementation.getDocumentElement();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == IMarkerResourceProvider.class) {
            return this.realResourceProvider;
        }
        if (adapter == ICoreEventSupport.class) {
            return this.getCoreEventSupport();
        }
        if (adapter == IPropertiesProvider.class) {
            return this;
        }
        if (adapter == Properties.class) {
            return this.getProperties();
        }
        if (adapter == ElementRegistry.class) {
            return this.getElementRegistry();
        }
        if (adapter == INodeAdaptableFactory.class) {
            return this;
        }
        if (adapter == INodeAdaptableProvider.class) {
            return this.getElementAdapterProvider();
        }
        if (adapter == Document.class || adapter == Node.class) {
            return this.implementation;
        }
        return super.getAdapter(adapter);
    }

    protected IMarkerResource getMarkerResource(IMarker marker) {
        if (this.realResourceProvider != null) {
            return this.realResourceProvider.getMarkerResource(marker);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof MarkerSheetImpl)) {
            return false;
        }
        MarkerSheetImpl that = (MarkerSheetImpl)obj;
        return this.implementation == that.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        return DOMUtils.toString(this.implementation);
    }

    @Override
    public boolean isPermanent() {
        return this.realResourceProvider == null || this.realResourceProvider.isPermanent();
    }

    @Override
    public IMarker createMarker(String resourcePath) {
        Element markerImpl = this.implementation.createElement(OLD_TAG_MARKER);
        if (resourcePath != null) {
            markerImpl.setAttribute("resource", resourcePath);
        }
        MarkerImpl marker = new MarkerImpl(markerImpl, this);
        this.getElementRegistry().register(marker);
        return marker;
    }

    @Override
    public IMarkerGroup createMarkerGroup(boolean singleton) {
        Element groupImpl = this.implementation.createElement("marker-group");
        if (singleton) {
            groupImpl.setAttribute("singleton", Boolean.toString(singleton));
        }
        MarkerGroupImpl group = new MarkerGroupImpl(groupImpl, this);
        this.getElementRegistry().register(group);
        return group;
    }

    @Override
    protected IMarker getLocalMarker(String markerId) {
        Object element = this.getElementById(markerId);
        if (element != null && element instanceof IMarker) {
            return (IMarker)element;
        }
        return null;
    }

    @Override
    protected IMarkerGroup getLocalMarkerGroup(String groupId) {
        Object element = this.getElementById(groupId);
        if (element != null && element instanceof IMarkerGroup) {
            return (IMarkerGroup)element;
        }
        return null;
    }

    @Override
    public List<IMarkerGroup> getMarkerGroups() {
        return DOMUtils.getChildList(this.getSheetElement(), "marker-group", this.getElementAdapterProvider());
    }

    @Override
    public void addMarkerGroup(IMarkerGroup group) {
        int index;
        Element g = ((MarkerGroupImpl)group).getImplementation();
        Element s = this.getSheetElement();
        Node n = s.appendChild(g);
        if (n != null && (index = DOMUtils.getElementIndex(s, "marker-group", g)) >= 0) {
            this.fireIndexedTargetChange("markerGroupAdd", group, index);
        }
    }

    @Override
    public void removeMarkerGroup(IMarkerGroup group) {
        Node n;
        int index;
        Element g = ((MarkerGroupImpl)group).getImplementation();
        Element s = this.getSheetElement();
        if (g.getParentNode() == s && (index = DOMUtils.getElementIndex(s, "marker-group", g)) >= 0 && (n = s.removeChild(g)) != null) {
            this.fireIndexedTargetChange("markerGroupRemove", group, index);
        }
    }

    @Override
    public boolean isEmpty() {
        return !this.getSheetElement().hasChildNodes();
    }

    protected Object getElementById(String id) {
        Element domElement;
        Object element = this.getElementRegistry().getElement(id);
        if (element == null && (domElement = this.implementation.getElementById(id)) != null) {
            element = this.getElementAdapter(domElement);
        }
        return element;
    }

    public ElementRegistry getElementRegistry() {
        if (this.elementRegistry == null) {
            this.elementRegistry = new ElementRegistry();
        }
        return this.elementRegistry;
    }

    protected NodeAdaptableProvider getElementAdapterProvider() {
        if (this.elementAdaptableProvider == null) {
            this.elementAdaptableProvider = new NodeAdaptableProvider(this.getElementRegistry(), this, this.implementation);
        }
        return this.elementAdaptableProvider;
    }

    protected IAdaptable getElementAdapter(Node node) {
        return this.getElementAdapterProvider().getAdaptable(node);
    }

    @Override
    public IAdaptable createAdaptable(Node node) {
        if (node instanceof Element) {
            Element e = (Element)node;
            String tagName = e.getTagName();
            if ("marker-group".equals(tagName)) {
                return new MarkerGroupImpl(e, this);
            }
            if (OLD_TAG_MARKER.equals(tagName)) {
                return new MarkerImpl(e, this);
            }
        }
        return null;
    }

    @Override
    public void save(OutputStream out) throws IOException, CoreException {
        DOMUtils.save(this.implementation, out, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importFrom(String sourcePath) throws IOException, CoreException {
        File sourceFile = new File(sourcePath);
        IInputSource source = sourceFile.isDirectory() ? new DirectoryInputSource(sourceFile) : new ZipFileInputSource(new ZipFile(sourceFile));
        try {
            this.importFrom(source, new File(sourcePath).getName());
        }
        finally {
            if (source instanceof ZipFileInputSource) {
                ((ZipFileInputSource)source).closeZipFile();
            }
        }
    }

    @Override
    public void importFrom(IInputSource source) throws IOException, CoreException {
        this.importFrom(source, null);
    }

    @Override
    public void importFrom(IInputSource source, String groupName) throws IOException, CoreException {
        if (source.hasEntry("markerSheet.xml")) {
            InputStream is = source.getEntryStream("markerSheet.xml");
            if (is == null) {
                throw new IOException();
            }
            IMarkerSheet sourceMarkerSheet = Core.getMarkerSheetBuilder().loadFromStream(is, new MarkerResourceProvider(source, null));
            this.importFrom(sourceMarkerSheet);
        } else if (source.hasEntry(OLD_MARKERLISTS_XML)) {
            this.importFromOldMarkerSheet(source);
        } else {
            this.importAllAsNewGroup(source, groupName);
        }
    }

    private void importAllAsNewGroup(IInputSource source, String groupName) {
        IMarkerGroup group = this.createMarkerGroup(false);
        if (groupName == null) {
            groupName = this.createGroupName();
        }
        group.setName(groupName);
        Iterator<String> entries = source.getEntries();
        while (entries.hasNext()) {
            OutputStream os;
            String entry = entries.next();
            InputStream is = source.getEntryStream(entry);
            if (is == null) continue;
            IMarker marker = this.createMarker(entry);
            marker.setName(FileUtils.getFileName(entry));
            group.addMarker(marker);
            IMarkerResource resource = marker.getResource();
            if (resource == null || (os = resource.getOutputStream()) == null) continue;
            try {
                FileUtils.transfer(is, os, true);
            }
            catch (IOException ignore) {}
        }
        this.addMarkerGroup(group);
    }

    private String createGroupName() {
        return "Group " + (this.getMarkerGroups().size() + 1);
    }

    private void importFromOldMarkerSheet(IInputSource source) throws IOException {
        InputStream is = source.getEntryStream(OLD_MARKERLISTS_XML);
        if (is == null) {
            throw new FileNotFoundException();
        }
        Document document = DOMUtils.loadDocument(is);
        Iterator<Element> listIt = DOMUtils.childElementIterByTag(document.getDocumentElement(), OLD_TAG_MARKER_LIST);
        while (listIt.hasNext()) {
            Element listEle = listIt.next();
            String listId = listEle.getAttribute(OLD_ATT_ID);
            IMarkerGroup existingGroup = this.findMarkerGroup(listId);
            if (existingGroup != null) {
                this.importGroupFromOld(source, listEle, existingGroup);
                continue;
            }
            IMarkerGroup newGroup = this.createMarkerGroup(false);
            this.replaceId(newGroup, listId);
            this.addMarkerGroup(newGroup);
            this.importGroupFromOld(source, listEle, newGroup);
        }
    }

    private void replaceId(IAdaptable adaptable, String newId) {
        Element ele = (Element)adaptable.getAdapter(Element.class);
        if (ele == null) {
            return;
        }
        String oldId = ele.getAttribute(OLD_ATT_ID);
        this.getElementRegistry().unregisterByKey(oldId);
        ele.setAttribute(OLD_ATT_ID, newId);
        this.getElementRegistry().registerByKey(newId, adaptable);
    }

    private void importGroupFromOld(IInputSource source, Element listEle, IMarkerGroup targetGroup) throws IOException {
        targetGroup.setName(listEle.getAttribute(OLD_ATT_NAME));
        Iterator<Element> markerIt = DOMUtils.childElementIterByTag(listEle, OLD_TAG_MARKER);
        while (markerIt.hasNext()) {
            OutputStream os;
            Element markerEle = markerIt.next();
            String file = DOMUtils.getAttribute(markerEle, OLD_ATT_FILE);
            if (file == null) continue;
            String markerId = markerEle.getAttribute(OLD_ATT_ID);
            IMarker targetMarker = this.findMarker(markerId);
            if (targetMarker == null) {
                targetMarker = this.createMarker(this.createGroupName() + FileUtils.getExtension(file));
                this.replaceId(targetMarker, markerId);
                targetGroup.addMarker(targetMarker);
            }
            targetMarker.setName(markerEle.getAttribute(OLD_ATT_NAME));
            String oldEntryName = listEle.getAttribute(OLD_ATT_ID) + "/" + file;
            IMarkerResource newRes = targetMarker.getResource();
            if (newRes == null || (os = newRes.getOutputStream()) == null || !source.hasEntry(oldEntryName)) continue;
            InputStream mis = source.getEntryStream(oldEntryName);
            FileUtils.transfer(mis, os, true);
        }
    }

    @Override
    public void importFrom(IMarkerSheet sheet) {
        for (IMarkerGroup group : sheet.getMarkerGroups()) {
            this.importGroup(group);
        }
    }

    @Override
    public IMarkerGroup importGroup(IMarkerGroup group) {
        String id = group.getId();
        IMarkerGroup existingGroup = this.findMarkerGroup(id);
        if (existingGroup != null) {
            existingGroup.setName(group.getName());
            if (existingGroup.getParent() == null) {
                this.addMarkerGroup(existingGroup);
            }
            this.importGroup(group, existingGroup);
            return existingGroup;
        }
        IMarkerGroup targetGroup = this.createMarkerGroup(group.isSingleton());
        this.replaceId(targetGroup, group.getId());
        targetGroup.setName(group.getName());
        this.importGroup(group, targetGroup);
        this.addMarkerGroup(targetGroup);
        return targetGroup;
    }

    private void importGroup(IMarkerGroup sourceGroup, IMarkerGroup targetGroup) {
        for (IMarker sourceMarker : sourceGroup.getMarkers()) {
            OutputStream os;
            IMarkerResource targetRes;
            InputStream is;
            String id = sourceMarker.getId();
            IMarker targetMarker = this.getLocalMarker(id);
            if (targetMarker == null || !targetGroup.equals(targetMarker.getParent())) {
                targetMarker = this.createMarker(sourceMarker.getResourcePath());
                this.replaceId(targetMarker, sourceMarker.getId());
                targetGroup.addMarker(targetMarker);
            }
            targetMarker.setName(sourceMarker.getName());
            IMarkerResource sourceRes = sourceMarker.getResource();
            if (sourceRes == null || (is = sourceRes.getInputStream()) == null || (targetRes = targetMarker.getResource()) == null || (os = targetRes.getOutputStream()) == null) continue;
            try {
                FileUtils.transfer(is, os, true);
            }
            catch (IOException e) {}
        }
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener(this, type, listener);
    }

    @Override
    public ICoreEventSupport getCoreEventSupport() {
        if (this.coreEventSupport != null) {
            return this.coreEventSupport;
        }
        this.coreEventSupport = new CoreEventSupport();
        return this.coreEventSupport;
    }

    private void fireIndexedTargetChange(String type, Object target, int index) {
        this.getCoreEventSupport().dispatchIndexedTargetChange(this, type, target, index);
    }
}

