/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.Core;
import org.xmind.core.IAdaptable;
import org.xmind.core.IFileEntry;
import org.xmind.core.IManifest;
import org.xmind.core.IRevisionManager;
import org.xmind.core.IWorkbook;
import org.xmind.core.internal.Revision;
import org.xmind.core.internal.dom.NumberUtils;
import org.xmind.core.internal.dom.RevisionManagerImpl;
import org.xmind.core.internal.dom.SheetImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.util.DOMUtils;

public class RevisionImpl
extends Revision {
    private Element implementation;
    private RevisionManagerImpl parent;
    private IAdaptable content = null;

    public RevisionImpl(Element implementation, RevisionManagerImpl parent) {
        this.implementation = implementation;
        this.parent = parent;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof RevisionImpl)) {
            return false;
        }
        RevisionImpl that = (RevisionImpl)obj;
        return this.implementation.equals(that.implementation);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Node.class || adapter == Element.class) {
            return this.getImplementation();
        }
        return super.getAdapter(adapter);
    }

    public Element getImplementation() {
        return this.implementation;
    }

    public IRevisionManager getOwnedManager() {
        return this.parent;
    }

    public String getContentType() {
        return this.parent.getContentType();
    }

    public String getResourceId() {
        return this.parent.getResourceId();
    }

    public int getRevisionNumber() {
        String num = this.getImplementation().getAttribute("rev-num");
        return NumberUtils.safeParseInt(num, 0);
    }

    public long getTimestamp() {
        String num = this.getImplementation().getAttribute("timestamp");
        return NumberUtils.safeParseLong(num, 0L);
    }

    public IAdaptable getContent() {
        if (this.content == null) {
            this.content = this.loadContent();
        }
        return this.content;
    }

    public String getResourcePath() {
        return this.getImplementation().getAttribute("resource");
    }

    private IAdaptable loadContent() {
        Node ele;
        Element docEle;
        String path = this.getResourcePath();
        Document doc = this.loadDocument(path);
        if (doc != null && (docEle = doc.getDocumentElement()) != null && (ele = docEle.getFirstChild()) != null) {
            return this.parent.getAdaptableFactory().createAdaptable(ele);
        }
        return null;
    }

    private Document loadDocument(String path) {
        InputStream stream;
        IFileEntry entry = this.getOwnedWorkbook().getManifest().getFileEntry(path);
        if (entry != null && (stream = entry.getInputStream()) != null) {
            try {
                return DOMUtils.loadDocument(stream);
            }
            catch (Throwable e) {
                Core.getLogger().log(e, "Failed to load content from " + path);
            }
        }
        return null;
    }

    public IWorkbook getOwnedWorkbook() {
        return this.parent.getOwnedWorkbook();
    }

    public boolean isOrphan() {
        return DOMUtils.isOrphanNode(this.getImplementation());
    }

    protected void addNotify(WorkbookImpl workbook) {
        this.increaseFileEntryReference();
        if ("application/vnd.xmind.sheet".equals(this.getContentType()) && this.getContent() instanceof SheetImpl) {
            ((SheetImpl)this.getContent()).addNotify(workbook);
        }
    }

    protected void removeNotify(WorkbookImpl workbook) {
        if ("application/vnd.xmind.sheet".equals(this.getContentType()) && this.getContent() instanceof SheetImpl) {
            ((SheetImpl)this.getContent()).removeNotify(workbook);
        }
        this.decreaseFileEntryReference();
    }

    private void increaseFileEntryReference() {
        String path = this.getResourcePath();
        if (path == null || "".equals(path)) {
            return;
        }
        IManifest manifest = this.parent.getOwnedWorkbook().getManifest();
        IFileEntry entry = manifest.getFileEntry(path);
        if (entry != null) {
            entry.increaseReference();
        }
    }

    private void decreaseFileEntryReference() {
        String path = this.getResourcePath();
        if (path == null || "".equals(path)) {
            return;
        }
        IManifest manifest = this.parent.getOwnedWorkbook().getManifest();
        IFileEntry entry = manifest.getFileEntry(path);
        if (entry != null) {
            entry.decreaseReference();
        }
    }
}

