/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xmind.core.CoreException;
import org.xmind.core.IAdaptable;
import org.xmind.core.IFileEntry;
import org.xmind.core.IRevision;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.RevisionManager;
import org.xmind.core.internal.dom.INodeAdaptableFactory;
import org.xmind.core.internal.dom.NS;
import org.xmind.core.internal.dom.NodeAdaptableRegistry;
import org.xmind.core.internal.dom.NumberUtils;
import org.xmind.core.internal.dom.RevisionImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevisionManagerImpl
extends RevisionManager
implements ICoreEventSource,
INodeAdaptableFactory {
    private Document implementation;
    private WorkbookImpl ownedWorkbook;
    private NodeAdaptableRegistry registry;
    private ICoreEventSupport coreEventSupport;
    private String dirPath;

    public RevisionManagerImpl(Document implementation, WorkbookImpl ownedWorkbook, String dirPath) {
        this.implementation = implementation;
        this.ownedWorkbook = ownedWorkbook;
        this.dirPath = dirPath;
        this.registry = new NodeAdaptableRegistry(implementation, this);
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof RevisionManagerImpl)) {
            return false;
        }
        RevisionManagerImpl that = (RevisionManagerImpl)obj;
        return this.implementation.equals(that.implementation);
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == Node.class || adapter == Document.class) {
            return this.getImplementation();
        }
        return super.getAdapter(adapter);
    }

    public Document getImplementation() {
        return this.implementation;
    }

    protected Element getRevisionsElement() {
        return this.implementation.getDocumentElement();
    }

    protected INodeAdaptableFactory getAdaptableFactory() {
        return this.ownedWorkbook;
    }

    @Override
    public IAdaptable createAdaptable(Node node) {
        return new RevisionImpl((Element)node, this);
    }

    protected String getDirPath() {
        return this.dirPath;
    }

    @Override
    public String getResourceId() {
        return this.getRevisionsElement().getAttribute("resource-id");
    }

    @Override
    public String getContentType() {
        return this.getRevisionsElement().getAttribute("media-type");
    }

    @Override
    public Iterator<IRevision> iterRevisions() {
        return new DOMUtils.AdaptableIterator<IRevision>(this.getRevisionsElement(), "revision", this.registry, false);
    }

    @Override
    public Iterator<IRevision> iterRevisionsReversed() {
        return new DOMUtils.AdaptableIterator<IRevision>(this.getRevisionsElement(), "revision", this.registry, true);
    }

    @Override
    public IRevision getLatestRevision() {
        Node node = this.getLastRevisionNode();
        return node == null ? null : (IRevision)this.registry.getAdaptable(node);
    }

    protected Node getLastRevisionNode() {
        Node node;
        for (node = this.getRevisionsElement().getLastChild(); node != null && !DOMUtils.isElementByTag(node, "revision"); node = node.getPreviousSibling()) {
        }
        return node;
    }

    @Override
    public int getNextRevisionNumber() {
        String num = this.getRevisionsElement().getAttribute("next-rev-num");
        return NumberUtils.safeParseInt(num, 1);
    }

    @Override
    public IRevision addRevision(IAdaptable content) throws IOException, CoreException {
        Object latestNode;
        IAdaptable latestContent;
        Node node = (Node)content.getAdapter(Node.class);
        if (node == null) {
            throw new CoreException(3, "Invalid content for content type: " + this.getContentType());
        }
        IRevision latest = this.getLatestRevision();
        if (latest != null && (latestContent = latest.getContent()) != null && (latestNode = latestContent.getAdapter(Node.class)) != null && latestNode.equals(node)) {
            return null;
        }
        int revNum = this.getNextRevisionNumber();
        long timestamp = System.currentTimeMillis();
        String path = this.takeSnapshot(node, revNum, timestamp);
        RevisionImpl revision = this.createRevision(revNum, timestamp, path);
        this.setNextRevisionNumber(revNum + 1);
        revision.addNotify(this.ownedWorkbook);
        this.fireTargetEvent("revisionAdd", revision);
        return revision;
    }

    private void setNextRevisionNumber(int nextRevNum) {
        this.getRevisionsElement().setAttribute("next-rev-num", String.valueOf(nextRevNum));
    }

    private RevisionImpl createRevision(int revNum, long timestamp, String path) {
        Element ele = this.implementation.createElement("revision");
        ele.setAttribute("rev-num", String.valueOf(revNum));
        ele.setAttribute("timestamp", String.valueOf(timestamp));
        ele.setAttribute("resource", path);
        this.getRevisionsElement().appendChild(ele);
        return new RevisionImpl(ele, this);
    }

    private String takeSnapshot(Node source, int revNum, long timestamp) throws IOException, CoreException {
        Document doc = DOMUtils.createDocument("xmap-revision-content");
        Element docEle = doc.getDocumentElement();
        NS.setNS(NS.Revision, docEle, NS.Xhtml, NS.Xlink, NS.SVG, NS.Fo);
        Node snapshot = doc.importNode(source, true);
        docEle.appendChild(snapshot);
        String path = this.getDirPath() + this.getFileName(revNum, timestamp, "xml");
        IFileEntry entry = this.ownedWorkbook.getManifest().createFileEntry(path);
        OutputStream stream = entry.openOutputStream();
        DOMUtils.save(doc, stream, true);
        return path;
    }

    private String getFileName(int revNum, long timestamp, String extName) {
        return String.format("rev-%s-%s.%s", revNum, timestamp, extName);
    }

    @Override
    public Object removeRevision(IRevision revision) {
        RevisionImpl rev = (RevisionImpl)revision;
        Element ele = rev.getImplementation();
        Element parentEle = this.getRevisionsElement();
        int index = DOMUtils.getNodeIndex(parentEle, ele);
        if (index < 0) {
            return null;
        }
        rev.removeNotify(this.ownedWorkbook);
        parentEle.removeChild(ele);
        this.fireTargetEvent("revisionRemove", revision);
        return index;
    }

    @Override
    public void restoreRevision(IRevision revision, Object removal) {
        if (!(removal instanceof Integer)) {
            throw new IllegalArgumentException("Invalid removal object");
        }
        int index = (Integer)removal;
        RevisionImpl rev = (RevisionImpl)revision;
        Element ele = rev.getImplementation();
        Element parentEle = this.getRevisionsElement();
        NodeList childNodes = parentEle.getChildNodes();
        if (index < childNodes.getLength()) {
            parentEle.insertBefore(ele, childNodes.item(index));
        } else {
            parentEle.appendChild(ele);
        }
        ((RevisionImpl)revision).addNotify(this.ownedWorkbook);
        this.fireTargetEvent("revisionAdd", revision);
    }

    @Override
    public IWorkbook getOwnedWorkbook() {
        return this.ownedWorkbook;
    }

    @Override
    public boolean isOrphan() {
        IFileEntry metaEntry = this.ownedWorkbook.getManifest().getFileEntry(this.getDirPath() + "revisions.xml");
        return metaEntry == null || metaEntry.isOrphan();
    }

    protected void addNotify(WorkbookImpl workbook) {
        this.increaseFileEntryReference();
        Iterator<IRevision> it = this.iterRevisions();
        while (it.hasNext()) {
            ((RevisionImpl)it.next()).addNotify(workbook);
        }
    }

    protected void removeNotify(WorkbookImpl workbook) {
        Iterator<IRevision> it = this.iterRevisionsReversed();
        while (it.hasNext()) {
            ((RevisionImpl)it.next()).removeNotify(workbook);
        }
        this.decreaseFileEntryReference();
    }

    private void increaseFileEntryReference() {
        IFileEntry entry = this.getMetaFileEntry();
        if (entry != null) {
            entry.increaseReference();
        }
    }

    private void decreaseFileEntryReference() {
        IFileEntry entry = this.getMetaFileEntry();
        if (entry != null) {
            entry.decreaseReference();
        }
    }

    private IFileEntry getMetaFileEntry() {
        String path = this.dirPath + "revisions.xml";
        return this.ownedWorkbook.getManifest().getFileEntry(path);
    }

    @Override
    public ICoreEventSupport getCoreEventSupport() {
        if (this.coreEventSupport == null) {
            this.coreEventSupport = this.ownedWorkbook.getCoreEventSupport();
        }
        return this.coreEventSupport;
    }

    @Override
    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerGlobalListener(type, listener);
    }

    private void fireTargetEvent(String eventType, IRevision revision) {
        this.getCoreEventSupport().dispatchTargetChange(this, eventType, revision);
    }
}

