/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.Collections;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.ILegend;
import org.xmind.core.IRelationship;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.Sheet;
import org.xmind.core.internal.dom.LegendImpl;
import org.xmind.core.internal.dom.NumberUtils;
import org.xmind.core.internal.dom.RelationshipImpl;
import org.xmind.core.internal.dom.SheetLabelRefCounter;
import org.xmind.core.internal.dom.SheetMarkerRefCounter;
import org.xmind.core.internal.dom.TopicImpl;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.internal.dom.WorkbookUtilsImpl;
import org.xmind.core.internal.event.CoreEventSupport;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.ILabelRefCounter;
import org.xmind.core.util.IMarkerRefCounter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SheetImpl
extends Sheet
implements ICoreEventSource {
    private static final Set<IRelationship> NO_RELATIONSHIPS = Collections.emptySet();
    private Element implementation;
    private WorkbookImpl ownedWorkbook;
    private SheetMarkerRefCounter markerRefCounter = null;
    private SheetLabelRefCounter labelRefCounter = null;
    private LegendImpl legend = null;
    private CoreEventSupport coreEventSupport = null;

    public SheetImpl(Element implementation, WorkbookImpl ownedWorkbook) {
        this.ownedWorkbook = ownedWorkbook;
        this.implementation = DOMUtils.addIdAttribute(implementation);
        DOMUtils.ensureChildElement(implementation, "topic");
    }

    public Element getImplementation() {
        return this.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof SheetImpl)) {
            return false;
        }
        SheetImpl t = (SheetImpl)obj;
        return this.implementation == t.implementation;
    }

    @Override
    public String toString() {
        return "SHT#" + this.getId() + "(" + this.getTitleText() + ")";
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == Element.class || adapter == Node.class) {
            return this.implementation;
        }
        if (adapter == IMarkerRefCounter.class) {
            return this.getMarkerRefCounter();
        }
        if (adapter == ILabelRefCounter.class) {
            return this.getLabelRefCounter();
        }
        if (adapter == ICoreEventSupport.class) {
            return this.getCoreEventSupport();
        }
        return super.getAdapter(adapter);
    }

    @Override
    protected String getLocalTitleText() {
        return DOMUtils.getTextContentByTag(this.implementation, "title");
    }

    @Override
    public void setTitleText(String titleText) {
        String oldValue = this.getLocalTitleText();
        DOMUtils.setText(this.implementation, "title", titleText);
        String newValue = this.getLocalTitleText();
        this.fireValueChange("titleText", oldValue, newValue);
        this.updateModifiedTime();
    }

    @Override
    public ITopic getRootTopic() {
        Element t = DOMUtils.getFirstChildElementByTag(this.implementation, "topic");
        return (ITopic)this.ownedWorkbook.getAdaptableRegistry().getAdaptable(t);
    }

    @Override
    public String getId() {
        return this.implementation.getAttribute("id");
    }

    @Override
    public IWorkbook getOwnedWorkbook() {
        return this.ownedWorkbook;
    }

    @Override
    public boolean isOrphan() {
        return DOMUtils.isOrphanNode(this.implementation);
    }

    @Override
    public IWorkbook getParent() {
        Node p = this.implementation.getParentNode();
        if (p == this.ownedWorkbook.getWorkbookElement()) {
            return this.ownedWorkbook;
        }
        return null;
    }

    @Override
    public int getIndex() {
        Node p = this.implementation.getParentNode();
        if (p == this.ownedWorkbook.getWorkbookElement()) {
            return DOMUtils.getElementIndex(p, "sheet", this.implementation);
        }
        return -1;
    }

    @Override
    public Set<IRelationship> getRelationships() {
        Element rs = DOMUtils.getFirstChildElementByTag(this.implementation, "relationships");
        if (rs != null) {
            return DOMUtils.getChildSet(rs, "relationship", this.ownedWorkbook.getAdaptableRegistry());
        }
        return NO_RELATIONSHIPS;
    }

    @Override
    public void addRelationship(IRelationship rel) {
        Element r;
        Element rs = DOMUtils.ensureChildElement(this.implementation, "relationships");
        Node n = rs.appendChild(r = ((RelationshipImpl)rel).getImplementation());
        if (n != null) {
            if (!this.isOrphan()) {
                ((RelationshipImpl)rel).addNotify(this.ownedWorkbook, this);
            }
            this.fireTargetChange("relationshipAdd", rel);
        }
    }

    @Override
    public void removeRelationship(IRelationship rel) {
        Element rs = DOMUtils.getFirstChildElementByTag(this.implementation, "relationships");
        if (rs != null) {
            if (!this.isOrphan()) {
                ((RelationshipImpl)rel).removeNotify(this.ownedWorkbook, this);
            }
            Element r = ((RelationshipImpl)rel).getImplementation();
            Node n = rs.removeChild(r);
            if (!rs.hasChildNodes()) {
                this.implementation.removeChild(rs);
            }
            if (n != null) {
                this.fireTargetChange("relationshipRemove", rel);
                this.updateModifiedTime();
            }
        }
    }

    @Override
    public String getThemeId() {
        return DOMUtils.getAttribute(this.implementation, "theme");
    }

    @Override
    public void setThemeId(String themeId) {
        String oldValue = this.getThemeId();
        WorkbookImpl workbook = (WorkbookImpl)this.getParent();
        this.decreaseThemeRef(workbook);
        DOMUtils.setAttribute(this.implementation, "theme", themeId);
        this.increaseThemeRef(workbook);
        String newValue = this.getThemeId();
        this.fireValueChange("themeId", oldValue, newValue);
        this.updateModifiedTime();
    }

    @Override
    public String getStyleId() {
        return DOMUtils.getAttribute(this.implementation, "style-id");
    }

    @Override
    public void setStyleId(String styleId) {
        String oldValue = this.getStyleId();
        WorkbookImpl workbook = (WorkbookImpl)this.getParent();
        WorkbookUtilsImpl.decreaseStyleRef(workbook, this);
        DOMUtils.setAttribute(this.implementation, "style-id", styleId);
        WorkbookUtilsImpl.increaseStyleRef(workbook, this);
        String newValue = this.getStyleId();
        this.fireValueChange("style", oldValue, newValue);
        this.updateModifiedTime();
    }

    @Override
    public void replaceRootTopic(ITopic newRootTopic) {
        TopicImpl r1 = (TopicImpl)this.getRootTopic();
        TopicImpl r2 = (TopicImpl)newRootTopic;
        if (!this.isOrphan()) {
            r1.removeNotify((WorkbookImpl)this.getParent(), this, null);
        }
        this.implementation.removeChild(r1.getImplementation());
        this.implementation.appendChild(r2.getImplementation());
        if (!this.isOrphan()) {
            r2.addNotify((WorkbookImpl)this.getParent(), this, null);
        }
        this.fireValueChange("rootTopic", r1, r2);
        this.updateModifiedTime();
    }

    @Override
    public ILegend getLegend() {
        if (this.legend == null) {
            this.legend = new LegendImpl(this.implementation, this);
        }
        return this.legend;
    }

    public ILabelRefCounter getLabelRefCounter() {
        if (this.labelRefCounter == null) {
            this.labelRefCounter = new SheetLabelRefCounter(this);
        }
        return this.labelRefCounter;
    }

    public IMarkerRefCounter getMarkerRefCounter() {
        if (this.markerRefCounter == null) {
            this.markerRefCounter = new SheetMarkerRefCounter(this);
        }
        return this.markerRefCounter;
    }

    protected void addNotify(WorkbookImpl workbook) {
        this.getImplementation().setIdAttribute("id", true);
        workbook.getAdaptableRegistry().registerById(this, this.getId(), this.getImplementation().getOwnerDocument());
        ((CoreEventSupport)this.getCoreEventSupport()).setParent(workbook.getCoreEventSupport());
        WorkbookUtilsImpl.increaseStyleRef(workbook, this);
        this.increaseThemeRef(workbook);
        ((TopicImpl)this.getRootTopic()).addNotify(workbook, this, null);
        for (IRelationship rel : this.getRelationships()) {
            ((RelationshipImpl)rel).addNotify(workbook, this);
        }
    }

    protected void removeNotify(WorkbookImpl workbook) {
        for (IRelationship rel : this.getRelationships()) {
            ((RelationshipImpl)rel).removeNotify(workbook, this);
        }
        ((TopicImpl)this.getRootTopic()).removeNotify(workbook, this, null);
        this.decreaseThemeRef(workbook);
        WorkbookUtilsImpl.decreaseStyleRef(workbook, this);
        ((CoreEventSupport)this.getCoreEventSupport()).setParent(null);
        workbook.getAdaptableRegistry().unregisterById(this, this.getId(), this.getImplementation().getOwnerDocument());
        this.getImplementation().setIdAttribute("id", false);
    }

    private void decreaseThemeRef(WorkbookImpl workbook) {
        String themeId = this.getThemeId();
        if (themeId != null) {
            workbook.getStyleRefCounter().decreaseRef(themeId);
        }
    }

    private void increaseThemeRef(WorkbookImpl workbook) {
        String themeId = this.getThemeId();
        if (themeId != null) {
            workbook.getStyleRefCounter().increaseRef(themeId);
        }
    }

    @Override
    public ICoreEventSupport getCoreEventSupport() {
        if (this.coreEventSupport == null) {
            this.coreEventSupport = new CoreEventSupport();
        }
        return this.coreEventSupport;
    }

    @Override
    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener(this, type, listener);
    }

    private void fireValueChange(String type, Object oldValue, Object newValue) {
        ICoreEventSupport coreEventSupport = this.getCoreEventSupport();
        if (coreEventSupport != null) {
            coreEventSupport.dispatchValueChange(this, type, oldValue, newValue);
        }
    }

    private void fireTargetChange(String type, Object target) {
        ICoreEventSupport coreEventSupport = this.getCoreEventSupport();
        if (coreEventSupport != null) {
            coreEventSupport.dispatchTargetChange(this, type, target);
        }
    }

    @Override
    public long getModifiedTime() {
        String time = DOMUtils.getAttribute(this.implementation, "timestamp");
        return NumberUtils.safeParseLong(time, 0L);
    }

    public void updateModifiedTime() {
        this.setModifiedTime(System.currentTimeMillis());
        IWorkbook workbook = this.getParent();
        if (workbook != null) {
            ((WorkbookImpl)workbook).updateModifiedTime();
        }
    }

    public void setModifiedTime(long time) {
        long oldTime = this.getModifiedTime();
        DOMUtils.setAttribute(this.implementation, "timestamp", Long.toString(time));
        long newTime = this.getModifiedTime();
        this.fireValueChange("modifyTime", oldTime, newTime);
    }
}

