/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.io;

import java.io.File;
import java.io.FileFilter;
import org.xmind.core.io.DirectoryInputSource;
import org.xmind.core.io.DirectoryOutputTarget;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.util.FileUtils;

public class DirectoryStorage
implements IStorage {
    private File dir;
    private FileFilter filter;

    public DirectoryStorage(File dir) {
        this(dir, null);
    }

    public DirectoryStorage(File dir, FileFilter filter) {
        this.dir = dir;
        this.filter = filter;
    }

    public String getFullPath() {
        return this.dir.getAbsolutePath();
    }

    public IInputSource getInputSource() {
        return new DirectoryInputSource(this.dir, this.filter);
    }

    public String getName() {
        return this.dir.getName();
    }

    public IOutputTarget getOutputTarget() {
        return new DirectoryOutputTarget(this.dir);
    }

    public void clear() {
        FileUtils.delete(this.dir);
    }
}

