/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl.aggregation;

import com.github.fakemongo.impl.ExpressionParser;
import com.github.fakemongo.impl.aggregation.PipelineKeyword;
import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.annotations.ThreadSafe;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bucket
extends PipelineKeyword {
    public static final Bucket INSTANCE = new Bucket();
    private static final Logger LOGGER = LoggerFactory.getLogger(Bucket.class);
    private static final String ID = "_id";

    @Override
    public DBCollection apply(DB originalDB, DBCollection parentColl, DBObject aggQuery) {
        LOGGER.trace(">>>> applying $bucket pipeline operation");
        DBObject lookup = ExpressionParser.toDbObject(aggQuery.get(this.getKeyword()));
        Collection<DBObject> parentItems = this.bucketize(parentColl, lookup);
        ArrayList<DBObject> dbObjects = new ArrayList<DBObject>();
        for (DBObject object : parentItems) {
            Object obj = object.removeField(ID);
            if (object.keySet().size() <= 0) continue;
            object.put(ID, obj);
            dbObjects.add(object);
        }
        LOGGER.trace("<<<< applying $bucket pipeline operation");
        return this.dropAndInsert(parentColl, dbObjects);
    }

    private Collection<DBObject> bucketize(DBCollection parentColl, DBObject lookup) {
        LOGGER.trace(">>>> Bucketizing collection ");
        Object groupByObj = lookup.get("groupBy");
        Bucket.validateNull(groupByObj, "groupBy param must not be null");
        Object boundariesObj = lookup.get("boundaries");
        Bucket.validateNull(boundariesObj, "boundaries param must not be null");
        Bucket.validateTrue(List.class.isAssignableFrom(boundariesObj.getClass()), "boundaries must be of list type");
        List boundariesList = (List)boundariesObj;
        for (Object b : boundariesList) {
            Bucket.validateTrue(Number.class.isAssignableFrom(b.getClass()), "Boundary entry " + b.toString() + " is not numeric");
        }
        List boundaries = boundariesList;
        HashMap<String, DBObject> histograms = new HashMap<String, DBObject>();
        for (Number number : boundaries) {
            BasicDBObject basicDBObject = new BasicDBObject();
            String _idValue = String.valueOf(number);
            basicDBObject.put((Object)ID, (Object)_idValue);
            histograms.put(_idValue, (DBObject)basicDBObject);
        }
        Bucket.validateTrue(boundariesList.size() > 1, "boundaries must have at least two elements");
        Object defaultGroupObj = lookup.get("default");
        String defaultGroup = null;
        if (defaultGroupObj != null) {
            Bucket.validateTrue(String.class.isAssignableFrom(defaultGroupObj.getClass()), "default must be a string");
            defaultGroup = (String)defaultGroupObj;
            BasicDBObject b = new BasicDBObject();
            b.put((Object)ID, (Object)defaultGroup);
            histograms.put(defaultGroup, (DBObject)b);
        }
        DBObject output = ExpressionParser.toDbObject(lookup.get("output"));
        Collection<DBObject> groupedColl = this.bucketize(histograms, parentColl, groupByObj, boundaries, defaultGroup, output);
        LOGGER.trace("<<<< Bucketizing collection ");
        return groupedColl;
    }

    private Collection<DBObject> bucketize(Map<String, DBObject> histograms, DBCollection parentColl, Object groupByObj, List<Number> boundaries, String defaultGroup, DBObject output) {
        DBCursor cursor = parentColl.find();
        while (cursor.hasNext()) {
            DBObject object = cursor.next();
            if (!String.class.isAssignableFrom(groupByObj.getClass())) continue;
            this.updateBucket(histograms, object, (String)groupByObj, boundaries, defaultGroup, output);
        }
        return histograms.values();
    }

    private void updateBucket(Map<String, DBObject> histograms, DBObject inputObj, String groupByObj, List<Number> boundariesList, String defaultGroup, DBObject output) {
        Bucket.validateTrue(groupByObj.charAt(0) == '$', "only single field grouping is supported currently and must start with $");
        String field = groupByObj.substring(1);
        Object groupedField = inputObj.get(field);
        Number number = null;
        boolean bucketMatchFound = false;
        int index = 1;
        Number lb = boundariesList.get(0);
        if (groupedField != null) {
            Bucket.validateTrue(Number.class.isAssignableFrom(groupedField.getClass()), "groupBy field value must be numeric");
            number = (Number)inputObj.get(field);
        } else {
            bucketMatchFound = true;
            index = boundariesList.size() + 1;
        }
        while (!bucketMatchFound && index < boundariesList.size()) {
            Number ub = boundariesList.get(index);
            if (number.doubleValue() >= lb.doubleValue() && number.doubleValue() < ub.doubleValue()) {
                bucketMatchFound = true;
                continue;
            }
            lb = ub;
            ++index;
        }
        DBObject matchedHistogramBucket = null;
        if (bucketMatchFound && index < boundariesList.size()) {
            Number boundary = boundariesList.get(index - 1);
            matchedHistogramBucket = histograms.get(String.valueOf(boundary));
        }
        if (matchedHistogramBucket == null) {
            if (defaultGroup == null) {
                fongo.errorResult(15955, "Must specify defaultGroup for unmatched buckets").throwOnError();
            }
            matchedHistogramBucket = histograms.get(defaultGroup);
        }
        if (output == null) {
            Integer value = (Integer)matchedHistogramBucket.get("count");
            if (value == null) {
                value = 0;
                matchedHistogramBucket.put("count", (Object)value);
            }
            value = value + 1;
            matchedHistogramBucket.put("count", (Object)value);
        } else {
            Set keys = output.keySet();
            for (String key : keys) {
                DBObject accumulatorExpr = (DBObject)output.get(key);
                for (BucketAccumulator accumulator : BucketAccumulator.values()) {
                    if (!accumulator.canApply(accumulatorExpr)) continue;
                    accumulator.apply(inputObj, key, matchedHistogramBucket, accumulatorExpr);
                }
            }
        }
    }

    @Override
    public String getKeyword() {
        return "$bucket";
    }

    @ThreadSafe
    static enum BucketAccumulator {
        SUM("$sum"){

            @Override
            void apply(DBObject input, String outputKey, DBObject matchedHistogramBucket, DBObject accumulatorExpr) {
                Integer val = (Integer)matchedHistogramBucket.get(outputKey);
                if (val == null) {
                    val = 0;
                }
                Integer increment = (Integer)accumulatorExpr.get(this.getKeyword());
                matchedHistogramBucket.put(outputKey, (Object)(val + increment));
            }
        }
        ,
        PUSH("$push"){

            @Override
            void apply(DBObject input, String outputKey, DBObject matchedHistogramBucket, DBObject accumulatorExpr) {
                String pushedValue;
                ArrayList<Object> val = (ArrayList<Object>)matchedHistogramBucket.get(outputKey);
                if (val == null) {
                    val = new ArrayList<Object>();
                    matchedHistogramBucket.put(outputKey, val);
                }
                PipelineKeyword.validateTrue((pushedValue = (String)accumulatorExpr.get(this.getKeyword())).charAt(0) == '$', "Field value to push must start with $");
                val.add(input.get(pushedValue.substring(1)));
            }
        };

        private final String keyword;

        private BucketAccumulator(String keyword) {
            this.keyword = keyword;
        }

        abstract void apply(DBObject var1, String var2, DBObject var3, DBObject var4);

        public boolean canApply(DBObject parameter) {
            return parameter.containsField(this.keyword);
        }

        public String getKeyword() {
            return this.keyword;
        }
    }
}

