/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl.index;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IndexedList<\u0415> {
    private Map<\u0415, List<Integer>> indexes;
    private final List<\u0415> elements;
    private boolean isSingle = true;

    public IndexedList(List<\u0415> elements) {
        this.elements = elements;
        if (elements.size() > 1) {
            this.initIndex(elements);
        }
    }

    private void initIndex(List<\u0415> newElements) {
        this.indexes = new HashMap<\u0415, List<Integer>>();
        this.isSingle = false;
        int count = 0;
        for (\u0415 el : newElements) {
            this.addIndex(el, count);
            ++count;
        }
    }

    public List<\u0415> getElements() {
        return this.elements;
    }

    public int size() {
        return this.elements.size();
    }

    public boolean contains(\u0415 element) {
        if (this.isSingle) {
            return this.elements.contains(element);
        }
        return this.indexes.containsKey(element);
    }

    public void add(\u0415 element) {
        if (this.elements.size() == 1) {
            this.initIndex(this.elements);
        }
        this.elements.add(element);
        if (this.elements.size() > 1) {
            this.addIndex(element, this.elements.size() - 1);
        }
    }

    private void addIndex(\u0415 element, int position) {
        List<Object> list;
        if (!this.indexes.containsKey(element)) {
            list = new ArrayList();
            this.indexes.put(element, list);
        } else {
            list = this.indexes.get(element);
        }
        list.add(position);
    }

    public void remove(\u0415 element) {
        if (this.isSingle) {
            this.elements.remove(element);
            return;
        }
        List<Integer> index = this.indexes.get(element);
        if (index == null) {
            return;
        }
        if (index.size() != 0) {
            int pos = index.get(0);
            this.elements.remove(pos);
            index.remove(0);
            for (int i = pos; i < this.elements.size(); ++i) {
                \u0415 key = this.elements.get(i);
                this.decrementIndexes(this.indexes.get(key));
            }
        }
        if (index.size() == 0) {
            this.indexes.remove(element);
        }
    }

    private void decrementIndexes(List<Integer> index) {
        for (int i = 0; i < index.size(); ++i) {
            index.set(i, index.get(i) - 1);
        }
    }
}

