/*
 * Decompiled with CFR 0.152.
 */
package com.jn.easyjson.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jn.easyjson.core.JsonException;
import com.jn.easyjson.core.JsonHandler;
import com.jn.easyjson.core.JsonTreeNode;
import com.jn.easyjson.jackson.Jacksons;
import com.jn.easyjson.jackson.node.JacksonBasedJsonTreeNodeMapper;
import com.jn.langx.util.reflect.type.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class JacksonAdapter
implements JsonHandler {
    private ObjectMapper objectMapper;
    private JacksonBasedJsonTreeNodeMapper treeNodeMapper = new JacksonBasedJsonTreeNodeMapper();

    public <T> T deserialize(String json, Type typeOfT) throws JsonException {
        try {
            if (Jacksons.isJacksonJavaType(typeOfT)) {
                return (T)this.objectMapper.readValue(json, Jacksons.toJavaType(typeOfT));
            }
            if (Types.isPrimitive((Type)typeOfT)) {
                return (T)this.objectMapper.readValue(json, this.objectMapper.getTypeFactory().constructType((Type)Types.getPrimitiveWrapClass((Type)typeOfT)));
            }
            if (Types.isClass((Type)typeOfT)) {
                return (T)this.objectMapper.readValue(json, this.objectMapper.getTypeFactory().constructType((Type)Types.toClass((Type)typeOfT)));
            }
            if (Types.isParameterizedType((Type)typeOfT)) {
                ParameterizedType pType = (ParameterizedType)typeOfT;
                Class parametrized = Types.toClass((Type)pType.getRawType());
                Type[] parameterTypes = pType.getActualTypeArguments();
                Class[] parameterClasses = new Class[parameterTypes.length];
                for (int i = 0; i < parameterTypes.length; ++i) {
                    parameterClasses[i] = Types.toClass((Type)parameterTypes[i]);
                }
                return (T)this.objectMapper.readValue(json, this.objectMapper.getTypeFactory().constructParametricType(parametrized, parameterClasses));
            }
        }
        catch (Throwable ex) {
            throw new JsonException(ex);
        }
        return null;
    }

    public JsonTreeNode deserialize(String json) throws JsonException {
        try {
            JsonNode jsonNode = this.objectMapper.readTree(json);
            return this.treeNodeMapper.create(jsonNode);
        }
        catch (Throwable ex) {
            throw new RuntimeException(ex);
        }
    }

    public String serialize(Object src, Type typeOfT) throws JsonException {
        try {
            if (src instanceof JsonTreeNode) {
                return this.objectMapper.writeValueAsString((Object)this.treeNodeMapper.mapping((JsonTreeNode)src));
            }
            return this.objectMapper.writeValueAsString(src);
        }
        catch (JsonProcessingException e) {
            throw new JsonException((Throwable)e);
        }
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

