/*
 * Decompiled with CFR 0.152.
 */
package com.jn.easyjson.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.jn.easyjson.jackson.Jacksons;
import com.jn.easyjson.jackson.deserializer.ContextualDeserializer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.EnumSet;

public class EnumDeserializer<T extends Enum>
extends JsonDeserializer<T>
implements ContextualDeserializer {
    private Class<T> clazz;

    public Class<T> handledType() {
        return this.clazz;
    }

    public T deserialize(JsonParser p, DeserializationContext ctx) throws IOException, JsonProcessingException {
        Object e;
        boolean usingIndex = Jacksons.getBooleanAttr(ctx, "SERIALIZE_ENUM_USING_INDEX");
        boolean usingToString = ctx.isEnabled(DeserializationFeature.READ_ENUMS_USING_TO_STRING);
        String usingField = (String)ctx.getAttribute((Object)"SERIALIZE_ENUM_USING_FIELD");
        Class<Object> enumClass = this.clazz;
        if (enumClass == null) {
            Object currentOwner = p.getCurrentValue();
            String currentName = p.currentName();
            if (currentName != null && currentOwner != null) {
                try {
                    Field field = currentOwner.getClass().getDeclaredField(currentName);
                    enumClass = field.getType();
                }
                catch (NoSuchFieldException e2) {
                    e2.printStackTrace();
                }
            }
        }
        EnumSet es = EnumSet.allOf(enumClass);
        JsonToken jtoken = p.getCurrentToken();
        if (usingIndex && jtoken == JsonToken.VALUE_NUMBER_INT) {
            int index = p.getIntValue();
            for (Object obj : es) {
                e = (Enum)obj;
                if (((Enum)e).ordinal() != index) continue;
                return (T)e;
            }
        }
        if (usingToString && jtoken == JsonToken.VALUE_STRING) {
            String string = p.getValueAsString();
            for (Object obj : es) {
                e = (Enum)obj;
                if (!((Enum)e).toString().equals(string)) continue;
                return (T)e;
            }
        }
        if (usingField != null) {
            try {
                Enum e2;
                Object v;
                Field field = enumClass.getDeclaredField(usingField);
                Class<?> fieldType = field.getType();
                if (String.class == fieldType && jtoken == JsonToken.VALUE_STRING) {
                    String str = p.getValueAsString();
                    for (Object obj : es) {
                        Enum e3 = (Enum)obj;
                        v = (String)field.get(e3);
                        if (!((String)v).equals(str)) continue;
                        return (T)e3;
                    }
                }
                if (Character.class == fieldType) {
                    char ch = p.getTextCharacters()[0];
                    for (Object obj : es) {
                        e2 = (Enum)obj;
                        v = (Character)field.get(e2);
                        if (!((Character)v).equals(Character.valueOf(ch))) continue;
                        return (T)e2;
                    }
                }
                if (Boolean.class == fieldType) {
                    boolean bool = p.getBooleanValue();
                    for (Object obj : es) {
                        e2 = (Enum)obj;
                        v = (Boolean)field.get(e2);
                        if (!((Boolean)v).equals(bool)) continue;
                        return (T)e2;
                    }
                }
                if (Number.class == fieldType) {
                    Number number = p.getNumberValue();
                    for (Object obj : es) {
                        e2 = (Enum)obj;
                        v = (Number)field.get(e2);
                        if (!v.equals(number)) continue;
                        return (T)e2;
                    }
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        if (jtoken == JsonToken.VALUE_STRING) {
            String enumName = p.getValueAsString();
            for (Object obj : es) {
                e = (Enum)obj;
                if (!((Enum)e).name().equals(enumName)) continue;
                return (T)e;
            }
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext context, BeanProperty beanProperty, Class<?> type) throws JsonMappingException {
        if (this.handledType() == null || type != null && this.handledType() != type) {
            EnumDeserializer<T> enumDeserializer = new EnumDeserializer<T>();
            enumDeserializer.clazz = type;
            return enumDeserializer;
        }
        return this;
    }
}

