/*
 * Decompiled with CFR 0.152.
 */
package com.jn.easyjson.jackson.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.NumberDeserializers;
import com.jn.easyjson.jackson.Jacksons;
import com.jn.easyjson.jackson.deserializer.ContextualDeserializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberDeserializer
extends JsonDeserializer<Number>
implements ContextualDeserializer {
    private Class<? extends Number> clazz;

    public Class<?> handledType() {
        return this.clazz;
    }

    public Number deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken curr = p.getCurrentToken();
        if (curr == JsonToken.VALUE_STRING) {
            String v = p.getValueAsString();
            if (this.clazz == Long.TYPE || this.clazz == Long.class) {
                return Long.parseLong(v);
            }
            if (this.clazz == Double.TYPE || this.clazz == Double.class) {
                return Double.parseDouble(v);
            }
            if (this.clazz == Integer.TYPE || this.clazz == Integer.class) {
                return Integer.parseInt(v);
            }
            if (this.clazz == Float.TYPE || this.clazz == Float.class) {
                return Float.valueOf(Float.parseFloat(v));
            }
            if (this.clazz == Short.TYPE || this.clazz == Short.class) {
                return Short.parseShort(v);
            }
            if (this.clazz == Byte.TYPE || this.clazz == Byte.class) {
                return Byte.parseByte(v);
            }
            if (this.clazz == BigDecimal.class) {
                return p.getDecimalValue();
            }
            if (this.clazz == BigInteger.class) {
                return p.getBigIntegerValue();
            }
        }
        if (p.isNaN()) {
            return 0;
        }
        Number n = null;
        if (this.clazz == Double.TYPE || this.clazz == Double.class) {
            n = p.getDoubleValue();
        } else if (this.clazz == Long.TYPE || this.clazz == Long.class) {
            n = p.getLongValue();
        } else if (this.clazz == Float.TYPE || this.clazz == Float.class) {
            n = p.getLongValue();
        } else if (this.clazz == Integer.TYPE || this.clazz == Integer.class) {
            n = p.getIntValue();
        } else if (this.clazz == Short.TYPE || this.clazz == Short.class) {
            n = p.getShortValue();
        } else if (this.clazz == Byte.TYPE || this.clazz == Byte.class) {
            n = p.getByteValue();
        } else if (this.clazz == BigDecimal.class) {
            n = p.getDecimalValue();
        } else if (this.clazz == BigInteger.class) {
            n = p.getBigIntegerValue();
        }
        if (n != null) {
            return n;
        }
        return 0;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext context, BeanProperty beanProperty, Class<?> type) throws JsonMappingException {
        if ((this.handledType() == null || type != null && this.handledType() != type) && Number.class.isAssignableFrom(type)) {
            if (Jacksons.getBooleanAttr(context, "SERIALIZE_LONG_USING_STRING") || Jacksons.getBooleanAttr(context, "SERIALIZE_NUMBER_USING_STRING")) {
                NumberDeserializer d = new NumberDeserializer();
                d.clazz = type;
                return d;
            }
            if (type.getName().startsWith("java.")) {
                return NumberDeserializers.find(type, (String)type.getName());
            }
        }
        return null;
    }
}

