/*
 * Decompiled with CFR 0.152.
 */
package com.jn.easyjson.jackson.ext;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.cfg.DeserializerFactoryConfig;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerFactory;
import com.fasterxml.jackson.databind.deser.DeserializerFactory;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.jn.easyjson.core.exclusion.ExclusionConfiguration;
import com.jn.easyjson.jackson.deserializer.DateDeserializer;
import com.jn.easyjson.jackson.deserializer.NumberDeserializer;
import com.jn.easyjson.jackson.ext.EasyJsonObjectMapper;
import com.jn.langx.util.reflect.type.Types;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class EasyJsonBeanDeserializerFactory
extends BeanDeserializerFactory {
    private EasyJsonObjectMapper objectMapper;

    EasyJsonBeanDeserializerFactory(DeserializerFactoryConfig config, EasyJsonObjectMapper objectMapper) {
        super(config);
        this.objectMapper = objectMapper;
    }

    public DeserializerFactory withConfig(DeserializerFactoryConfig config) {
        if (this._factoryConfig == config) {
            return this;
        }
        ClassUtil.verifyMustOverride(EasyJsonBeanDeserializerFactory.class, (Object)((Object)this), (String)"withConfig");
        return new EasyJsonBeanDeserializerFactory(config, this.objectMapper);
    }

    protected JsonDeserializer<?> findStdDeserializer(DeserializationContext ctxt, JavaType type, BeanDescription beanDesc) throws JsonMappingException {
        Object deser;
        Class rawType = type.getRawClass();
        String clsName = rawType.getName();
        if (Types.isPrimitive((Type)rawType) || clsName.startsWith("java.")) {
            deser = null;
            if (Number.class.isAssignableFrom(rawType) && (deser = new NumberDeserializer().createContextual(ctxt, null, Types.getPrimitiveWrapClass((Type)rawType))) != null) {
                return deser;
            }
        }
        if (Date.class.isAssignableFrom(rawType) && (deser = new DateDeserializer().createContextual(ctxt, null, rawType)) != null) {
            return deser;
        }
        return super.findStdDeserializer(ctxt, type, beanDesc);
    }

    protected List<BeanPropertyDefinition> filterBeanProps(DeserializationContext ctxt, BeanDescription beanDesc, BeanDeserializerBuilder builder, List<BeanPropertyDefinition> propDefsIn, Set<String> ignored) throws JsonMappingException {
        List propertyDefinitions = super.filterBeanProps(ctxt, beanDesc, builder, propDefsIn, ignored);
        if (this.objectMapper != null) {
            Class clazz;
            ExclusionConfiguration exclusionConfiguration = this.objectMapper.getJsonBuilder().getExclusionConfiguration();
            if (!exclusionConfiguration.isExcludedClass(clazz = beanDesc.getType().getRawClass(), false)) {
                Iterator iter = propertyDefinitions.iterator();
                while (iter.hasNext()) {
                    Field field;
                    BeanPropertyDefinition property = (BeanPropertyDefinition)iter.next();
                    if (!property.hasField() || !exclusionConfiguration.isExcludedField(field = property.getField().getAnnotated(), false)) continue;
                    iter.remove();
                }
            } else {
                propertyDefinitions.clear();
            }
        }
        return propertyDefinitions;
    }
}

