/*
 * Decompiled with CFR 0.152.
 */
package com.jn.easyjson.jackson.ext;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.SerializerFactoryConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.fasterxml.jackson.databind.ser.PropertyBuilder;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.BeanUtil;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.jn.easyjson.core.exclusion.ExclusionConfiguration;
import com.jn.easyjson.jackson.ext.EasyJsonObjectMapper;
import com.jn.easyjson.jackson.serializer.DateSerializer;
import com.jn.easyjson.jackson.serializer.NumberSerializer;
import com.jn.langx.util.reflect.type.Types;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class EasyJsonBeanSerializerFactory
extends BeanSerializerFactory {
    private EasyJsonObjectMapper objectMapper;

    EasyJsonBeanSerializerFactory(SerializerFactoryConfig config, EasyJsonObjectMapper objectMapper) {
        super(config);
        this.objectMapper = objectMapper;
    }

    public SerializerFactory withConfig(SerializerFactoryConfig config) {
        if (this._factoryConfig == config) {
            return this;
        }
        if (((Object)((Object)this)).getClass() != EasyJsonBeanSerializerFactory.class) {
            throw new IllegalStateException("Subtype of BeanSerializerFactory (" + ((Object)((Object)this)).getClass().getName() + ") has not properly overridden method 'withAdditionalSerializers': cannot instantiate subtype with additional serializer definitions");
        }
        return new EasyJsonBeanSerializerFactory(config, this.objectMapper);
    }

    protected List<BeanPropertyWriter> findBeanProperties(SerializerProvider prov, BeanDescription beanDesc, BeanSerializerBuilder builder) throws JsonMappingException {
        if (this.objectMapper != null && this.objectMapper.getJsonBuilder() != null) {
            ExclusionConfiguration exclusionConfiguration = this.objectMapper.getJsonBuilder().getExclusionConfiguration();
            Class clazz = beanDesc.getType().getRawClass();
            List properties = beanDesc.findProperties();
            if (!exclusionConfiguration.isExcludedClass(clazz, true)) {
                Iterator iter = properties.iterator();
                while (iter.hasNext()) {
                    Field field;
                    BeanPropertyDefinition property = (BeanPropertyDefinition)iter.next();
                    if (!property.hasField() || !exclusionConfiguration.isExcludedField(field = property.getField().getAnnotated(), true)) continue;
                    iter.remove();
                }
            } else {
                properties.clear();
            }
        }
        return super.findBeanProperties(prov, beanDesc, builder);
    }

    protected PropertyBuilder constructPropertyBuilder(SerializationConfig config, BeanDescription beanDesc) {
        if (!this.objectMapper.getJsonBuilder().serializeNulls()) {
            return new PropertyBuilder(config, beanDesc){

                protected BeanPropertyWriter buildWriter(SerializerProvider prov, BeanPropertyDefinition propDef, JavaType declaredType, JsonSerializer<?> ser, TypeSerializer typeSer, TypeSerializer contentTypeSer, AnnotatedMember am, boolean defaultUseStaticTyping) throws JsonMappingException {
                    NameTransformer unwrapper;
                    JavaType serializationType;
                    try {
                        serializationType = this.findSerializationType((Annotated)am, defaultUseStaticTyping, declaredType);
                    }
                    catch (JsonMappingException e) {
                        if (propDef == null) {
                            return (BeanPropertyWriter)prov.reportBadDefinition(declaredType, ClassUtil.exceptionMessage((Throwable)e));
                        }
                        return (BeanPropertyWriter)prov.reportBadPropertyDefinition(this._beanDesc, propDef, ClassUtil.exceptionMessage((Throwable)e), new Object[0]);
                    }
                    if (contentTypeSer != null) {
                        JavaType ct;
                        if (serializationType == null) {
                            serializationType = declaredType;
                        }
                        if ((ct = serializationType.getContentType()) == null) {
                            prov.reportBadPropertyDefinition(this._beanDesc, propDef, "serialization type " + serializationType + " has no content", new Object[0]);
                        }
                        serializationType = serializationType.withContentTypeHandler((Object)contentTypeSer);
                        ct = serializationType.getContentType();
                    }
                    Object valueToSuppress = null;
                    boolean suppressNulls = false;
                    JavaType actualType = serializationType == null ? declaredType : serializationType;
                    AnnotatedMember accessor = propDef.getAccessor();
                    if (accessor == null) {
                        return (BeanPropertyWriter)prov.reportBadPropertyDefinition(this._beanDesc, propDef, "could not determine property type", new Object[0]);
                    }
                    Class rawPropertyType = accessor.getRawType();
                    JsonInclude.Value inclV = this._config.getDefaultInclusion(actualType.getRawClass(), rawPropertyType, this._defaultInclusion);
                    JsonInclude.Include inclusion = (inclV = inclV.withOverrides(propDef.findInclusion())).getValueInclusion();
                    if (inclusion == JsonInclude.Include.USE_DEFAULTS) {
                        inclusion = JsonInclude.Include.ALWAYS;
                    }
                    switch (inclusion) {
                        case NON_DEFAULT: {
                            Object defaultBean;
                            if (this._useRealPropertyDefaults && (defaultBean = this.getDefaultBean()) != null) {
                                if (prov.isEnabled(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
                                    am.fixAccess(this._config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
                                }
                                try {
                                    valueToSuppress = am.getValue(defaultBean);
                                }
                                catch (Exception e) {
                                    this._throwWrapped(e, propDef.getName(), defaultBean);
                                }
                            } else {
                                valueToSuppress = BeanUtil.getDefaultValue((JavaType)actualType);
                                suppressNulls = true;
                            }
                            if (valueToSuppress == null) {
                                suppressNulls = true;
                                break;
                            }
                            if (!valueToSuppress.getClass().isArray()) break;
                            valueToSuppress = ArrayBuilders.getArrayComparator((Object)valueToSuppress);
                            break;
                        }
                        case NON_ABSENT: {
                            suppressNulls = true;
                            if (!actualType.isReferenceType()) break;
                            valueToSuppress = BeanPropertyWriter.MARKER_FOR_EMPTY;
                            break;
                        }
                        case NON_EMPTY: {
                            suppressNulls = true;
                            valueToSuppress = BeanPropertyWriter.MARKER_FOR_EMPTY;
                            break;
                        }
                        case CUSTOM: {
                            valueToSuppress = prov.includeFilterInstance(propDef, inclV.getValueFilter());
                            if (valueToSuppress == null) {
                                suppressNulls = true;
                                break;
                            }
                            suppressNulls = prov.includeFilterSuppressNulls(valueToSuppress);
                            break;
                        }
                        case NON_NULL: {
                            suppressNulls = true;
                        }
                        default: {
                            if (!actualType.isContainerType() || this._config.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS)) break;
                            valueToSuppress = BeanPropertyWriter.MARKER_FOR_EMPTY;
                        }
                    }
                    Class[] views = propDef.findViews();
                    if (views == null) {
                        views = this._beanDesc.findDefaultViews();
                    }
                    if (!suppressNulls && EasyJsonBeanSerializerFactory.this.objectMapper != null && EasyJsonBeanSerializerFactory.this.objectMapper.getJsonBuilder() != null) {
                        suppressNulls = !EasyJsonBeanSerializerFactory.this.objectMapper.getJsonBuilder().serializeNulls();
                    }
                    BeanPropertyWriter bpw = new BeanPropertyWriter(propDef, am, this._beanDesc.getClassAnnotations(), declaredType, ser, typeSer, serializationType, suppressNulls, valueToSuppress, views);
                    Object serDef = this._annotationIntrospector.findNullSerializer((Annotated)am);
                    if (serDef != null) {
                        bpw.assignNullSerializer(prov.serializerInstance((Annotated)am, serDef));
                    }
                    if ((unwrapper = this._annotationIntrospector.findUnwrappingNameTransformer(am)) != null) {
                        bpw = bpw.unwrappingWriter(unwrapper);
                    }
                    return bpw;
                }
            };
        }
        return new PropertyBuilder(config, beanDesc);
    }

    protected JsonSerializer<?> _createSerializer2(SerializerProvider prov, JavaType type, BeanDescription beanDesc, boolean staticTyping) throws JsonMappingException {
        Class rawType = type.getRawClass();
        String clsName = rawType.getName();
        JsonSerializer<?> ser = null;
        if ((Types.isPrimitive((Type)rawType) || clsName.startsWith("java.")) && Number.class.isAssignableFrom(Types.getPrimitiveWrapClass((Type)rawType)) && (ser = new NumberSerializer().createContextual(prov, null, type)) != null) {
            return ser;
        }
        if (Date.class.isAssignableFrom(rawType) && (ser = new DateSerializer().createContextual(prov, null, type)) != null) {
            return ser;
        }
        return super._createSerializer2(prov, type, beanDesc, staticTyping);
    }
}

