/*
 * Decompiled with CFR 0.152.
 */
package com.jn.easyjson.jackson.node;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import com.jn.easyjson.core.JsonTreeNode;
import com.jn.easyjson.core.node.JsonArrayNode;
import com.jn.easyjson.core.node.JsonNullNode;
import com.jn.easyjson.core.node.JsonObjectNode;
import com.jn.easyjson.core.node.JsonPrimitiveNode;
import com.jn.easyjson.core.node.JsonTreeNodeFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JacksonBasedJsonTreeNodeMapper
implements JsonTreeNodeFactory<JsonNode> {
    private JsonTreeNode createFromPojo(Object object) {
        if (object == null) {
            return JsonNullNode.INSTANCE;
        }
        if (object instanceof JsonNode) {
            return this.create((JsonNode)object);
        }
        if (object instanceof Number) {
            return new JsonPrimitiveNode((Number)object);
        }
        if (object instanceof String) {
            return new JsonPrimitiveNode(object.toString());
        }
        if (object instanceof Boolean) {
            return new JsonPrimitiveNode((Boolean)object);
        }
        if (object instanceof Collection) {
            Collection c = (Collection)object;
            JsonArrayNode arrayNode = new JsonArrayNode(c.size());
            for (Object e : c) {
                arrayNode.add(this.createFromPojo(e));
            }
            return arrayNode;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            JsonObjectNode jsonObjectNode = new JsonObjectNode();
            Set keys = map.keySet();
            for (Object key : keys) {
                jsonObjectNode.addProperty(key.toString(), this.createFromPojo(map.get(key)));
            }
            return jsonObjectNode;
        }
        return new JsonPrimitiveNode(object.toString());
    }

    public JsonTreeNode create(JsonNode jsonNode) {
        if (jsonNode.isNull()) {
            return JsonNullNode.INSTANCE;
        }
        if (jsonNode.isNumber()) {
            if (jsonNode.isShort() || jsonNode.isInt()) {
                return new JsonPrimitiveNode((Number)jsonNode.intValue());
            }
            if (jsonNode.isFloat() || jsonNode.isFloatingPointNumber()) {
                return new JsonPrimitiveNode((Number)Float.valueOf(jsonNode.floatValue()));
            }
            if (jsonNode.isDouble()) {
                return new JsonPrimitiveNode((Number)jsonNode.doubleValue());
            }
            if (jsonNode.isLong()) {
                return new JsonPrimitiveNode((Number)jsonNode.longValue());
            }
            if (jsonNode.isBigDecimal()) {
                return new JsonPrimitiveNode((Number)jsonNode.decimalValue());
            }
            if (jsonNode.isBigInteger()) {
                return new JsonPrimitiveNode((Number)jsonNode.bigIntegerValue());
            }
        }
        if (jsonNode.isBinary() || jsonNode.isTextual()) {
            return new JsonPrimitiveNode(jsonNode.textValue());
        }
        if (jsonNode.isBoolean()) {
            return new JsonPrimitiveNode(Boolean.valueOf(jsonNode.booleanValue()));
        }
        if (jsonNode.isArray()) {
            JsonArrayNode arrayNode = new JsonArrayNode(jsonNode.size());
            for (JsonNode element : jsonNode) {
                arrayNode.add(this.create(element));
            }
            return arrayNode;
        }
        if (jsonNode.isObject()) {
            JsonObjectNode jsonObjectNode = new JsonObjectNode();
            Iterator iter = jsonNode.fieldNames();
            while (iter.hasNext()) {
                String fieldName = (String)iter.next();
                jsonObjectNode.addProperty(fieldName, this.create(jsonNode.findValue(fieldName)));
            }
            return jsonObjectNode;
        }
        if (jsonNode.isPojo()) {
            POJONode pojoNode = (POJONode)jsonNode;
            Object object = pojoNode.getPojo();
            return this.createFromPojo(object);
        }
        return JsonNullNode.INSTANCE;
    }

    public JsonNode mapping(JsonTreeNode jsonNode) {
        JsonNodeFactory jsonNodeFactory = new JsonNodeFactory(true);
        if (jsonNode.isJsonNullNode()) {
            return NullNode.instance;
        }
        if (jsonNode.isJsonPrimitiveNode()) {
            JsonPrimitiveNode jsonPrimitiveNode = jsonNode.getAsJsonPrimitiveNode();
            if (jsonPrimitiveNode.isNumber()) {
                Number n = jsonPrimitiveNode.getAsNumber();
                if (jsonPrimitiveNode.isDouble()) {
                    return jsonNodeFactory.numberNode(jsonPrimitiveNode.getAsDouble());
                }
                if (jsonPrimitiveNode.isLong()) {
                    return jsonNodeFactory.numberNode(jsonPrimitiveNode.getAsLong());
                }
                if (jsonPrimitiveNode.isFloat()) {
                    return jsonNodeFactory.numberNode(jsonPrimitiveNode.getAsFloat());
                }
                if (jsonPrimitiveNode.isInteger()) {
                    return jsonNodeFactory.numberNode(jsonPrimitiveNode.getAsInt());
                }
                if (jsonPrimitiveNode.isShort()) {
                    return jsonNodeFactory.numberNode(jsonPrimitiveNode.getAsShort());
                }
                if (jsonPrimitiveNode.isByte()) {
                    return jsonNodeFactory.numberNode(jsonPrimitiveNode.getAsByte());
                }
                if (jsonPrimitiveNode.isBigInteger()) {
                    return jsonNodeFactory.numberNode(jsonPrimitiveNode.getAsBigInteger());
                }
                if (jsonPrimitiveNode.isBigDecimal()) {
                    return jsonNodeFactory.numberNode(jsonPrimitiveNode.getAsBigDecimal());
                }
            }
            if (jsonPrimitiveNode.isBoolean()) {
                return jsonNodeFactory.booleanNode(jsonPrimitiveNode.getAsBoolean());
            }
            if (jsonPrimitiveNode.isChar() || jsonPrimitiveNode.isString()) {
                return jsonNodeFactory.textNode(jsonPrimitiveNode.getAsString());
            }
        }
        if (jsonNode.isJsonArrayNode()) {
            JsonArrayNode jsonArrayNode = jsonNode.getAsJsonArrayNode();
            ArrayNode arrayNode = jsonNodeFactory.arrayNode(jsonArrayNode.size());
            for (JsonTreeNode element : jsonArrayNode) {
                arrayNode.add(this.mapping(element));
            }
            return arrayNode;
        }
        if (jsonNode.isJsonObjectNode()) {
            JsonObjectNode jsonObjectNode = jsonNode.getAsJsonObjectNode();
            ObjectNode objectNode = jsonNodeFactory.objectNode();
            for (String fieldName : jsonObjectNode.propertyNames()) {
                objectNode.set(fieldName, this.mapping(jsonObjectNode.getProperty(fieldName)));
            }
            return objectNode;
        }
        return NullNode.instance;
    }
}

