/*
 * Decompiled with CFR 0.152.
 */
package com.jn.easyjson.jackson.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.jn.easyjson.jackson.Jacksons;
import com.jn.easyjson.jackson.serializer.ContextualSerializer;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateSerializer<T extends Date>
extends JsonSerializer<T>
implements ContextualSerializer {
    public void serialize(T value, JsonGenerator gen, SerializerProvider ctx) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }
        DateFormat df = Jacksons.getDateFormatAttr(ctx, "SERIALIZE_DATE_USING_DATE_FORMAT");
        String pattern = Jacksons.getStringAttr(ctx, "SERIALIZE_DATE_USING_PATTERN");
        boolean usingToString = Jacksons.getBooleanAttr(ctx, "SERIALIZE_DATE_USING_TO_STRING");
        if (df == null && pattern != null && !pattern.isEmpty()) {
            df = new SimpleDateFormat(pattern);
        }
        if (df != null) {
            gen.writeString(df.format((Date)value));
            return;
        }
        if (usingToString) {
            gen.writeString(((Date)value).toString());
        }
        gen.writeNumber(((Date)value).getTime());
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property, JavaType type) throws JsonMappingException {
        if (type.getRawClass() == Date.class) {
            return this;
        }
        return null;
    }
}

