/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.algorithm.ahocorasick.trie;

import com.jn.langx.algorithm.ahocorasick.interval.IntervalTree;
import com.jn.langx.algorithm.ahocorasick.interval.Intervalable;
import com.jn.langx.algorithm.ahocorasick.trie.Emit;
import com.jn.langx.algorithm.ahocorasick.trie.FragmentToken;
import com.jn.langx.algorithm.ahocorasick.trie.MatchToken;
import com.jn.langx.algorithm.ahocorasick.trie.State;
import com.jn.langx.algorithm.ahocorasick.trie.Token;
import com.jn.langx.algorithm.ahocorasick.trie.TrieConfig;
import com.jn.langx.algorithm.ahocorasick.trie.handler.DefaultEmitHandler;
import com.jn.langx.algorithm.ahocorasick.trie.handler.EmitHandler;
import com.jn.langx.algorithm.ahocorasick.trie.handler.StatefulEmitHandler;
import com.jn.langx.util.Chars;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;

public class Trie {
    private final TrieConfig trieConfig;
    private final State rootState;

    private Trie(TrieConfig trieConfig) {
        this.trieConfig = trieConfig;
        this.rootState = new State();
    }

    private void addKeyword(String keyword) {
        if (keyword.isEmpty()) {
            return;
        }
        if (this.isCaseInsensitive()) {
            keyword = keyword.toLowerCase();
        }
        this.addState(keyword).addEmit(keyword);
    }

    private void addKeywords(String[] keywords) {
        for (String keyword : keywords) {
            this.addKeyword(keyword);
        }
    }

    private void addKeywords(Collection<String> keywords) {
        for (String keyword : keywords) {
            this.addKeyword(keyword);
        }
    }

    private State addState(String keyword) {
        return this.getRootState().addState(keyword);
    }

    public Collection<Token> tokenize(String text) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        Collection<Emit> collectedEmits = this.parseText(text);
        int lastCollectedPosition = -1;
        for (Emit emit : collectedEmits) {
            if (emit.getStart() - lastCollectedPosition > 1) {
                tokens.add(this.createFragment(emit, text, lastCollectedPosition));
            }
            tokens.add(this.createMatch(emit, text));
            lastCollectedPosition = emit.getEnd();
        }
        if (text.length() - lastCollectedPosition > 1) {
            tokens.add(this.createFragment(null, text, lastCollectedPosition));
        }
        return tokens;
    }

    private Token createFragment(Emit emit, String text, int lastCollectedPosition) {
        return new FragmentToken(text.substring(lastCollectedPosition + 1, emit == null ? text.length() : emit.getStart()));
    }

    private Token createMatch(Emit emit, String text) {
        return new MatchToken(text.substring(emit.getStart(), emit.getEnd() + 1), emit);
    }

    public Collection<Emit> parseText(CharSequence text) {
        return this.parseText(text, new DefaultEmitHandler());
    }

    public Collection<Emit> parseText(CharSequence text, StatefulEmitHandler emitHandler) {
        this.parseText(text, (EmitHandler)emitHandler);
        List<Intervalable> collectedEmits = emitHandler.getEmits();
        if (this.trieConfig.isOnlyWholeWords()) {
            this.removePartialMatches(text, collectedEmits);
        }
        if (this.trieConfig.isOnlyWholeWordsWhiteSpaceSeparated()) {
            this.removePartialMatchesWhiteSpaceSeparated(text, collectedEmits);
        }
        if (!this.trieConfig.isAllowOverlaps()) {
            IntervalTree intervalTree = new IntervalTree(collectedEmits);
            intervalTree.removeOverlaps(collectedEmits);
        }
        return collectedEmits;
    }

    public boolean containsMatch(CharSequence text) {
        return this.firstMatch(text) != null;
    }

    public void parseText(CharSequence text, EmitHandler emitHandler) {
        State currentState = this.getRootState();
        for (int position = 0; position < text.length(); ++position) {
            Character character = Character.valueOf(text.charAt(position));
            if (this.trieConfig.isCaseInsensitive()) {
                character = Character.valueOf(Character.toLowerCase(character.charValue()));
            }
            if (!this.storeEmits(position, currentState = this.getState(currentState, character), emitHandler) || !this.trieConfig.isStopOnHit()) continue;
            return;
        }
    }

    public Emit firstMatch(CharSequence text) {
        if (!this.trieConfig.isAllowOverlaps()) {
            Collection<Emit> parseText = this.parseText(text);
            if (parseText != null && !parseText.isEmpty()) {
                return parseText.iterator().next();
            }
        } else {
            State currentState = this.getRootState();
            for (int position = 0; position < text.length(); ++position) {
                Collection<String> emitStrs;
                Character character = Character.valueOf(text.charAt(position));
                if (this.trieConfig.isCaseInsensitive()) {
                    character = Character.valueOf(Character.toLowerCase(character.charValue()));
                }
                if ((emitStrs = (currentState = this.getState(currentState, character)).emit()) == null || emitStrs.isEmpty()) continue;
                for (String emitStr : emitStrs) {
                    Emit emit = new Emit(position - emitStr.length() + 1, position, emitStr);
                    if (this.trieConfig.isOnlyWholeWords()) {
                        if (this.isPartialMatch(text, emit)) continue;
                        return emit;
                    }
                    return emit;
                }
            }
        }
        return null;
    }

    private boolean isPartialMatch(CharSequence searchText, Emit emit) {
        return emit.getStart() != 0 && Chars.isAlphabetic(searchText.charAt(emit.getStart() - 1)) || emit.getEnd() + 1 != searchText.length() && Chars.isAlphabetic(searchText.charAt(emit.getEnd() + 1));
    }

    private void removePartialMatches(CharSequence searchText, List<Emit> collectedEmits) {
        ArrayList<Emit> removeEmits = new ArrayList<Emit>();
        for (Emit emit : collectedEmits) {
            if (!this.isPartialMatch(searchText, emit)) continue;
            removeEmits.add(emit);
        }
        for (Emit removeEmit : removeEmits) {
            collectedEmits.remove(removeEmit);
        }
    }

    private void removePartialMatchesWhiteSpaceSeparated(CharSequence searchText, List<Emit> collectedEmits) {
        long size = searchText.length();
        ArrayList<Emit> removeEmits = new ArrayList<Emit>();
        for (Emit emit : collectedEmits) {
            if (!(emit.getStart() != 0 && !Character.isWhitespace(searchText.charAt(emit.getStart() - 1)) || (long)(emit.getEnd() + 1) != size && !Character.isWhitespace(searchText.charAt(emit.getEnd() + 1)))) continue;
            removeEmits.add(emit);
        }
        for (Emit removeEmit : removeEmits) {
            collectedEmits.remove(removeEmit);
        }
    }

    private State getState(State currentState, Character character) {
        State newCurrentState = currentState.nextState(character);
        while (newCurrentState == null) {
            currentState = currentState.failure();
            newCurrentState = currentState.nextState(character);
        }
        return newCurrentState;
    }

    private void constructFailureStates() {
        LinkedBlockingDeque<State> queue = new LinkedBlockingDeque<State>();
        State startState = this.getRootState();
        for (State depthOneState : startState.getStates()) {
            depthOneState.setFailure(startState);
            queue.add(depthOneState);
        }
        while (!queue.isEmpty()) {
            State currentState = (State)queue.remove();
            for (Character transition : currentState.getTransitions()) {
                State targetState = currentState.nextState(transition);
                queue.add(targetState);
                State traceFailureState = currentState.failure();
                while (traceFailureState.nextState(transition) == null) {
                    traceFailureState = traceFailureState.failure();
                }
                State newFailureState = traceFailureState.nextState(transition);
                targetState.setFailure(newFailureState);
                targetState.addEmit(newFailureState.emit());
            }
        }
    }

    private boolean storeEmits(int position, State currentState, EmitHandler emitHandler) {
        boolean emitted;
        block1: {
            String emit;
            emitted = false;
            Collection<String> emits = currentState.emit();
            if (emits == null || emits.isEmpty()) break block1;
            Iterator<String> iterator = emits.iterator();
            while (!(!iterator.hasNext() || (emitted = emitHandler.emit(new Emit(position - (emit = iterator.next()).length() + 1, position, emit)) || emitted) && this.trieConfig.isStopOnHit())) {
            }
        }
        return emitted;
    }

    private boolean isCaseInsensitive() {
        return this.trieConfig.isCaseInsensitive();
    }

    private State getRootState() {
        return this.rootState;
    }

    public static TrieBuilder builder() {
        return new TrieBuilder();
    }

    public static class TrieBuilder {
        private final TrieConfig trieConfig = new TrieConfig();
        private final Trie trie = new Trie(this.trieConfig);

        private TrieBuilder() {
        }

        public TrieBuilder ignoreCase() {
            this.trieConfig.setCaseInsensitive(true);
            return this;
        }

        public TrieBuilder ignoreOverlaps() {
            this.trieConfig.setAllowOverlaps(false);
            return this;
        }

        public TrieBuilder addKeyword(String keyword) {
            this.trie.addKeyword(keyword);
            return this;
        }

        public TrieBuilder addKeywords(String ... keywords) {
            this.trie.addKeywords(keywords);
            return this;
        }

        public TrieBuilder addKeywords(Collection<String> keywords) {
            this.trie.addKeywords(keywords);
            return this;
        }

        public TrieBuilder onlyWholeWords() {
            this.trieConfig.setOnlyWholeWords(true);
            return this;
        }

        public TrieBuilder onlyWholeWordsWhiteSpaceSeparated() {
            this.trieConfig.setOnlyWholeWordsWhiteSpaceSeparated(true);
            return this;
        }

        public TrieBuilder stopOnHit() {
            this.trie.trieConfig.setStopOnHit(true);
            return this;
        }

        public Trie build() {
            this.trie.constructFailureStates();
            return this.trie;
        }

        public TrieBuilder caseInsensitive() {
            return this.ignoreCase();
        }

        public TrieBuilder removeOverlaps() {
            return this.ignoreOverlaps();
        }
    }
}

