/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.classpath.scanner;

import com.jn.langx.classpath.scanner.ResourceFilter;

public class FilterResource {
    public static ResourceFilter byPrefixSuffix(String prefix, String suffix) {
        return new ByPrefixSuffix(prefix, suffix);
    }

    public static ResourceFilter bySuffix(String suffix) {
        return new BySuffix(suffix);
    }

    public static ResourceFilter byPrefix(String prefix) {
        return new ByPrefix(prefix);
    }

    private FilterResource() {
    }

    private static class ByPrefix
    implements ResourceFilter {
        private final String prefix;

        ByPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean isMatch(String resourceName) {
            return resourceName.startsWith(this.prefix);
        }
    }

    private static class BySuffix
    implements ResourceFilter {
        private final String suffix;

        BySuffix(String suffix) {
            this.suffix = suffix;
        }

        @Override
        public boolean isMatch(String resourceName) {
            return resourceName.endsWith(this.suffix);
        }
    }

    private static class ByPrefixSuffix
    implements ResourceFilter {
        private final String prefix;
        private final String suffix;

        ByPrefixSuffix(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        @Override
        public boolean isMatch(String resourceName) {
            String fileName = resourceName.substring(resourceName.lastIndexOf(47) + 1);
            return fileName.startsWith(this.prefix) && fileName.endsWith(this.suffix);
        }
    }
}

