/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.classpath.scanner.core;

import com.jn.langx.classpath.scanner.ClassFilter;
import com.jn.langx.classpath.scanner.ClassPathScanner;
import com.jn.langx.classpath.scanner.Resource;
import com.jn.langx.classpath.scanner.ResourceFilter;
import com.jn.langx.classpath.scanner.core.Location;
import com.jn.langx.classpath.scanner.internal.EnvironmentDetection;
import com.jn.langx.classpath.scanner.internal.ResourceAndClassScanner;
import com.jn.langx.classpath.scanner.internal.scanner.filesystem.FileSystemScanner;
import com.jn.langx.exception.UnsupportedPlatformException;
import java.util.List;

public class Scanner
implements ClassPathScanner {
    private final ResourceAndClassScanner resourceAndClassScanner;
    private final FileSystemScanner fileSystemScanner = new FileSystemScanner();

    public Scanner(ClassLoader classLoader) {
        if (EnvironmentDetection.isAndroid()) {
            throw new UnsupportedPlatformException();
        }
        this.resourceAndClassScanner = new com.jn.langx.classpath.scanner.internal.scanner.classpath.ClassPathScanner(classLoader);
    }

    public List<Resource> scanForResources(Location location, ResourceFilter predicate) {
        if (location.isFileSystem()) {
            return this.fileSystemScanner.scanForResources(location, predicate);
        }
        return this.resourceAndClassScanner.scanForResources(location, predicate);
    }

    @Override
    public List<Resource> scanForResources(String location, ResourceFilter predicate) {
        return this.scanForResources(new Location(location), predicate);
    }

    public List<Class<?>> scanForClasses(Location location, ClassFilter predicate) {
        return this.resourceAndClassScanner.scanForClasses(location, predicate);
    }

    @Override
    public List<Class<?>> scanForClasses(String location, ClassFilter predicate) {
        return this.scanForClasses(new Location(location), predicate);
    }
}

