/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.classpath.scanner.internal.scanner.filesystem;

import com.jn.langx.classpath.scanner.Resource;
import com.jn.langx.classpath.scanner.core.ClassPathScanException;
import com.jn.langx.util.io.IOs;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class FileSystemResource
implements Resource,
Comparable<FileSystemResource> {
    private File location;

    public FileSystemResource(String location) {
        this.location = new File(location);
    }

    public String toString() {
        return this.location.toString();
    }

    @Override
    public String getLocation() {
        return this.location.getPath().replace('\\', '/');
    }

    @Override
    public String getLocationOnDisk() {
        return this.location.getAbsolutePath();
    }

    @Override
    public String loadAsString(String encoding) {
        try {
            FileInputStream inputStream = new FileInputStream(this.location);
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, Charset.forName(encoding));
            return IOs.toString(reader);
        }
        catch (IOException e) {
            throw new ClassPathScanException("Unable to load filesystem resource: " + this.location.getPath() + " (encoding: " + encoding + ")", e);
        }
    }

    @Override
    public byte[] loadAsBytes() {
        try {
            FileInputStream inputStream = new FileInputStream(this.location);
            return IOs.toByteArray(inputStream);
        }
        catch (IOException e) {
            throw new ClassPathScanException("Unable to load filesystem resource: " + this.location.getPath(), e);
        }
    }

    @Override
    public String getFilename() {
        return this.location.getName();
    }

    @Override
    public int compareTo(FileSystemResource o) {
        return this.location.compareTo(o.location);
    }
}

