/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.factory;

import com.jn.langx.Delegatable;
import com.jn.langx.factory.Factory;

public class ThreadLocalFactory<I, E>
implements Factory<I, E>,
Delegatable<Factory<I, E>> {
    private final ThreadLocal<E> valueCache;
    private final ThreadLocal<I> inputCache = new ThreadLocal();
    private Factory<I, E> delegate;

    public ThreadLocalFactory(Factory<I, E> delegate) {
        if (delegate == null) {
            throw new NullPointerException();
        }
        this.setDelegate(delegate);
        this.valueCache = new ThreadLocal<E>(){

            @Override
            protected E initialValue() {
                return ThreadLocalFactory.this.delegate.get(ThreadLocalFactory.this.inputCache.get());
            }
        };
    }

    @Override
    public Factory<I, E> getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(Factory<I, E> delegate) {
        this.delegate = delegate;
    }

    @Override
    public E get(I input) {
        this.inputCache.set(input);
        try {
            E e = this.valueCache.get();
            return e;
        }
        finally {
            this.inputCache.remove();
        }
    }

    public void clear() {
        this.valueCache.remove();
    }
}

