/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text;

import com.jn.langx.Parser;
import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.BasedStringAccessor;
import com.jn.langx.util.collection.StringMap;
import com.jn.langx.util.collection.StringMapAccessor;

public class HttpQueryStringAccessor
extends BasedStringAccessor<String, String>
implements Parser<String, HttpQueryStringAccessor> {
    private StringMapAccessor delegate;

    public HttpQueryStringAccessor() {
    }

    public HttpQueryStringAccessor(@NonNull String url) {
        this();
        this.setTarget(url);
    }

    @Override
    public void setTarget(String url) {
        super.setTarget(url);
        this.delegate = this.parse0(url);
    }

    @Override
    public Object get(String key) {
        return this.delegate.get(key);
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.delegate.getString(key, defaultValue);
    }

    private StringMapAccessor parse0(String url) {
        return new StringMapAccessor(StringMap.httpUrlParameters(url));
    }

    @Override
    public HttpQueryStringAccessor parse(String url) {
        this.setTarget(url);
        return this;
    }

    public static HttpQueryStringAccessor access(String url) {
        HttpQueryStringAccessor accessor = new HttpQueryStringAccessor();
        accessor.setTarget(url);
        return accessor;
    }

    public StringMap getStringMap() {
        if (this.delegate != null) {
            return (StringMap)this.delegate.getTarget();
        }
        return StringMap.EMPTY;
    }

    @Override
    public void set(String key, Object value) {
        this.delegate.set(key, value);
    }
}

