/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.i18n;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.lifecycle.Initializable;
import com.jn.langx.lifecycle.InitializationException;
import com.jn.langx.text.i18n.I18nMessageRegistry;
import com.jn.langx.text.i18n.I18nTokenizer;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultI18nMessageRegistry
implements I18nMessageRegistry,
Initializable {
    private static final Logger logger = LoggerFactory.getLogger(DefaultI18nMessageRegistry.class);
    private static final Object[] NO_ARGS = new Object[0];
    private String defaultBundleName;
    private Locale defaultLocale = Locale.getDefault();
    private boolean devMode;

    @Override
    public void setLocal(Locale locale) {
        this.defaultLocale = locale;
    }

    @Override
    public String getDefaultBundleName() {
        return this.defaultBundleName;
    }

    protected ResourceBundle getBundle(@Nullable String bundleName) {
        return this.getBundle(bundleName, this.getLocale());
    }

    protected ResourceBundle getBundle(@Nullable String bundleName, @Nullable String languageHeader) {
        return this.getBundle(bundleName, this.getLocale(languageHeader));
    }

    protected ResourceBundle getBundle(@Nullable String bundleName, @Nullable Locale locale) {
        String string = bundleName = Strings.isBlank(bundleName) ? this.getDefaultBundleName() : bundleName.trim();
        if (locale == null) {
            locale = this.getLocale();
        }
        return this.cacheBundle(bundleName, locale);
    }

    public void setLocale(@NonNull Locale locale) {
        Preconditions.checkNotNull(locale);
        this.defaultLocale = locale;
    }

    @Override
    @NonNull
    public Locale getLocale() {
        return this.defaultLocale;
    }

    @Override
    public Locale getLocale(String header) {
        I18nTokenizer tok;
        if (!Strings.isEmpty(header) && (tok = new I18nTokenizer(header)).hasNext()) {
            return (Locale)tok.next();
        }
        return this.defaultLocale;
    }

    @Override
    public String getMessage(String key) {
        return this.getMessage(null, key);
    }

    @Override
    public String getMessage(Locale locale, String key) {
        return this.getMessage(this.getDefaultBundleName(), locale, key);
    }

    @Override
    public String getMessage(String bundleName, Locale locale, String key) {
        ResourceBundle bundle = this.cacheBundle(bundleName, locale);
        return bundle.getString(key);
    }

    @Override
    public String getMessage(String bundleName, Locale locale, String key, Object ... args) {
        String value = this.getMessage(bundleName, locale, key);
        if (args == null) {
            args = NO_ARGS;
        }
        MessageFormat messageFormat = new MessageFormat("");
        messageFormat.setLocale(locale);
        messageFormat.applyPattern(value);
        return messageFormat.format(args);
    }

    @Override
    public void init() throws InitializationException {
    }

    protected void initializeBundleNames() {
    }

    private synchronized ResourceBundle cacheBundle(String bundleName, Locale locale) throws MissingResourceException {
        return ResourceBundle.getBundle(bundleName, locale);
    }

    private ResourceBundle getBundleIgnoreException(String bundleName, Locale locale) {
        try {
            return ResourceBundle.getBundle(bundleName, locale);
        }
        catch (MissingResourceException var4) {
            return null;
        }
    }

    protected final String getStringOrNull(ResourceBundle rb, String key) {
        if (rb != null) {
            try {
                return rb.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return null;
    }
}

