/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.text.pinyin;

import com.jn.langx.algorithm.ahocorasick.trie.Emit;
import com.jn.langx.algorithm.ahocorasick.trie.Trie;
import com.jn.langx.text.pinyin.Pinyin;
import com.jn.langx.text.pinyin.PinyinDict;
import com.jn.langx.text.pinyin.SegmentationSelector;
import com.jn.langx.util.Emptys;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

final class Engine {
    static final EmitComparator EMIT_COMPARATOR = new EmitComparator();

    private Engine() {
    }

    static String toPinyin(String inputStr, Trie trie, List<PinyinDict> pinyinDictList, String separator, SegmentationSelector selector) {
        if (inputStr == null || inputStr.length() == 0) {
            return inputStr;
        }
        boolean hasSeparator = Emptys.isEmpty(selector);
        if (trie == null || selector == null) {
            StringBuffer resultPinyinStrBuf = new StringBuffer();
            for (int i = 0; i < inputStr.length(); ++i) {
                resultPinyinStrBuf.append(Pinyin.toPinyin(inputStr.charAt(i)));
                if (i == inputStr.length() - 1 || !hasSeparator) continue;
                resultPinyinStrBuf.append(separator);
            }
            return resultPinyinStrBuf.toString();
        }
        List<Emit> selectedEmits = selector.select(trie.parseText(inputStr));
        Collections.sort(selectedEmits, EMIT_COMPARATOR);
        StringBuffer resultPinyinStrBuf = new StringBuffer();
        int nextHitIndex = 0;
        int i = 0;
        while (i < inputStr.length()) {
            if (nextHitIndex < selectedEmits.size() && i == selectedEmits.get(nextHitIndex).getStart()) {
                String[] fromDicts = Engine.pinyinFromDict(selectedEmits.get(nextHitIndex).getKeyword(), pinyinDictList);
                for (int j = 0; j < fromDicts.length; ++j) {
                    resultPinyinStrBuf.append(fromDicts[j].toUpperCase());
                    if (j == fromDicts.length - 1 || !hasSeparator) continue;
                    resultPinyinStrBuf.append(separator);
                }
                i += selectedEmits.get(nextHitIndex).size();
                ++nextHitIndex;
            } else {
                resultPinyinStrBuf.append(Pinyin.toPinyin(inputStr.charAt(i)));
                ++i;
            }
            if (i == inputStr.length() || !hasSeparator) continue;
            resultPinyinStrBuf.append(separator);
        }
        return resultPinyinStrBuf.toString();
    }

    static String[] pinyinFromDict(String wordInDict, List<PinyinDict> pinyinDictSet) {
        if (pinyinDictSet != null) {
            for (PinyinDict dict : pinyinDictSet) {
                if (dict == null || dict.words() == null || !dict.words().contains(wordInDict)) continue;
                return dict.toPinyin(wordInDict);
            }
        }
        throw new IllegalArgumentException("No pinyin dict contains word: " + wordInDict);
    }

    static final class EmitComparator
    implements Comparator<Emit> {
        EmitComparator() {
        }

        @Override
        public int compare(Emit o1, Emit o2) {
            if (o1.getStart() == o2.getStart()) {
                return o1.size() < o2.size() ? 1 : (o1.size() == o2.size() ? 0 : -1);
            }
            return o1.getStart() < o2.getStart() ? -1 : (o1.getStart() == o2.getStart() ? 0 : 1);
        }
    }
}

