/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.util.Emptys;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class BooleanEvaluator {
    private final Set<Object> trueFactors = new HashSet<Object>();
    private final Set<Object> falseFactors = new HashSet<Object>();
    private boolean nullValue = false;
    private boolean stringIgnoreCase = true;
    public static final BooleanEvaluator simpleStringEvaluator = BooleanEvaluator.createTrueEvaluator("true");

    public BooleanEvaluator(boolean nullValue, boolean stringIgnoreCase, Object[] trueFactors, Object[] falseFactors) {
        this(nullValue, stringIgnoreCase, Collects.asList(trueFactors), Collects.asList(falseFactors));
    }

    public BooleanEvaluator(boolean nullValue, boolean stringIgnoreCase, List<Object> trueFactors, List<Object> falseFactors) {
        this.setNullValue(nullValue);
        this.setStringIgnoreCase(stringIgnoreCase);
        this.addTrueFactors(trueFactors);
        this.addFalseFactors(falseFactors);
    }

    public void setStringIgnoreCase(boolean ignoreCase) {
        this.stringIgnoreCase = ignoreCase;
    }

    public void setNullValue(boolean nullValue) {
        this.nullValue = nullValue;
    }

    public void addFactor(Object trueFactor, Object falseFactor) {
        this.addTrueFactor(trueFactor);
        this.addFalseFactor(falseFactor);
    }

    public void addTrueFactors(List<Object> trueFactors) {
        if (Emptys.isNotEmpty(trueFactors)) {
            Collects.forEach(trueFactors, new Consumer<Object>(){

                @Override
                public void accept(Object object) {
                    BooleanEvaluator.this.addTrueFactor(object);
                }
            });
        }
    }

    public void addFalseFactors(List<Object> falseFactors) {
        if (Emptys.isNotEmpty(this.trueFactors)) {
            Collects.forEach(this.trueFactors, new Consumer<Object>(){

                @Override
                public void accept(Object object) {
                    BooleanEvaluator.this.addFalseFactor(object);
                }
            });
        }
    }

    public void addTrueFactor(Object trueFactor) {
        if (trueFactor != null) {
            if (trueFactor instanceof String) {
                this.trueFactors.add(this.stringIgnoreCase ? ((String)trueFactor).toLowerCase() : trueFactor);
            }
            this.trueFactors.add(trueFactor);
        }
    }

    public void addFalseFactor(Object falseFactor) {
        if (falseFactor != null) {
            if (falseFactor instanceof String) {
                this.falseFactors.add(this.stringIgnoreCase ? ((String)falseFactor).toLowerCase() : falseFactor);
                return;
            }
            this.falseFactors.add(falseFactor);
        }
    }

    public boolean evalTrue(Object object) {
        if (object == null) {
            return this.nullValue;
        }
        if (object instanceof String && this.stringIgnoreCase) {
            object = ((String)object).toLowerCase();
        }
        if (this.trueFactors.contains(object)) {
            return true;
        }
        if (this.falseFactors.contains(object)) {
            return false;
        }
        return !this.nullValue;
    }

    public boolean evalFalse(Object object) {
        if (object == null) {
            return this.nullValue;
        }
        if (object instanceof String && this.stringIgnoreCase) {
            object = ((String)object).toLowerCase();
        }
        if (this.falseFactors.contains(object)) {
            return true;
        }
        if (this.trueFactors.contains(object)) {
            return false;
        }
        return this.nullValue;
    }

    public static BooleanEvaluator createTrueEvaluator(Object ... truthArray) {
        return new BooleanEvaluator(false, true, truthArray, null);
    }

    public static BooleanEvaluator createTrueEvaluator(boolean nullValue, boolean stringIgnoreCase, Object[] truthArray) {
        return new BooleanEvaluator(nullValue, stringIgnoreCase, truthArray, null);
    }

    public static BooleanEvaluator createFalseEvaluator(Object ... falseArray) {
        return new BooleanEvaluator(false, true, null, falseArray);
    }

    public static BooleanEvaluator createFalseEvaluator(boolean nullValue, boolean stringIgnoreCase, Object[] falseArray) {
        return new BooleanEvaluator(nullValue, stringIgnoreCase, null, falseArray);
    }
}

