/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.util.Preconditions;

public class Chars {
    private static final char MAX_CHAR_VALUE = '\u00ff';

    public static boolean isAlphabetic(int codePoint) {
        return (1086 >> Character.getType(codePoint) & 1) != 0 || Character.isValidCodePoint(codePoint) && Character.isLetter(codePoint);
    }

    public static boolean isAscii(char ch) {
        return ch < '\u0080';
    }

    public static boolean isAsciiPrintable(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }

    public static boolean isNumber(char c) {
        return c >= '0' && c <= '9';
    }

    public static int toInt(char c) {
        Preconditions.checkTrue(Chars.isNumber(c));
        return c - 48;
    }

    public static char toLowerCase(char c) {
        return Chars.isUpperCase(c) ? (char)(c + 32) : c;
    }

    public static byte toLowerCase(byte c) {
        return Chars.isUpperCase(c) ? (byte)(c + 32) : c;
    }

    public static byte toUpperCase(byte b) {
        return Chars.isLowerCase(b) ? (byte)(b - 32) : b;
    }

    public static char toUpperCase(char b) {
        return Chars.isLowerCase(b) ? (char)(b - 32) : b;
    }

    public static boolean isLowerCase(byte value) {
        return value >= 97 && value <= 122;
    }

    public static boolean isLowerCase(char value) {
        return value >= 'a' && value <= 'z';
    }

    public static boolean isUpperCase(byte value) {
        return value >= 65 && value <= 90;
    }

    public static boolean isUpperCase(char value) {
        return value >= 'A' && value <= 'Z';
    }

    public static boolean isLowOrUpperCase(char value) {
        return Chars.isUpperCase(value) || Chars.isLowerCase(value);
    }

    public static boolean isLowOrUpperCase(byte value) {
        return Chars.isUpperCase(value) || Chars.isLowerCase(value);
    }

    public static byte c2b(char c) {
        return (byte)(c > '\u00ff' ? 63 : (int)c);
    }

    private static byte c2b0(char c) {
        return (byte)c;
    }

    public static char b2c(byte b) {
        return (char)(b & 0xFF);
    }

    public static int compare(char x, char y) {
        return x - y;
    }
}

