/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.util.InternalThreadLocalMap;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Throwables;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Dates {
    public static final String YYYY_MM_DD_HH_mm_ss = "YYYY-MM-DD HH:mm:ss";
    public static final String YYYY_MM_DD_HH_mm_ss_SSS = "YYYY-MM-DD HH:mm:ss.SSS";
    public static final String YYYY_MM_DD = "YYYY-MM-DD";
    public static final String DD_MM_YYYY = "DD/MM/YYYY";
    public static final String HH_mm_ss = "HH:mm:ss";

    public String format(@NonNull Date date, @NonNull String pattern) {
        Preconditions.checkNotEmpty(pattern, "pattern is empty");
        Preconditions.checkNotNull(date);
        return InternalThreadLocalMap.getSimpleDateFormat(pattern).format(date);
    }

    public Date parse(String dateString, String pattern) {
        try {
            return InternalThreadLocalMap.getSimpleDateFormat(pattern).parse(dateString);
        }
        catch (ParseException ex) {
            throw Throwables.wrapAsRuntimeException(ex);
        }
    }

    public static Date addYears(Date date, int amount) {
        return Dates.add(date, 1, amount);
    }

    public static Date addMonths(Date date, int amount) {
        return Dates.add(date, 2, amount);
    }

    public static Date addWeeks(Date date, int amount) {
        return Dates.add(date, 3, amount);
    }

    public static Date addDays(Date date, int amount) {
        return Dates.add(date, 5, amount);
    }

    public static Date addHours(Date date, int amount) {
        return Dates.add(date, 11, amount);
    }

    public static Date addMinutes(Date date, int amount) {
        return Dates.add(date, 12, amount);
    }

    public static Date addSeconds(Date date, int amount) {
        return Dates.add(date, 13, amount);
    }

    public static Date addMilliseconds(Date date, int amount) {
        return Dates.add(date, 14, amount);
    }

    private static Date add(Date date, int calendarField, int amount) {
        Preconditions.checkNotNull(date);
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    public static Date setYears(Date date, int amount) {
        return Dates.set(date, 1, amount);
    }

    public static Date setMonths(Date date, int amount) {
        return Dates.set(date, 2, amount);
    }

    public static Date setDays(Date date, int amount) {
        return Dates.set(date, 5, amount);
    }

    public static Date setHours(Date date, int amount) {
        return Dates.set(date, 11, amount);
    }

    public static Date setMinutes(Date date, int amount) {
        return Dates.set(date, 12, amount);
    }

    public static Date setSeconds(Date date, int amount) {
        return Dates.set(date, 13, amount);
    }

    public static Date setMilliseconds(Date date, int amount) {
        return Dates.set(date, 14, amount);
    }

    private static Date set(Date date, int calendarField, int amount) {
        Preconditions.checkNotNull(date);
        Calendar c = Calendar.getInstance();
        c.setLenient(false);
        c.setTime(date);
        c.set(calendarField, amount);
        return c.getTime();
    }

    public static Calendar toCalendar(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c;
    }

    public static Calendar toCalendar(Date date, TimeZone tz) {
        Calendar c = Calendar.getInstance(tz);
        c.setTime(date);
        return c;
    }
}

