/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.util.SystemPropertys;
import com.jn.langx.util.reflect.Reflects;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Platform {
    private static final Logger logger = LoggerFactory.getLogger(Platform.class);
    public static boolean isWindows = Platform.isWindows0();
    public static int JAVA_VERSION_INT = Platform.javaVersion();
    public static boolean isAndroid = Platform.isAndroid0();
    private static final boolean IS_IVKVM_DOT_NET = Platform.isIkvmDotNet0();
    public static boolean isGroovyAvailable = Platform.isGroovyAvailable0();
    public static String processId = Platform.getProcessId0();

    private static boolean isWindows0() {
        return System.getProperty("os.name", "").toLowerCase(Locale.US).contains("win");
    }

    private static boolean isIkvmDotNet0() {
        String vmName = System.getProperty("java.vm.name", "").toUpperCase(Locale.US);
        return vmName.equals("IKVM.NET");
    }

    private static boolean isAndroid0() {
        String vmName = System.getProperty("java.vm.name");
        boolean isAndroid = "Dalvik".equals(vmName);
        if (isAndroid) {
            logger.debug("Platform: Android");
        }
        return isAndroid;
    }

    private static int javaVersion() {
        int majorVersion = Platform.isAndroid0() ? 6 : Platform.majorVersionFromJavaSpecificationVersion();
        logger.debug("Java version: {}", (Object)majorVersion);
        return majorVersion;
    }

    private static int majorVersionFromJavaSpecificationVersion() {
        return Platform.majorVersion(System.getProperty("java.specification.version", "1.6"));
    }

    private static int majorVersion(String javaSpecVersion) {
        String[] components = javaSpecVersion.split("\\.");
        int[] version = new int[components.length];
        for (int i = 0; i < components.length; ++i) {
            version[i] = Integer.parseInt(components[i]);
        }
        if (version[0] == 1) {
            assert (version[1] >= 6);
            return version[1];
        }
        return version[0];
    }

    private static boolean isGroovyAvailable0() {
        ClassLoader loader = Platform.class.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        try {
            Class<?> bindingClass = loader.loadClass("groovy.lang.Binding");
            return bindingClass != null;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    private static String getProcessId0() {
        try {
            if (isAndroid) {
                Object runtimeMXBean = Reflects.getDeclaredMethod(Class.forName("java.lang.management.ManagementFactory"), "getRuntimeMXBean", new Class[0]).invoke(null, new Object[0]);
                return Reflects.getDeclaredMethod(Class.forName("java.lang.management.RuntimeMXBean"), "getName", new Class[0]).invoke(runtimeMXBean, new Object[0]).toString().split("@")[0];
            }
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            return runtimeMXBean.getName().split("@")[0];
        }
        catch (Throwable ex) {
            if (isAndroid) {
                try {
                    return new File("/proc/self").getCanonicalFile().getName();
                }
                catch (IOException e) {
                    return null;
                }
            }
            return null;
        }
    }

    public static boolean equals(byte[] bytes1, int startPos1, byte[] bytes2, int startPos2, int length) {
        int end = startPos1 + length;
        while (startPos1 < end) {
            if (bytes1[startPos1] != bytes2[startPos2]) {
                return false;
            }
            ++startPos1;
            ++startPos2;
        }
        return true;
    }

    public static String getTempDirectoryPath() {
        return SystemPropertys.getJavaIOTmpDir();
    }

    public static File getTempDirectory() {
        return new File(Platform.getTempDirectoryPath());
    }

    public static String getUserHomeDirectoryPath() {
        return SystemPropertys.getUserHome();
    }

    public static File getUserHomeDirectory() {
        return new File(Platform.getUserHomeDirectoryPath());
    }
}

