/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.io.IOs;
import com.jn.langx.util.reflect.Reflects;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class Throwables {
    private static final Logger logger = LoggerFactory.getLogger(Throwables.class);
    private static final String JAVA_LANG_ACCESS_CLASSNAME = "sun.misc.JavaLangAccess";
    static final String SHARED_SECRETS_CLASSNAME = "sun.misc.SharedSecrets";
    private static final Object jla = Throwables.getJLA();
    @Nullable
    private static final Method getStackTraceElementMethod = jla == null ? null : Throwables.getGetMethod();
    @Nullable
    private static final Method getStackTraceDepthMethod = jla == null ? null : Throwables.getDepthMethod();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStackTraceAsString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        try {
            throwable.printStackTrace(printWriter);
            String string = stringWriter.toString();
            return string;
        }
        finally {
            IOs.close(printWriter);
        }
    }

    public static Throwable throwIfError(Throwable ex) {
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        return ex;
    }

    public static Throwable throwIfRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        return ex;
    }

    public static Throwable throwIfIOException(Throwable ex) throws IOException {
        if (ex instanceof IOException) {
            throw (IOException)ex;
        }
        return ex;
    }

    public static RuntimeException wrapAsRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            return (RuntimeException)ex;
        }
        return new RuntimeException(ex);
    }

    public static void throwAsRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw new RuntimeException(ex);
    }

    public static Throwable getRootCause(Throwable ex) {
        while (ex.getCause() != null) {
            ex = ex.getCause();
        }
        return ex;
    }

    public static Throwable throwRootCauseIfIOException(Throwable ex) throws IOException {
        return Throwables.throwIfIOException(Throwables.getRootCause(ex));
    }

    public static void log(@NonNull Throwable ex) {
        Throwables.log(null, null, null, ex);
    }

    public static void log(@Nullable Logger logger, @Nullable Level level, @Nullable String message, @NonNull Throwable ex) {
        Preconditions.checkNotNull(ex);
        message = Emptys.isEmpty(message) ? ex.getMessage() : message;
        logger = logger == null ? Throwables.logger : logger;
        level = level == null ? Level.ERROR : level;
        switch (level) {
            case TRACE: {
                if (!logger.isTraceEnabled()) break;
                logger.trace(message, ex);
                break;
            }
            case DEBUG: {
                if (!logger.isDebugEnabled()) break;
                logger.debug(message, ex);
                break;
            }
            case INFO: {
                if (!logger.isInfoEnabled()) break;
                logger.info(message, ex);
                break;
            }
            case WARN: {
                if (!logger.isWarnEnabled()) break;
                logger.warn(message, ex);
                break;
            }
            case ERROR: {
                if (!logger.isErrorEnabled()) break;
                logger.error(message, ex);
                break;
            }
            default: {
                logger.warn(message, ex);
            }
        }
    }

    private static Method getJlaMethod(String name, Class<?> ... parameterTypes) throws ThreadDeath {
        try {
            return Class.forName(JAVA_LANG_ACCESS_CLASSNAME, false, null).getMethod(name, parameterTypes);
        }
        catch (ThreadDeath death) {
            throw death;
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Nullable
    private static Object getJLA() {
        try {
            Class<?> sharedSecrets = Class.forName(SHARED_SECRETS_CLASSNAME, false, null);
            Method langAccess = sharedSecrets.getMethod("getJavaLangAccess", new Class[0]);
            return langAccess.invoke(null, new Object[0]);
        }
        catch (ThreadDeath death) {
            throw death;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static List<StackTraceElement> lazyStackTrace(Throwable throwable) {
        return Throwables.lazyStackTraceIsLazy() ? Throwables.jlaStackTrace(throwable) : Collections.unmodifiableList(Arrays.asList(throwable.getStackTrace()));
    }

    public static boolean lazyStackTraceIsLazy() {
        return getStackTraceElementMethod != null && getStackTraceDepthMethod != null;
    }

    private static List<StackTraceElement> jlaStackTrace(final Throwable t) {
        Preconditions.checkNotNull(t);
        return new AbstractList<StackTraceElement>(){

            @Override
            public StackTraceElement get(int n) {
                return (StackTraceElement)Throwables.invokeAccessibleNonThrowingMethod(getStackTraceElementMethod, jla, new Object[]{t, n});
            }

            @Override
            public int size() {
                return (Integer)Throwables.invokeAccessibleNonThrowingMethod(getStackTraceDepthMethod, jla, new Object[]{t});
            }
        };
    }

    @Nullable
    private static Method getGetMethod() {
        return Throwables.getJlaMethod("getStackTraceElement", Throwable.class, Integer.TYPE);
    }

    @Nullable
    private static Method getDepthMethod() {
        return Throwables.getJlaMethod("getStackTraceDepth", Throwable.class);
    }

    private static Object invokeAccessibleNonThrowingMethod(Method method, Object receiver, Object ... params) {
        return Reflects.invoke(method, receiver, params, true, true);
    }
}

