/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.reflect.type.Primitives;
import java.lang.reflect.Array;

public class Arrs {
    public static int getLength(Object object) {
        if (Arrs.isArray(object)) {
            return Array.getLength(object);
        }
        return -1;
    }

    public static boolean isArray(@Nullable Object o) {
        return Emptys.isNull(o) ? false : o.getClass().isArray();
    }

    public static <E> E[] wrapAsArray(@Nullable E o) {
        if (Emptys.isNull(o)) {
            return new Object[0];
        }
        ?[] array = Arrs.createArray(o.getClass(), 1);
        Arrs.initArray(array, o);
        return array;
    }

    public static <E> E[] createArray(@Nullable Class<E> componentType, int length) {
        Preconditions.checkTrue(length >= 0);
        if (componentType == null) {
            return (Object[])Array.newInstance(Object.class, length);
        }
        if (Primitives.isPrimitive(componentType)) {
            componentType = Primitives.wrap(componentType);
        }
        return (Object[])Array.newInstance(componentType, length);
    }

    public static <E> E[] createArray(@Nullable Class<E> componentType, int length, @Nullable E initValue) {
        E[] array = Arrs.createArray(componentType, length);
        Arrs.initArray(array, initValue);
        return array;
    }

    public static <E> E[] createArray(@Nullable Class<E> componentType, int length, @NonNull Supplier<Integer, E> initSupplier) {
        E[] array = Arrs.createArray(componentType, length);
        Arrs.initArray(array, initSupplier);
        return array;
    }

    public static <E> void initArray(@NonNull E[] array, final @Nullable E initValue) {
        Preconditions.checkNotNull(array);
        Arrs.initArray(array, new Supplier<Integer, E>(){

            @Override
            public E get(Integer index) {
                return initValue;
            }
        });
    }

    public static <E> void initArray(@NonNull E[] array, @NonNull Supplier<Integer, E> initSupplier) {
        Preconditions.checkNotNull(initSupplier);
        for (int i = 0; i < array.length; ++i) {
            array[i] = initSupplier.get(i);
        }
    }

    public static Integer[] range(int end) {
        return Arrs.range(0, end);
    }

    public static Integer[] range(int start, int end) {
        return Arrs.range(start, end, 1);
    }

    public static Integer[] range(final int start, int end, final int step) {
        Preconditions.checkTrue(start >= 0);
        Preconditions.checkTrue(end >= start);
        Preconditions.checkTrue(step >= 1);
        int length = new Double(Math.floor((end - 1 - start) / step)).intValue() + 1;
        Preconditions.checkTrue(length >= 0);
        return Arrs.createArray(Integer.class, length, new Supplier<Integer, Integer>(){

            @Override
            public Integer get(Integer index) {
                return start + step * index;
            }
        });
    }
}

