/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.collection.Arrs;
import com.jn.langx.util.collection.NonAbsentHashMap;
import com.jn.langx.util.collection.NonDistinctTreeSet;
import com.jn.langx.util.collection.StringMap;
import com.jn.langx.util.collection.WrappedNonAbsentMap;
import com.jn.langx.util.collection.diff.CollectionDiffResult;
import com.jn.langx.util.collection.diff.CollectionDiffer;
import com.jn.langx.util.collection.diff.KeyBuilder;
import com.jn.langx.util.collection.diff.MapDiffResult;
import com.jn.langx.util.collection.diff.MapDiffer;
import com.jn.langx.util.collection.iter.ArrayIterator;
import com.jn.langx.util.collection.iter.EnumerationIterable;
import com.jn.langx.util.collection.iter.IteratorIterable;
import com.jn.langx.util.collection.iter.WrappedIterable;
import com.jn.langx.util.comparator.ComparableComparator;
import com.jn.langx.util.comparator.Comparators;
import com.jn.langx.util.function.Collector;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Consumer2;
import com.jn.langx.util.function.Function;
import com.jn.langx.util.function.Function2;
import com.jn.langx.util.function.Functions;
import com.jn.langx.util.function.Mapper;
import com.jn.langx.util.function.Mapper2;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.function.Predicate2;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.function.Supplier0;
import com.jn.langx.util.reflect.type.Primitives;
import com.jn.langx.util.struct.Holder;
import com.jn.langx.util.struct.Pair;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;

public class Collects {
    public static <K, V> Hashtable emptyHashtable() {
        return new Hashtable();
    }

    public static <K, V> Map<K, V> emptyTreeMap() {
        return new TreeMap();
    }

    public static <K, V> Map<K, V> emptyTreeMap(@Nullable Comparator<K> comparator) {
        if (comparator == null) {
            return Collects.emptyTreeMap();
        }
        return new TreeMap(comparator);
    }

    public static <K, V> Map<K, V> emptyHashMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> emptyHashMap(boolean sequential) {
        return sequential ? new LinkedHashMap() : new HashMap();
    }

    public static <K, V> NonAbsentHashMap<K, V> emptyNonAbsentHashMap(@NonNull Supplier<K, V> supplier) {
        Preconditions.checkNotNull(supplier);
        return new NonAbsentHashMap<K, V>(supplier);
    }

    public static <K, V> WrappedNonAbsentMap<K, V> wrapAsNonAbsentMap(Map<K, V> map, Supplier<K, V> supplier) {
        Preconditions.checkNotNull(map);
        Preconditions.checkNotNull(supplier);
        return new WrappedNonAbsentMap<K, V>(map, supplier);
    }

    public static <E> HashSet<E> emptyHashSet() {
        return Collects.emptyHashSet(false);
    }

    public static <E> HashSet<E> emptyHashSet(boolean sequential) {
        return sequential ? new LinkedHashSet() : new HashSet();
    }

    public static <E> TreeSet<E> emptyTreeSet() {
        return new TreeSet();
    }

    public static <E> TreeSet<E> emptyTreeSet(@Nullable Comparator<E> comparator) {
        if (comparator == null) {
            return Collects.emptyTreeSet();
        }
        return new TreeSet<E>(comparator);
    }

    public static <E> List<E> emptyArrayList() {
        return new ArrayList();
    }

    public static <E> List<E> emptyLinkedList() {
        return new LinkedList();
    }

    public static <E> E[] emptyArray(@Nullable Class<E> componentType) {
        return Arrs.createArray(Primitives.wrap(componentType), 0);
    }

    public static <K, V> Map<K, V> getEmptyMapIfNull(@Nullable Map<K, V> map) {
        return Collects.getEmptyMapIfNull(map, null);
    }

    public static <K, V> Map<K, V> getEmptyMapIfNull(@Nullable Map<K, V> map, @Nullable MapType mapType) {
        if (map == null) {
            Map map1;
            if (mapType == null) {
                return Collects.emptyHashMap();
            }
            switch (mapType) {
                case StringMap: {
                    map1 = new StringMap();
                    break;
                }
                case HashMap: {
                    map1 = Collects.emptyHashMap();
                    break;
                }
                case TreeMap: {
                    map1 = Collects.emptyTreeMap();
                    break;
                }
                case LinkedHashMap: {
                    map1 = Collects.emptyHashMap(true);
                    break;
                }
                case IdentityHashMap: {
                    map1 = new IdentityHashMap();
                    break;
                }
                case Hashtable: {
                    map1 = Collects.emptyHashtable();
                    break;
                }
                case Properties: {
                    map1 = new Properties();
                    break;
                }
                default: {
                    map1 = Collects.emptyHashMap();
                }
            }
            return map1;
        }
        return map;
    }

    private static SetType inferSetType(@NonNull Set set) {
        Preconditions.checkNotNull(set);
        if (set instanceof SortedSet) {
            return SetType.TreeSet;
        }
        if (set instanceof HashSet) {
            if (set instanceof LinkedHashSet) {
                return SetType.LinkedHashSet;
            }
            return SetType.HashSet;
        }
        return SetType.HashSet;
    }

    public static <E> Set<E> getEmptySetIfNull(@Nullable Set<E> set) {
        return Collects.getEmptySetIfNull(set);
    }

    public static <E> Set<E> getEmptySetIfNull(@Nullable Set<E> set, @Nullable SetType setType) {
        if (set == null) {
            if (setType == null) {
                return Collects.emptyHashSet();
            }
            switch (setType) {
                case HashSet: {
                    set = Collects.emptyHashSet();
                    break;
                }
                case TreeSet: {
                    set = Collects.emptyTreeSet();
                    break;
                }
                case LinkedHashSet: {
                    set = Collects.emptyHashSet(true);
                    break;
                }
                default: {
                    set = Collects.emptyHashSet();
                }
            }
        }
        return set;
    }

    private static ListType inferListType(@NonNull List list) {
        if (list instanceof CopyOnWriteArrayList) {
            return ListType.CopyOnWrite;
        }
        if (list instanceof LinkedList) {
            return ListType.LinkedList;
        }
        if (list instanceof Stack) {
            return ListType.STACK;
        }
        if (list instanceof Vector) {
            return ListType.VECTOR;
        }
        if (list instanceof ArrayList) {
            return ListType.ArrayList;
        }
        return ListType.ArrayList;
    }

    public static <E> List<E> getEmptyListIfNull(@Nullable List<E> list) {
        return Collects.getEmptyListIfNull(list, null);
    }

    public static <E> List<E> getEmptyListIfNull(@Nullable List<E> list, @Nullable ListType listType) {
        if (list == null) {
            if (listType == null) {
                return Collects.emptyArrayList();
            }
            switch (listType) {
                case LinkedList: {
                    list = Collects.emptyLinkedList();
                    break;
                }
                case CopyOnWrite: {
                    list = new CopyOnWriteArrayList();
                    break;
                }
                case STACK: {
                    list = new Stack();
                    break;
                }
                case VECTOR: {
                    list = new Vector();
                    break;
                }
                case ArrayList: {
                    list = Collects.emptyArrayList();
                    break;
                }
                default: {
                    list = Collects.emptyArrayList();
                }
            }
        }
        return list;
    }

    private static Collection emptyCollectionByInfer(Collection prototype) {
        if (prototype == null) {
            return Collects.emptyArrayList();
        }
        if (prototype instanceof Set) {
            SetType setType = SetType.ofSet((Set)prototype);
            return Collects.getEmptySetIfNull(null, setType);
        }
        if (prototype instanceof Queue) {
            return Collects.emptyArrayList();
        }
        if (prototype instanceof List) {
            ListType listType = ListType.ofList((List)prototype);
            return Collects.getEmptyListIfNull(null, listType);
        }
        return Collects.emptyArrayList();
    }

    private static Collection emptyCollection(@Nullable Iterable iterable) {
        if (iterable == null) {
            return Collects.emptyArrayList();
        }
        if (iterable instanceof Collection) {
            return Collects.emptyCollectionByInfer((Collection)iterable);
        }
        return Collects.asList(iterable);
    }

    public static <E> List<E> asList(@Nullable E[] array) {
        return Collects.asList(array, true, ListType.ArrayList);
    }

    public static <E> List<E> asList(@Nullable E[] array, @Nullable ListType listType) {
        return Collects.asList(array, true, listType);
    }

    public static <E> List<E> asList(@Nullable E[] array, boolean mutable, @Nullable ListType listType) {
        List<Object> list;
        List<Object> immutableList;
        List<Object> list2 = immutableList = Emptys.isEmpty(array) ? Collections.emptyList() : Arrays.asList(array);
        if (listType == null) {
            listType = ListType.ArrayList;
        }
        switch (listType) {
            case LinkedList: {
                list = new LinkedList(immutableList);
                break;
            }
            case ArrayList: {
                list = new ArrayList(immutableList);
                break;
            }
            case STACK: {
                list = new Stack();
                list.addAll(immutableList);
                break;
            }
            case VECTOR: {
                list = new Vector(immutableList);
                break;
            }
            case CopyOnWrite: {
                list = new CopyOnWriteArrayList(immutableList);
                break;
            }
            default: {
                list = new ArrayList(immutableList);
            }
        }
        if (!mutable) {
            list = Collections.unmodifiableList(list);
        }
        return list;
    }

    public static <E> List<E> asList(@Nullable Iterable<E> iterable) {
        return Collects.asList(iterable, true);
    }

    public static <E> List<E> asList(@Nullable Iterable<E> iterable, boolean mutable) {
        if (Emptys.isNull(iterable)) {
            return Collects.emptyArrayList();
        }
        if (!(iterable instanceof List)) {
            return Collects.asList(Collects.collect(iterable, Collects.<E>toList()), mutable);
        }
        List list = (List)iterable;
        if (!mutable) {
            return Collections.unmodifiableList(list);
        }
        return list;
    }

    public static <E> Collection<E> asCollection(@Nullable Iterable<E> iterable) {
        if (Emptys.isNull(iterable)) {
            return Collects.emptyArrayList();
        }
        if (!(iterable instanceof Collection)) {
            return Collects.asList(Collects.collect(iterable, Collects.<E>toList()));
        }
        return (Collection)iterable;
    }

    public static <E> Object[] toArray(@Nullable Collection<E> list) {
        if (Emptys.isEmpty(list)) {
            list = Collections.emptyList();
        }
        return list.toArray();
    }

    public static <E> E[] toArray(@Nullable Collection<E> list, @Nullable Class<E[]> clazz) {
        Preconditions.checkNotNull(clazz);
        if (Emptys.isEmpty(list)) {
            list = Collections.emptyList();
        }
        return Arrays.copyOf(list.toArray(), list.size(), clazz);
    }

    public static <E> Iterable<E> asIterable(@Nullable Object object) {
        return Collects.asIterable(object, false);
    }

    public static <E> Iterable<E> asIterable(@Nullable Object object, boolean mutable) {
        if (Emptys.isNull(object)) {
            return Collects.asList(null, mutable, null);
        }
        if (Arrs.isArray(object)) {
            if (mutable) {
                return Collects.asList((Object[])object);
            }
            return new ArrayIterator<Object>((Object[])object);
        }
        if (object instanceof Collection) {
            if (!mutable) {
                return Collections.unmodifiableCollection((Collection)object);
            }
            return (Collection)object;
        }
        if (object instanceof Iterable) {
            if (!mutable) {
                return new WrappedIterable((Iterable)object, false);
            }
            return (Iterable)object;
        }
        if (object instanceof Map) {
            return Collects.asList(Arrs.wrapAsArray(object), mutable, null);
        }
        if (object instanceof Iterator) {
            return new IteratorIterable((Iterator)object, mutable);
        }
        if (object instanceof Enumeration) {
            return new EnumerationIterable((Enumeration)object);
        }
        return Collects.asList(Arrs.wrapAsArray(object), mutable, null);
    }

    public static <E> Collection<E> filter(@Nullable Object anyObject, final @NonNull Predicate<E> predicate) {
        Preconditions.checkNotNull(predicate);
        Iterable<E> iterable = Collects.asIterable(anyObject);
        final Collection result = Collects.emptyCollection(iterable);
        Collects.forEach(iterable, new Consumer<E>(){

            @Override
            public void accept(E e) {
                if (predicate.test(e)) {
                    result.add(e);
                }
            }
        });
        return result;
    }

    public static <K, V> Map<K, V> filter(@Nullable Map<K, V> map, final @NonNull Predicate2<K, V> predicate) {
        Preconditions.checkNotNull(predicate);
        final Map<K, V> result = Collects.getEmptyMapIfNull(null, MapType.ofMap(map));
        if (Emptys.isNotEmpty(map)) {
            Collects.forEach(map, new Consumer2<K, V>(){

                @Override
                public void accept(K key, V value) {
                    if (predicate.test(key, value)) {
                        result.put(key, value);
                    }
                }
            });
        }
        return result;
    }

    public static <E, R> Collection<R> map(@Nullable Object anyObject, final @NonNull Function<E, R> mapper) {
        Preconditions.checkNotNull(mapper);
        Iterable<E> iterable = Collects.asIterable(anyObject);
        final Collection result = Collects.emptyCollection(iterable);
        Collects.forEach(iterable, new Consumer<E>(){

            @Override
            public void accept(E e) {
                result.add(mapper.apply(e));
            }
        });
        return result;
    }

    public static <E, K, V> Map<K, V> map(@Nullable Object anyObject, final @NonNull Mapper<E, Pair<K, V>> mapper) {
        Preconditions.checkNotNull(mapper);
        final Map<K, V> result = Collects.emptyHashMap(true);
        Iterable<E> iterable = Collects.asIterable(anyObject);
        Collects.forEach(iterable, new Consumer<E>(){

            @Override
            public void accept(E e) {
                Pair pair = (Pair)mapper.apply(e);
                result.put(pair.getKey(), pair.getValue());
            }
        });
        return result;
    }

    public static <K, V, R> List<R> map(@Nullable Map<? extends K, ? extends V> map, final @NonNull Function2<K, V, R> mapper) {
        Preconditions.checkNotNull(mapper);
        final List result = Collects.emptyArrayList();
        Collects.forEach(map, new Consumer2<K, V>(){

            @Override
            public void accept(K key, V value) {
                result.add(mapper.apply(key, value));
            }
        });
        return result;
    }

    public static <K, V, K1, V1> Map<K1, V1> map(@Nullable Map<? extends K, ? extends V> map, final @NonNull Mapper2<K, V, Pair<K1, V1>> mapper) {
        Preconditions.checkNotNull(mapper);
        final Map<K, V> result = Collects.getEmptyMapIfNull(null, MapType.ofMap(map));
        if (Emptys.isNotEmpty(map)) {
            Collects.forEach(map.entrySet(), new Consumer<Map.Entry<K, V>>(){

                @Override
                public void accept(Map.Entry<K, V> entry) {
                    Pair e = (Pair)mapper.apply(entry.getKey(), entry.getValue());
                    result.put(e.getKey(), e.getValue());
                }
            });
        }
        return result;
    }

    public static <E, R> Collection<R> flatMap(@Nullable Collection<Collection<E>> collection, final @NonNull Function<E, R> mapper) {
        if (Emptys.isEmpty(collection)) {
            return Collects.emptyArrayList();
        }
        Preconditions.checkNotNull(mapper);
        final Collection list = Collects.emptyCollectionByInfer(collection);
        Collects.forEach(collection, new Consumer<Collection<E>>(){

            @Override
            public void accept(Collection<E> c) {
                Collection rs = Collects.map(c, mapper);
                list.addAll(rs);
            }
        });
        return list;
    }

    public static <E> void forEach(@Nullable Object anyObject, @NonNull Consumer<E> consumer) {
        if (anyObject == null) {
            return;
        }
        Preconditions.checkNotNull(consumer);
        Iterable<E> iterable = Collects.asIterable(anyObject);
        for (E e : iterable) {
            consumer.accept(e);
        }
    }

    public static <E> void forEach(@Nullable E[] array, @NonNull Consumer2<Integer, E> consumer) {
        Preconditions.checkNotNull(consumer);
        if (Emptys.isNotEmpty(array)) {
            for (int i = 0; i < array.length; ++i) {
                consumer.accept(i, array[i]);
            }
        }
    }

    public static <K, V> void forEach(@Nullable Map<? extends K, ? extends V> map, @NonNull Consumer2<K, V> consumer) {
        Preconditions.checkNotNull(consumer);
        if (Emptys.isNotEmpty(map)) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                consumer.accept(entry.getKey(), entry.getValue());
            }
        }
    }

    public static <E> E findFirst(@Nullable Collection<E> collection, @Nullable Predicate<E> predicate) {
        if (Emptys.isEmpty(collection)) {
            return null;
        }
        if (predicate != null) {
            for (E e : collection) {
                if (!predicate.test(e)) continue;
                return e;
            }
        } else {
            Iterator<E> iterator = collection.iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return null;
        }
        return null;
    }

    public static <K, V> Map.Entry<? extends K, ? extends V> findFirst(@Nullable Map<? extends K, ? extends V> map, @Nullable Predicate2<K, V> predicate) {
        if (map == null) {
            return null;
        }
        if (Emptys.isNotEmpty(map)) {
            if (predicate != null) {
                for (Map.Entry<K, V> entry : map.entrySet()) {
                    if (!predicate.test(entry.getKey(), entry.getValue())) continue;
                    return entry;
                }
            } else {
                Set<Map.Entry<? extends K, ? extends V>> set = map.entrySet();
                ArrayList<Map.Entry<K, V>> list = new ArrayList<Map.Entry<K, V>>(set);
                return (Map.Entry)list.get(0);
            }
        }
        return null;
    }

    public static <E> boolean removeIf(@Nullable Collection<E> collection, @NonNull Predicate<E> predicate) {
        boolean hasRemoved = false;
        if (Emptys.isNotEmpty(collection)) {
            hasRemoved = Collects.removeIf(collection.iterator(), predicate);
        }
        return hasRemoved;
    }

    public static <E> boolean removeIf(@Nullable Iterator<E> iterator, @NonNull Predicate<E> predicate) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(predicate);
        boolean hasRemoved = false;
        while (iterator.hasNext()) {
            E e = iterator.next();
            if (!predicate.test(e)) continue;
            try {
                iterator.remove();
            }
            catch (UnsupportedOperationException ex) {
                break;
            }
            hasRemoved = true;
        }
        return hasRemoved;
    }

    public static <K, V> boolean removeIf(@Nullable Map<K, V> map, @NonNull Predicate2<K, V> predicate) {
        Preconditions.checkNotNull(predicate);
        boolean hasRemoved = false;
        if (Emptys.isNotEmpty(map)) {
            Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<K, V> e = iterator.next();
                if (!predicate.test(e.getKey(), e.getValue())) continue;
                iterator.remove();
                hasRemoved = true;
            }
        }
        return hasRemoved;
    }

    public static <E> boolean anyMatch(@Nullable Collection<E> collection, @NonNull Predicate<E> predicate) {
        Preconditions.checkNotNull(predicate);
        if (Emptys.isNotEmpty(collection)) {
            E e = Collects.findFirst(collection, predicate);
            return e != null;
        }
        return false;
    }

    public static <K, V> boolean anyMatch(@Nullable Map<? extends K, ? extends V> map, @NonNull Predicate2<K, V> predicate) {
        Preconditions.checkNotNull(predicate);
        if (Emptys.isNotEmpty(map)) {
            Map.Entry<? extends K, ? extends V> entry = Collects.findFirst(map, predicate);
            return entry != null;
        }
        return false;
    }

    public static <E> boolean allMatch(@Nullable Iterable<E> collection, @NonNull Predicate<E> predicate) {
        Preconditions.checkNotNull(predicate);
        if (Emptys.isNotEmpty(collection)) {
            for (E e : collection) {
                if (predicate.test(e)) continue;
                return false;
            }
        }
        return true;
    }

    public static <K, V> boolean allMatch(@Nullable Map<? extends K, ? extends V> map, @NonNull Predicate2<K, V> predicate) {
        Preconditions.checkNotNull(predicate);
        if (Emptys.isNotEmpty(map)) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                if (predicate.test(e.getKey(), e.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public static <E> boolean noneMatch(@Nullable Iterable<E> collection, @NonNull Predicate<E> predicate) {
        Preconditions.checkNotNull(predicate);
        if (Emptys.isNotEmpty(collection)) {
            Iterator<E> iterator = collection.iterator();
            for (E e : collection) {
                if (!predicate.test(e)) continue;
                return false;
            }
        }
        return true;
    }

    public static <K, V> boolean noneMatch(@Nullable Map<? extends K, ? extends V> map, @NonNull Predicate2<K, V> predicate) {
        Preconditions.checkNotNull(predicate);
        if (Emptys.isNotEmpty(map)) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                if (!predicate.test(e.getKey(), e.getValue())) continue;
                return false;
            }
        }
        return true;
    }

    public static <E> Set<E> distinct(@Nullable Collection<E> collection) {
        return new LinkedHashSet(Emptys.isEmpty(collection) ? Collections.EMPTY_LIST : collection);
    }

    public static <E> List<E> limit(@Nullable Collection<E> collection, int maxSize) {
        List list;
        if (Emptys.isEmpty(collection)) {
            return Collects.emptyLinkedList();
        }
        Preconditions.checkTrue(maxSize >= 0);
        List list2 = list = collection instanceof List ? (List)collection : new LinkedList<E>(collection);
        if (list.size() <= maxSize) {
            return list;
        }
        return list.subList(0, maxSize);
    }

    public static <E> List<E> skip(@Nullable Collection<E> collection, int n) {
        List list;
        if (Emptys.isEmpty(collection)) {
            return Collects.emptyLinkedList();
        }
        Preconditions.checkTrue(n >= 0);
        List list2 = list = collection instanceof List ? (List)collection : new LinkedList<E>(collection);
        if (list.size() <= n) {
            return Collects.emptyArrayList();
        }
        return list.subList(n, list.size());
    }

    public static <E extends Comparable<E>> TreeSet<E> sort(@Nullable Collection<E> collection, boolean reverse) {
        return Collects.sort(collection, new ComparableComparator(), reverse);
    }

    public static <E> TreeSet<E> sort(@Nullable Collection<E> collection, @NonNull Comparator<E> comparator) {
        return Collects.sort(collection, comparator, false);
    }

    public static <E> TreeSet<E> sort(@Nullable Collection<E> collection, @NonNull Comparator<E> comparator, boolean reverse) {
        Preconditions.checkNotNull(comparator);
        if (Emptys.isEmpty(collection)) {
            return new TreeSet<E>(comparator);
        }
        NonDistinctTreeSet set = new NonDistinctTreeSet(reverse ? Collections.reverseOrder(comparator) : comparator);
        set.addAll(Collects.filter(collection, Functions.nonNullPredicate()));
        return set;
    }

    public static <K, V> Map<K, V> sort(@Nullable Map<K, V> map, @NonNull Comparator<K> comparator) {
        Preconditions.checkNotNull(comparator);
        Map<K, V> result = Collects.emptyTreeMap(comparator);
        if (Emptys.isNotEmpty(map)) {
            result.putAll(map);
        }
        return result;
    }

    public static <E> List<E> reverse(@Nullable List<E> list, boolean newOne) {
        if (Emptys.isEmpty(list)) {
            return list == null || newOne ? Collects.emptyArrayList() : list;
        }
        if (!newOne) {
            Collections.reverse(list);
            return list;
        }
        ArrayList<E> newList = new ArrayList<E>();
        for (int i = list.size() - 1; i >= 0; --i) {
            newList.add(list.get(i));
        }
        return newList;
    }

    public static <K, V> int count(@Nullable Map<K, V> map) {
        return Emptys.isEmpty(map) ? 0 : map.size();
    }

    public static <E> int count(@Nullable Collection<E> collection) {
        return Emptys.isEmpty(collection) ? 0 : collection.size();
    }

    public static int count(@Nullable Object anyObject) {
        final Holder<Integer> count = new Holder<Integer>(0);
        Collects.forEach(anyObject, new Consumer<Object>(){

            @Override
            public void accept(Object object) {
                count.set((Integer)count.get() + 1);
            }
        });
        return count.get();
    }

    public static <E> E max(@NonNull Object object, final @NonNull Comparator<E> comparator) {
        Preconditions.checkNotNull(comparator);
        Iterable<E> iterable = Collects.asIterable(object);
        final Holder max = new Holder();
        Collects.forEach(iterable, new Consumer<E>(){

            @Override
            public void accept(E e) {
                if (max.get() == null) {
                    max.set(e);
                } else {
                    int delta = comparator.compare(e, max.get());
                    if (delta > 0) {
                        max.set(e);
                    }
                }
            }
        });
        return (E)max.get();
    }

    public static <E> E min(@Nullable Object object, final @NonNull Comparator<E> comparator) {
        Preconditions.checkNotNull(comparator);
        Iterable<E> iterable = Collects.asIterable(object);
        final Holder min = new Holder();
        Collects.forEach(iterable, new Consumer<E>(){

            @Override
            public void accept(E e) {
                if (min.get() == null) {
                    min.set(e);
                } else {
                    int delta = comparator.compare(e, min.get());
                    if (delta < 0) {
                        min.set(e);
                    }
                }
            }
        });
        return (E)min.get();
    }

    public static <E, R> R collect(@Nullable Object anyObject, @NonNull Collector<E, R> collector) {
        Preconditions.checkNotNull(collector);
        return Collects.collect(anyObject, collector.supplier(), collector.accumulator());
    }

    public static <E, R> R collect(@Nullable Object anyObject, @NonNull Supplier0<R> containerFactory, final @NonNull Consumer2<R, E> consumer) {
        Preconditions.checkNotNull(containerFactory);
        Preconditions.checkNotNull(consumer);
        final R container = containerFactory.get();
        Collects.forEach(anyObject, new Consumer<E>(){

            @Override
            public void accept(E e) {
                consumer.accept(container, e);
            }
        });
        return container;
    }

    public static <E> Collection<E> collect(@Nullable Object anyObject, final @NonNull Collection<E> container) {
        Preconditions.checkNotNull(container);
        Supplier0 containerFactory = new Supplier0<Collection<E>>(){

            @Override
            public Collection<E> get() {
                return container;
            }
        };
        Consumer2 consumer = new Consumer2<Collection<E>, E>(){

            @Override
            public void accept(Collection<E> list, E value) {
                list.add(value);
            }
        };
        return (Collection)Collects.collect(anyObject, containerFactory, consumer);
    }

    public static <E> CollectionDiffResult<E> diff(@Nullable Collection<E> oldCollection, @Nullable Collection<E> newCollection) {
        return Collects.diff(oldCollection, newCollection, null);
    }

    public static <E> CollectionDiffResult<E> diff(@Nullable Collection<E> oldCollection, @Nullable Collection<E> newCollection, @Nullable Comparator<E> elementComparator) {
        return Collects.diff(oldCollection, newCollection, elementComparator, null);
    }

    public static <E> CollectionDiffResult<E> diff(@Nullable Collection<E> oldCollection, @Nullable Collection<E> newCollection, @Nullable Comparator<E> elementComparator, @Nullable KeyBuilder<String, E> keyBuilder) {
        CollectionDiffer<E> differ = new CollectionDiffer<E>();
        differ.setComparator(elementComparator);
        if (keyBuilder != null) {
            differ.diffUsingMap(keyBuilder);
        }
        return differ.diff(oldCollection, newCollection);
    }

    public static <K, V> MapDiffResult<K, V> diff(@Nullable Map<K, V> oldMap, @Nullable Map<K, V> newMap) {
        return Collects.diff(oldMap, newMap, null);
    }

    public static <K, V> MapDiffResult<K, V> diff(@Nullable Map<K, V> oldMap, @Nullable Map<K, V> newMap, @Nullable Comparator<V> valueComparator) {
        return Collects.diff(oldMap, newMap, valueComparator, null);
    }

    public static <K, V> MapDiffResult<K, V> diff(@Nullable Map<K, V> oldMap, @Nullable Map<K, V> newMap, @Nullable Comparator<V> valueComparator, @Nullable Comparator<K> keyComparator) {
        MapDiffer<K, V> differ = new MapDiffer<K, V>();
        differ.setValueComparator(valueComparator);
        differ.setKeyComparator(keyComparator);
        return differ.diff(oldMap, newMap);
    }

    public static Map<String, String> propertiesToStringMap(@Nullable Properties properties) {
        return Collects.propertiesToStringMap(properties, false);
    }

    public static Map<String, String> propertiesToStringMap(@Nullable Properties properties, boolean sort) {
        return Collects.propertiesToStringMap(properties, Comparators.STRING_COMPARATOR_IGNORE_CASE);
    }

    public static Map<String, String> propertiesToStringMap(@Nullable Properties properties, @Nullable Comparator<String> keyComparator) {
        TreeMap<String, String> map;
        AbstractMap abstractMap = map = keyComparator != null ? new TreeMap(keyComparator) : new StringMap();
        if (Emptys.isNotEmpty(properties)) {
            Collects.forEach(properties, new Consumer2<Object, Object>(){

                @Override
                public void accept(Object key, Object value) {
                    map.put(key.toString(), value.toString());
                }
            });
        }
        return map;
    }

    public static <E> Collector<E, TreeSet<E>> toTreeSet(final @Nullable Comparator<E> comparator) {
        return new Collector<E, TreeSet<E>>(){

            @Override
            public Supplier0<TreeSet<E>> supplier() {
                return Functions.emptyTreeSetSupplier0(comparator);
            }

            @Override
            public Consumer2<TreeSet<E>, E> accumulator() {
                return new Consumer2<TreeSet<E>, E>(){

                    @Override
                    public void accept(TreeSet<E> set, E value) {
                        set.add(value);
                    }
                };
            }
        };
    }

    public static <E> Collector<E, HashSet<E>> toHashSet(boolean sequential) {
        return new Collector<E, HashSet<E>>(){

            @Override
            public Supplier0<HashSet<E>> supplier() {
                return Functions.emptyHashSetSupplier0();
            }

            @Override
            public Consumer2<HashSet<E>, E> accumulator() {
                return new Consumer2<HashSet<E>, E>(){

                    @Override
                    public void accept(HashSet<E> set, E value) {
                        set.add(value);
                    }
                };
            }
        };
    }

    public static <E> Collector<E, List<E>> toList() {
        return new Collector<E, List<E>>(){

            @Override
            public Supplier0<List<E>> supplier() {
                return new Supplier0<List<E>>(){

                    @Override
                    public List<E> get() {
                        return Collects.emptyArrayList();
                    }
                };
            }

            @Override
            public Consumer2<List<E>, E> accumulator() {
                return new Consumer2<List<E>, E>(){

                    @Override
                    public void accept(List<E> list, E value) {
                        list.add(value);
                    }
                };
            }
        };
    }

    public static <E, K, V> Collector<E, Map<K, V>> toHashMap(final @NonNull Function<E, K> keyMapper, final @NonNull Function<E, V> valueMapper, final boolean sequential) {
        Preconditions.checkNotNull(keyMapper);
        Preconditions.checkNotNull(valueMapper);
        return new Collector<E, Map<K, V>>(){

            @Override
            public Supplier0<Map<K, V>> supplier() {
                return new Supplier0<Map<K, V>>(){

                    @Override
                    public Map<K, V> get() {
                        return Collects.emptyHashMap(sequential);
                    }
                };
            }

            @Override
            public Consumer2<Map<K, V>, E> accumulator() {
                return new Consumer2<Map<K, V>, E>(){

                    @Override
                    public void accept(Map<K, V> map, E e) {
                        Object key = keyMapper.apply(e);
                        Object value = valueMapper.apply(e);
                        map.put(key, value);
                    }
                };
            }
        };
    }

    public static <E, K, V> Collector<E, Map<K, V>> toTreeMap(final @NonNull Function<E, K> keyMapper, final @NonNull Function<E, V> valueMapper, final @Nullable Comparator<K> comparator) {
        Preconditions.checkNotNull(keyMapper);
        Preconditions.checkNotNull(valueMapper);
        return new Collector<E, Map<K, V>>(){

            @Override
            public Supplier0<Map<K, V>> supplier() {
                return new Supplier0<Map<K, V>>(){

                    @Override
                    public Map<K, V> get() {
                        return Collects.emptyTreeMap(comparator);
                    }
                };
            }

            @Override
            public Consumer2<Map<K, V>, E> accumulator() {
                return new Consumer2<Map<K, V>, E>(){

                    @Override
                    public void accept(Map<K, V> map, E e) {
                        Object key = keyMapper.apply(e);
                        Object value = valueMapper.apply(e);
                        map.put(key, value);
                    }
                };
            }
        };
    }

    public static <E> void addAll(final Collection<E> collection, Iterable<E> iterable) {
        if (Emptys.isNotEmpty(iterable)) {
            Collects.forEach(iterable, new Consumer<E>(){

                @Override
                public void accept(E e) {
                    collection.add(e);
                }
            });
        }
    }

    public static <E> void addAll(Collection<E> collection, E[] iterator) {
        Collects.addAll(collection, Collects.asIterable(iterator));
    }

    public static <E> void addAll(Collection<E> collection, Iterator<E> iterator) {
        Collects.addAll(collection, Collects.asIterable(iterator));
    }

    public static <E> Collection<E> concat(@Nullable Collection<E> c1, @Nullable Collection<E> c2) {
        return Collects.concat(c1, c2, true);
    }

    public static <E> Collection<E> concat(@Nullable Collection<E> c1, @Nullable Collection<E> c2, boolean newOne) {
        if (newOne) {
            List<E> l = Collects.emptyArrayList();
            if (Emptys.isNotEmpty(c1)) {
                l.addAll(c1);
            }
            if (Emptys.isNotEmpty(c2)) {
                l.addAll(c2);
            }
            return l;
        }
        Preconditions.checkNotNull(c1);
        if (Emptys.isNotEmpty(c2)) {
            c1.addAll(c2);
        }
        return c1;
    }

    public static <E> Collection<E> merge(@Nullable Collection<E> c1, @Nullable Collection<E> c2) {
        return Collects.merge(c1, c2, true);
    }

    public static <E> Collection<E> merge(final @Nullable Collection<E> c1, @Nullable Collection<E> c2, boolean newOne) {
        if (newOne) {
            HashSet<E> set = Collects.emptyHashSet(true);
            if (Emptys.isNotEmpty(c1)) {
                set.addAll(c1);
            }
            if (Emptys.isNotEmpty(c2)) {
                set.addAll(c2);
            }
            return set;
        }
        Preconditions.checkNotNull(c1);
        if (Emptys.isNotEmpty(c2)) {
            HashSet<E> set = Collects.emptyHashSet(true);
            set.addAll(c2);
            Collects.forEach(c2, new Consumer<E>(){

                @Override
                public void accept(E e) {
                    if (!c1.contains(e)) {
                        c1.add(e);
                    }
                }
            });
        }
        return c1;
    }

    public static <K, V> Map<K, V> merge(@Nullable Map<K, V> map1, @Nullable Map<K, V> map2) {
        return Collects.merge(map1, map2, true);
    }

    public static <K, V> Map<K, V> merge(@Nullable Map<K, V> map1, @Nullable Map<K, V> map2, boolean newOne) {
        if (newOne) {
            Map<K, V> map = Collects.emptyHashMap();
            if (Emptys.isNotEmpty(map1)) {
                map.putAll(map1);
            }
            if (Emptys.isNotEmpty(map2)) {
                map.putAll(map2);
            }
            return map;
        }
        Preconditions.checkNotNull(map1);
        if (Emptys.isNotEmpty(map2)) {
            map1.putAll(map2);
        }
        return map1;
    }

    public static enum ListType {
        ArrayList,
        LinkedList,
        CopyOnWrite,
        VECTOR,
        STACK;


        public static ListType ofList(@Nullable List list) {
            if (list == null) {
                return ArrayList;
            }
            return Collects.inferListType(list);
        }
    }

    public static enum SetType {
        HashSet,
        LinkedHashSet,
        TreeSet;


        public static SetType ofSet(@Nullable Set set) {
            if (set == null) {
                return HashSet;
            }
            return Collects.inferSetType(set);
        }
    }

    public static enum MapType {
        StringMap,
        HashMap,
        TreeMap,
        LinkedHashMap,
        IdentityHashMap,
        Hashtable,
        Properties;


        public static MapType ofMap(@Nullable Map map) {
            if (map == null) {
                return HashMap;
            }
            if (map instanceof StringMap) {
                return StringMap;
            }
            if (map instanceof Properties) {
                return Properties;
            }
            if (map instanceof Hashtable) {
                return Hashtable;
            }
            if (map instanceof IdentityHashMap) {
                return IdentityHashMap;
            }
            if (map instanceof LinkedHashMap) {
                return LinkedHashMap;
            }
            if (map instanceof TreeMap) {
                return TreeMap;
            }
            return HashMap;
        }
    }
}

