/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.diff;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Differ;
import com.jn.langx.util.collection.diff.CollectionDiffResult;
import com.jn.langx.util.collection.diff.KeyBuilder;
import com.jn.langx.util.collection.diff.MapDiffResult;
import com.jn.langx.util.collection.diff.MapDiffer;
import com.jn.langx.util.comparator.EqualsComparator;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Mapper;
import com.jn.langx.util.function.Predicate;
import com.jn.langx.util.struct.Entry;
import com.jn.langx.util.struct.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;

public class CollectionDiffer<E>
implements Differ<Collection<E>, CollectionDiffResult<E>> {
    private Comparator<E> comparator;
    private KeyBuilder<String, E> keyBuilder;

    public void diffUsingMap(@Nullable KeyBuilder<String, E> keyBuilder) {
        this.keyBuilder = keyBuilder;
    }

    public void setComparator(@Nullable Comparator<E> comparator) {
        this.comparator = comparator;
    }

    @Override
    public CollectionDiffResult<E> diff(@Nullable Collection<E> oldCollection, @Nullable Collection<E> newCollection) {
        CollectionDiffResult<Object> result = new CollectionDiffResult<Object>();
        if (oldCollection == null && newCollection == null) {
            return result;
        }
        if (oldCollection == null) {
            result.setAdds(newCollection);
            return result;
        }
        if (newCollection == null) {
            result.setRemoves(oldCollection);
            return result;
        }
        if (this.isDiffUsingMapDiffer()) {
            Map oldMap = Collects.map(oldCollection, new Mapper<E, Pair<String, E>>(){

                @Override
                public Pair<String, E> apply(E element) {
                    return new Entry(CollectionDiffer.this.keyBuilder.getKey(element), element);
                }
            });
            Map newMap = Collects.map(newCollection, new Mapper<E, Pair<String, E>>(){

                @Override
                public Pair<String, E> apply(E element) {
                    return new Entry(CollectionDiffer.this.keyBuilder.getKey(element), element);
                }
            });
            MapDiffer<Object, Object> mapDiffer = new MapDiffer<Object, Object>();
            mapDiffer.setValueComparator(this.comparator);
            mapDiffer.setKeyComparator(new EqualsComparator());
            MapDiffResult dr = mapDiffer.diff(oldMap, newMap);
            result.setAdds(dr.getAdds().values());
            result.setRemoves(dr.getRemoves().values());
            result.setEquals(dr.getEquals().values());
            result.setUpdates(dr.getUpdates().values());
        } else if (this.isDiffUsingEqualMethod()) {
            this.diffWithObjectEquals(oldCollection, newCollection, result);
        } else {
            this.diffWithComparator(oldCollection, newCollection, result);
        }
        return result;
    }

    private boolean isDiffUsingMapDiffer() {
        return this.keyBuilder != null;
    }

    private boolean isDiffUsingEqualMethod() {
        return this.comparator == null || this.comparator instanceof EqualsComparator;
    }

    private void diffWithObjectEquals(Collection<E> oldCollection, Collection<E> newCollection, CollectionDiffResult<E> result) {
        ArrayList<E> removes = new ArrayList<E>(oldCollection);
        removes.removeAll(newCollection);
        result.setRemoves(removes);
        ArrayList<E> equals = new ArrayList<E>(oldCollection);
        equals.removeAll(removes);
        result.setEquals(equals);
        ArrayList<E> adds = new ArrayList<E>(newCollection);
        adds.removeAll(oldCollection);
        result.setAdds(adds);
    }

    private void diffWithComparator(final Collection<E> oldCollection, final Collection<E> newCollection, CollectionDiffResult<E> result) {
        final ArrayList adds = new ArrayList();
        final ArrayList removes = new ArrayList();
        final ArrayList equals = new ArrayList();
        Collects.forEach(newCollection, new Consumer<E>(){

            @Override
            public void accept(final E newValue) {
                if (Collects.anyMatch(oldCollection, new Predicate<E>(){

                    @Override
                    public boolean test(E oldValue) {
                        return CollectionDiffer.this.comparator.compare(oldValue, newValue) == 0;
                    }
                })) {
                    equals.add(newValue);
                } else {
                    adds.add(newValue);
                }
            }
        });
        Collects.forEach(oldCollection, new Consumer<E>(){

            @Override
            public void accept(final E oldValue) {
                if (Collects.noneMatch(newCollection, new Predicate<E>(){

                    @Override
                    public boolean test(E newValue) {
                        return CollectionDiffer.this.comparator.compare(oldValue, newValue) == 0;
                    }
                })) {
                    removes.add(oldValue);
                }
            }
        });
        result.setAdds(adds);
        result.setRemoves(removes);
        result.setEquals(equals);
    }
}

