/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.concurrent;

import com.jn.langx.factory.Factory;
import com.jn.langx.util.Strings;
import com.jn.langx.util.concurrent.WrappedThread;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class CommonThreadFactory
implements ThreadFactory,
Factory<Runnable, Thread> {
    private static final Map<String, AtomicLong> threadNumber = new ConcurrentHashMap<String, AtomicLong>();
    private static final Map<String, Integer> factoryToNumber = new ConcurrentHashMap<String, Integer>();
    private static AtomicInteger factoryNumber = new AtomicInteger(0);
    private boolean daemon;
    private String prefix;
    private int factoryNo = 0;

    public CommonThreadFactory() {
        this("COMMON", false);
    }

    public CommonThreadFactory(String prefix, boolean daemon) {
        if (Strings.isBlank(prefix)) {
            prefix = "COMMON";
        }
        this.daemon = daemon;
        this.prefix = prefix;
        if (threadNumber.containsKey(prefix)) {
            this.factoryNo = factoryToNumber.get(prefix);
        } else {
            this.factoryNo = factoryNumber.getAndIncrement();
            factoryToNumber.put(prefix, this.factoryNo);
        }
    }

    private String nextThreadName() {
        return this.prefix + "(" + this.factoryNo + "-" + threadNumber.get(this.prefix).getAndIncrement() + ")";
    }

    @Override
    public Thread newThread(Runnable r) {
        WrappedThread thread = new WrappedThread(r, this.nextThreadName());
        thread.setDaemon(this.daemon);
        return thread;
    }

    @Override
    public Thread get(Runnable runnable) {
        return this.newThread(runnable);
    }

    public static ThreadFactory create(String prefix, boolean daemon) {
        return new CommonThreadFactory(prefix, daemon);
    }

    public static ThreadFactory create(String prefix) {
        return new CommonThreadFactory(prefix, false);
    }
}

