/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.concurrent.interceptor;

import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.concurrent.TaskInterceptor;
import com.jn.langx.util.concurrent.interceptor.LoggerInterceptor;
import java.util.LinkedList;
import java.util.List;

public class TaskInterceptorChain
implements TaskInterceptor {
    private LinkedList<TaskInterceptor> interceptors = new LinkedList();

    public TaskInterceptorChain() {
        this.interceptors.add(new LoggerInterceptor());
    }

    public void addInterceptor(TaskInterceptor interceptor) {
        if (interceptor != null) {
            TaskInterceptor loggerInterceptor = this.interceptors.remove(this.interceptors.size() - 1);
            this.interceptors.addLast(interceptor);
            this.interceptors.addLast(loggerInterceptor);
        }
    }

    @Override
    public void doBefore() {
        for (TaskInterceptor interceptor : this.interceptors) {
            interceptor.doBefore();
        }
    }

    @Override
    public void doAfter() {
        if (!this.interceptors.isEmpty()) {
            List<TaskInterceptor> chain = Collects.reverse(this.interceptors, true);
            for (TaskInterceptor interceptor : chain) {
                interceptor.doAfter();
            }
        }
    }

    @Override
    public void doError(Throwable ex) {
        if (!this.interceptors.isEmpty()) {
            List<TaskInterceptor> chain = Collects.reverse(this.interceptors, true);
            for (TaskInterceptor interceptor : chain) {
                interceptor.doError(ex);
            }
        }
    }
}

