/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.id;

import com.jn.langx.IdGenerator;
import com.jn.langx.codec.base64.Base64;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;

public class Base64IdGenerator
implements IdGenerator {
    public static final SecureRandom INSTANCE = new SecureRandom();

    public String get(Object o) {
        return this.getBase64UUID(INSTANCE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBase64UUIDSecureString() {
        byte[] uuidBytes = null;
        byte[] encodedBytes = null;
        try {
            uuidBytes = this.getUUIDBytes(INSTANCE);
            String string = Base64.encodeBase64URLSafeString(uuidBytes);
            return string;
        }
        finally {
            if (uuidBytes != null) {
                Arrays.fill(uuidBytes, (byte)0);
            }
            if (encodedBytes != null) {
                Arrays.fill(encodedBytes, (byte)0);
            }
        }
    }

    public String getBase64UUID(Random random) {
        return Base64.encodeBase64URLSafeString(this.getUUIDBytes(random));
    }

    private byte[] getUUIDBytes(Random random) {
        byte[] randomBytes = new byte[16];
        random.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0x80);
        return randomBytes;
    }
}

