/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.io;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.InternalThreadLocalMap;
import com.jn.langx.util.Preconditions;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public final class Charsets {
    public static final Charset GBK = Charset.forName("GBK");
    public static final Charset GB2312 = Charset.forName("GB2312");
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final Charset UTF_16BE = Charset.forName("UTF-16BE");
    public static final Charset UTF_16LE = Charset.forName("UTF-16LE");
    public static final Charset UTF_16 = Charset.forName("UTF-16");
    public static final Charset US_ASCII = Charset.forName("US-ASCII");
    public static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");

    private Charsets() {
    }

    public static Charset getCharset(@Nullable Charset charset) {
        return charset == null ? Charset.defaultCharset() : charset;
    }

    public static Charset getCharset(@Nullable String name) {
        return name == null ? Charset.defaultCharset() : Charset.forName(name);
    }

    public static Charset getCharset(@Nullable String name, @Nullable String defaultName) {
        return name == null ? (defaultName == null ? Charset.defaultCharset() : Charset.forName(defaultName)) : Charset.forName(name);
    }

    public static CharsetEncoder encoder(@NonNull Charset charset, @NonNull CodingErrorAction malformedInputAction, @NonNull CodingErrorAction unmappableCharacterAction) {
        Preconditions.checkNotNull(charset);
        CharsetEncoder e = charset.newEncoder();
        e.onMalformedInput(malformedInputAction).onUnmappableCharacter(unmappableCharacterAction);
        return e;
    }

    public static CharsetEncoder encoder(@NonNull Charset charset, @NonNull CodingErrorAction codingErrorAction) {
        return Charsets.encoder(charset, codingErrorAction, codingErrorAction);
    }

    public static CharsetEncoder encoder(@NonNull Charset charset) {
        Preconditions.checkNotNull(charset, "charset");
        CharsetEncoder e = InternalThreadLocalMap.getEncoder(charset);
        e.reset().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        return e;
    }

    public static CharsetDecoder decoder(@NonNull Charset charset, @NonNull CodingErrorAction malformedInputAction, @NonNull CodingErrorAction unmappableCharacterAction) {
        Preconditions.checkNotNull(charset, "charset");
        CharsetDecoder d = charset.newDecoder();
        d.onMalformedInput(malformedInputAction).onUnmappableCharacter(unmappableCharacterAction);
        return d;
    }

    public static CharsetDecoder decoder(@NonNull Charset charset, @NonNull CodingErrorAction codingErrorAction) {
        return Charsets.decoder(charset, codingErrorAction, codingErrorAction);
    }

    public static CharsetDecoder decoder(@NonNull Charset charset) {
        Preconditions.checkNotNull(charset, "charset");
        CharsetDecoder d = InternalThreadLocalMap.getDecoder(charset);
        d.reset().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        return d;
    }
}

