/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.io;

import com.jn.langx.annotation.NonNull;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class LineDelimiter {
    public static char CR = (char)13;
    public static char LF = (char)10;
    public static String CR_LF = "" + CR + LF;
    public static final LineDelimiter DEFAULT;
    public static final LineDelimiter CRLF;
    public static final LineDelimiter UNIX;
    public static final LineDelimiter WINDOWS;
    public static final LineDelimiter MAC;
    public static final LineDelimiter NUL;
    private final String value;

    public LineDelimiter(@NonNull String delimiter) {
        this.value = delimiter;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LineDelimiter)) {
            return false;
        }
        LineDelimiter that = (LineDelimiter)o;
        return this.value.equals(that.value);
    }

    public String toString() {
        if (this.value.length() == 0) {
            return "delimiter: auto";
        }
        StringBuilder buf = new StringBuilder();
        buf.append("delimiter:");
        for (int i = 0; i < this.value.length(); ++i) {
            buf.append(" 0x");
            buf.append(Integer.toHexString(this.value.charAt(i)));
        }
        return buf.toString();
    }

    static {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(bout, true);
        out.println();
        DEFAULT = new LineDelimiter(new String(bout.toByteArray()));
        CRLF = new LineDelimiter(CR_LF);
        UNIX = new LineDelimiter("\n");
        WINDOWS = CRLF;
        MAC = new LineDelimiter("\r");
        NUL = new LineDelimiter("\u0000");
    }
}

