/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.io.file;

import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Predicate;

public class Filenames {
    public static boolean checkFileSegment(String filename) {
        return filename.matches("^[^\\\\/:\\*\\?\">\\|<]+(\\.[^\\\\/:\\*\\?\">\\|<]+)?$");
    }

    public static boolean checkFilePath(String filePath) {
        int partitionSeparatorIndex;
        String partition = (filePath = Filenames.asUnixFilePath(filePath)).substring(0, partitionSeparatorIndex = filePath.indexOf(":"));
        if (Strings.isNotBlank(partition) && !Filenames.checkFileSegment(partition)) {
            return false;
        }
        filePath = filePath.substring(partitionSeparatorIndex + 1);
        filePath = filePath.replaceAll("\\\\+", "/");
        String[] pathSegments = Strings.split(filePath, "/");
        return Collects.allMatch(Collects.asList(pathSegments), new Predicate<String>(){

            @Override
            public boolean test(String pathSegment) {
                return Filenames.checkFileSegment(pathSegment);
            }
        });
    }

    public static String asUnixFilePath(String filePath) {
        Preconditions.checkNotNull(filePath);
        return filePath.trim().replaceAll("\\\\", "/").replaceAll("/+", "/");
    }

    public static String extractFilename(String filePath) {
        Preconditions.checkTrue(Strings.isNotBlank(filePath));
        int lastFileSeparatorIndex = Filenames.asUnixFilePath(filePath).lastIndexOf("/");
        return filePath.substring(lastFileSeparatorIndex + 1);
    }

    public static String getSuffix(String filePath) {
        String filename = Filenames.extractFilename(filePath);
        int index = filename.lastIndexOf(".");
        return filename.substring(index + 1);
    }

    public static String getSuffixAsLowCase(String filename) {
        return Filenames.getSuffix(filename).toLowerCase();
    }

    public static String getSuffixAsUpperCase(String filename) {
        return Filenames.getSuffix(filename).toUpperCase();
    }
}

