/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime;

import com.jn.langx.util.jodatime.Chronology;
import com.jn.langx.util.jodatime.DateTimeUtils;
import com.jn.langx.util.jodatime.Duration;
import com.jn.langx.util.jodatime.DurationFieldType;
import com.jn.langx.util.jodatime.Hours;
import com.jn.langx.util.jodatime.LocalDate;
import com.jn.langx.util.jodatime.Minutes;
import com.jn.langx.util.jodatime.Period;
import com.jn.langx.util.jodatime.PeriodType;
import com.jn.langx.util.jodatime.ReadableInstant;
import com.jn.langx.util.jodatime.ReadableInterval;
import com.jn.langx.util.jodatime.ReadablePartial;
import com.jn.langx.util.jodatime.ReadablePeriod;
import com.jn.langx.util.jodatime.Seconds;
import com.jn.langx.util.jodatime.Weeks;
import com.jn.langx.util.jodatime.base.BaseSingleFieldPeriod;
import com.jn.langx.util.jodatime.field.FieldUtils;
import com.jn.langx.util.jodatime.format.ISOPeriodFormat;
import com.jn.langx.util.jodatime.format.PeriodFormatter;

public final class Days
extends BaseSingleFieldPeriod {
    public static final Days ZERO = new Days(0);
    public static final Days ONE = new Days(1);
    public static final Days TWO = new Days(2);
    public static final Days THREE = new Days(3);
    public static final Days FOUR = new Days(4);
    public static final Days FIVE = new Days(5);
    public static final Days SIX = new Days(6);
    public static final Days SEVEN = new Days(7);
    public static final Days MAX_VALUE = new Days(Integer.MAX_VALUE);
    public static final Days MIN_VALUE = new Days(Integer.MIN_VALUE);
    private static final PeriodFormatter PARSER = ISOPeriodFormat.standard().withParseType(PeriodType.days());
    private static final long serialVersionUID = 87525275727380865L;

    public static Days days(int days) {
        switch (days) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 4: {
                return FOUR;
            }
            case 5: {
                return FIVE;
            }
            case 6: {
                return SIX;
            }
            case 7: {
                return SEVEN;
            }
            case 0x7FFFFFFF: {
                return MAX_VALUE;
            }
            case -2147483648: {
                return MIN_VALUE;
            }
        }
        return new Days(days);
    }

    public static Days daysBetween(ReadableInstant start, ReadableInstant end) {
        int amount = BaseSingleFieldPeriod.between(start, end, DurationFieldType.days());
        return Days.days(amount);
    }

    public static Days daysBetween(ReadablePartial start, ReadablePartial end) {
        if (start instanceof LocalDate && end instanceof LocalDate) {
            Chronology chrono = DateTimeUtils.getChronology(start.getChronology());
            int days = chrono.days().getDifference(((LocalDate)end).getLocalMillis(), ((LocalDate)start).getLocalMillis());
            return Days.days(days);
        }
        int amount = BaseSingleFieldPeriod.between(start, end, ZERO);
        return Days.days(amount);
    }

    public static Days daysIn(ReadableInterval interval) {
        if (interval == null) {
            return ZERO;
        }
        int amount = BaseSingleFieldPeriod.between(interval.getStart(), interval.getEnd(), DurationFieldType.days());
        return Days.days(amount);
    }

    public static Days standardDaysIn(ReadablePeriod period) {
        int amount = BaseSingleFieldPeriod.standardPeriodIn(period, 86400000L);
        return Days.days(amount);
    }

    public static Days parseDays(String periodStr) {
        if (periodStr == null) {
            return ZERO;
        }
        Period p = PARSER.parsePeriod(periodStr);
        return Days.days(p.getDays());
    }

    private Days(int days) {
        super(days);
    }

    private Object readResolve() {
        return Days.days(this.getValue());
    }

    @Override
    public DurationFieldType getFieldType() {
        return DurationFieldType.days();
    }

    @Override
    public PeriodType getPeriodType() {
        return PeriodType.days();
    }

    public Weeks toStandardWeeks() {
        return Weeks.weeks(this.getValue() / 7);
    }

    public Hours toStandardHours() {
        return Hours.hours(FieldUtils.safeMultiply(this.getValue(), 24));
    }

    public Minutes toStandardMinutes() {
        return Minutes.minutes(FieldUtils.safeMultiply(this.getValue(), 1440));
    }

    public Seconds toStandardSeconds() {
        return Seconds.seconds(FieldUtils.safeMultiply(this.getValue(), 86400));
    }

    public Duration toStandardDuration() {
        long days = this.getValue();
        return new Duration(days * 86400000L);
    }

    public int getDays() {
        return this.getValue();
    }

    public Days plus(int days) {
        if (days == 0) {
            return this;
        }
        return Days.days(FieldUtils.safeAdd(this.getValue(), days));
    }

    public Days plus(Days days) {
        if (days == null) {
            return this;
        }
        return this.plus(days.getValue());
    }

    public Days minus(int days) {
        return this.plus(FieldUtils.safeNegate(days));
    }

    public Days minus(Days days) {
        if (days == null) {
            return this;
        }
        return this.minus(days.getValue());
    }

    public Days multipliedBy(int scalar) {
        return Days.days(FieldUtils.safeMultiply(this.getValue(), scalar));
    }

    public Days dividedBy(int divisor) {
        if (divisor == 1) {
            return this;
        }
        return Days.days(this.getValue() / divisor);
    }

    public Days negated() {
        return Days.days(FieldUtils.safeNegate(this.getValue()));
    }

    public boolean isGreaterThan(Days other) {
        if (other == null) {
            return this.getValue() > 0;
        }
        return this.getValue() > other.getValue();
    }

    public boolean isLessThan(Days other) {
        if (other == null) {
            return this.getValue() < 0;
        }
        return this.getValue() < other.getValue();
    }

    @Override
    public String toString() {
        return "P" + String.valueOf(this.getValue()) + "D";
    }
}

