/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime;

import com.jn.langx.util.jodatime.Chronology;
import com.jn.langx.util.jodatime.DateTimeUtils;
import com.jn.langx.util.jodatime.Days;
import com.jn.langx.util.jodatime.Duration;
import com.jn.langx.util.jodatime.DurationFieldType;
import com.jn.langx.util.jodatime.LocalTime;
import com.jn.langx.util.jodatime.Minutes;
import com.jn.langx.util.jodatime.Period;
import com.jn.langx.util.jodatime.PeriodType;
import com.jn.langx.util.jodatime.ReadableInstant;
import com.jn.langx.util.jodatime.ReadableInterval;
import com.jn.langx.util.jodatime.ReadablePartial;
import com.jn.langx.util.jodatime.ReadablePeriod;
import com.jn.langx.util.jodatime.Seconds;
import com.jn.langx.util.jodatime.Weeks;
import com.jn.langx.util.jodatime.base.BaseSingleFieldPeriod;
import com.jn.langx.util.jodatime.field.FieldUtils;
import com.jn.langx.util.jodatime.format.ISOPeriodFormat;
import com.jn.langx.util.jodatime.format.PeriodFormatter;

public final class Hours
extends BaseSingleFieldPeriod {
    public static final Hours ZERO = new Hours(0);
    public static final Hours ONE = new Hours(1);
    public static final Hours TWO = new Hours(2);
    public static final Hours THREE = new Hours(3);
    public static final Hours FOUR = new Hours(4);
    public static final Hours FIVE = new Hours(5);
    public static final Hours SIX = new Hours(6);
    public static final Hours SEVEN = new Hours(7);
    public static final Hours EIGHT = new Hours(8);
    public static final Hours MAX_VALUE = new Hours(Integer.MAX_VALUE);
    public static final Hours MIN_VALUE = new Hours(Integer.MIN_VALUE);
    private static final PeriodFormatter PARSER = ISOPeriodFormat.standard().withParseType(PeriodType.hours());
    private static final long serialVersionUID = 87525275727380864L;

    public static Hours hours(int hours) {
        switch (hours) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 4: {
                return FOUR;
            }
            case 5: {
                return FIVE;
            }
            case 6: {
                return SIX;
            }
            case 7: {
                return SEVEN;
            }
            case 8: {
                return EIGHT;
            }
            case 0x7FFFFFFF: {
                return MAX_VALUE;
            }
            case -2147483648: {
                return MIN_VALUE;
            }
        }
        return new Hours(hours);
    }

    public static Hours hoursBetween(ReadableInstant start, ReadableInstant end) {
        int amount = BaseSingleFieldPeriod.between(start, end, DurationFieldType.hours());
        return Hours.hours(amount);
    }

    public static Hours hoursBetween(ReadablePartial start, ReadablePartial end) {
        if (start instanceof LocalTime && end instanceof LocalTime) {
            Chronology chrono = DateTimeUtils.getChronology(start.getChronology());
            int hours = chrono.hours().getDifference(((LocalTime)end).getLocalMillis(), ((LocalTime)start).getLocalMillis());
            return Hours.hours(hours);
        }
        int amount = BaseSingleFieldPeriod.between(start, end, ZERO);
        return Hours.hours(amount);
    }

    public static Hours hoursIn(ReadableInterval interval) {
        if (interval == null) {
            return ZERO;
        }
        int amount = BaseSingleFieldPeriod.between(interval.getStart(), interval.getEnd(), DurationFieldType.hours());
        return Hours.hours(amount);
    }

    public static Hours standardHoursIn(ReadablePeriod period) {
        int amount = BaseSingleFieldPeriod.standardPeriodIn(period, 3600000L);
        return Hours.hours(amount);
    }

    public static Hours parseHours(String periodStr) {
        if (periodStr == null) {
            return ZERO;
        }
        Period p = PARSER.parsePeriod(periodStr);
        return Hours.hours(p.getHours());
    }

    private Hours(int hours) {
        super(hours);
    }

    private Object readResolve() {
        return Hours.hours(this.getValue());
    }

    @Override
    public DurationFieldType getFieldType() {
        return DurationFieldType.hours();
    }

    @Override
    public PeriodType getPeriodType() {
        return PeriodType.hours();
    }

    public Weeks toStandardWeeks() {
        return Weeks.weeks(this.getValue() / 168);
    }

    public Days toStandardDays() {
        return Days.days(this.getValue() / 24);
    }

    public Minutes toStandardMinutes() {
        return Minutes.minutes(FieldUtils.safeMultiply(this.getValue(), 60));
    }

    public Seconds toStandardSeconds() {
        return Seconds.seconds(FieldUtils.safeMultiply(this.getValue(), 3600));
    }

    public Duration toStandardDuration() {
        long hours = this.getValue();
        return new Duration(hours * 3600000L);
    }

    public int getHours() {
        return this.getValue();
    }

    public Hours plus(int hours) {
        if (hours == 0) {
            return this;
        }
        return Hours.hours(FieldUtils.safeAdd(this.getValue(), hours));
    }

    public Hours plus(Hours hours) {
        if (hours == null) {
            return this;
        }
        return this.plus(hours.getValue());
    }

    public Hours minus(int hours) {
        return this.plus(FieldUtils.safeNegate(hours));
    }

    public Hours minus(Hours hours) {
        if (hours == null) {
            return this;
        }
        return this.minus(hours.getValue());
    }

    public Hours multipliedBy(int scalar) {
        return Hours.hours(FieldUtils.safeMultiply(this.getValue(), scalar));
    }

    public Hours dividedBy(int divisor) {
        if (divisor == 1) {
            return this;
        }
        return Hours.hours(this.getValue() / divisor);
    }

    public Hours negated() {
        return Hours.hours(FieldUtils.safeNegate(this.getValue()));
    }

    public boolean isGreaterThan(Hours other) {
        if (other == null) {
            return this.getValue() > 0;
        }
        return this.getValue() > other.getValue();
    }

    public boolean isLessThan(Hours other) {
        if (other == null) {
            return this.getValue() < 0;
        }
        return this.getValue() < other.getValue();
    }

    @Override
    public String toString() {
        return "PT" + String.valueOf(this.getValue()) + "H";
    }
}

