/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime;

import com.jn.langx.util.jodatime.Chronology;
import com.jn.langx.util.jodatime.DateTime;
import com.jn.langx.util.jodatime.DateTimeUtils;
import com.jn.langx.util.jodatime.MutableDateTime;
import com.jn.langx.util.jodatime.ReadableDuration;
import com.jn.langx.util.jodatime.ReadableInstant;
import com.jn.langx.util.jodatime.base.AbstractInstant;
import com.jn.langx.util.jodatime.chrono.ISOChronology;
import com.jn.langx.util.jodatime.convert.ConverterManager;
import com.jn.langx.util.jodatime.convert.InstantConverter;
import com.jn.langx.util.jodatime.format.DateTimeFormatter;
import com.jn.langx.util.jodatime.format.ISODateTimeFormat;
import java.io.Serializable;

public final class Instant
extends AbstractInstant
implements ReadableInstant,
Serializable {
    private static final long serialVersionUID = 3299096530934209741L;
    private final long iMillis;

    public static Instant now() {
        return new Instant();
    }

    public static Instant parse(String str) {
        return Instant.parse(str, ISODateTimeFormat.dateTimeParser());
    }

    public static Instant parse(String str, DateTimeFormatter formatter) {
        return formatter.parseDateTime(str).toInstant();
    }

    public Instant() {
        this.iMillis = DateTimeUtils.currentTimeMillis();
    }

    public Instant(long instant) {
        this.iMillis = instant;
    }

    public Instant(Object instant) {
        InstantConverter converter = ConverterManager.getInstance().getInstantConverter(instant);
        this.iMillis = converter.getInstantMillis(instant, ISOChronology.getInstanceUTC());
    }

    @Override
    public Instant toInstant() {
        return this;
    }

    public Instant withMillis(long newMillis) {
        return newMillis == this.iMillis ? this : new Instant(newMillis);
    }

    public Instant withDurationAdded(long durationToAdd, int scalar) {
        if (durationToAdd == 0L || scalar == 0) {
            return this;
        }
        long instant = this.getChronology().add(this.getMillis(), durationToAdd, scalar);
        return this.withMillis(instant);
    }

    public Instant withDurationAdded(ReadableDuration durationToAdd, int scalar) {
        if (durationToAdd == null || scalar == 0) {
            return this;
        }
        return this.withDurationAdded(durationToAdd.getMillis(), scalar);
    }

    public Instant plus(long duration) {
        return this.withDurationAdded(duration, 1);
    }

    public Instant plus(ReadableDuration duration) {
        return this.withDurationAdded(duration, 1);
    }

    public Instant minus(long duration) {
        return this.withDurationAdded(duration, -1);
    }

    public Instant minus(ReadableDuration duration) {
        return this.withDurationAdded(duration, -1);
    }

    @Override
    public long getMillis() {
        return this.iMillis;
    }

    @Override
    public Chronology getChronology() {
        return ISOChronology.getInstanceUTC();
    }

    @Override
    public DateTime toDateTime() {
        return new DateTime(this.getMillis(), (Chronology)ISOChronology.getInstance());
    }

    @Override
    @Deprecated
    public DateTime toDateTimeISO() {
        return this.toDateTime();
    }

    @Override
    public MutableDateTime toMutableDateTime() {
        return new MutableDateTime(this.getMillis(), (Chronology)ISOChronology.getInstance());
    }

    @Override
    @Deprecated
    public MutableDateTime toMutableDateTimeISO() {
        return this.toMutableDateTime();
    }
}

