/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime;

import com.jn.langx.util.jodatime.Chronology;
import com.jn.langx.util.jodatime.DateMidnight;
import com.jn.langx.util.jodatime.DateTime;
import com.jn.langx.util.jodatime.DateTimeField;
import com.jn.langx.util.jodatime.DateTimeFieldType;
import com.jn.langx.util.jodatime.DateTimeUtils;
import com.jn.langx.util.jodatime.DateTimeZone;
import com.jn.langx.util.jodatime.DurationField;
import com.jn.langx.util.jodatime.DurationFieldType;
import com.jn.langx.util.jodatime.Interval;
import com.jn.langx.util.jodatime.LocalDateTime;
import com.jn.langx.util.jodatime.LocalTime;
import com.jn.langx.util.jodatime.ReadableInstant;
import com.jn.langx.util.jodatime.ReadablePartial;
import com.jn.langx.util.jodatime.ReadablePeriod;
import com.jn.langx.util.jodatime.base.BaseLocal;
import com.jn.langx.util.jodatime.chrono.ISOChronology;
import com.jn.langx.util.jodatime.convert.ConverterManager;
import com.jn.langx.util.jodatime.convert.PartialConverter;
import com.jn.langx.util.jodatime.field.AbstractReadableInstantFieldProperty;
import com.jn.langx.util.jodatime.field.FieldUtils;
import com.jn.langx.util.jodatime.format.DateTimeFormat;
import com.jn.langx.util.jodatime.format.DateTimeFormatter;
import com.jn.langx.util.jodatime.format.ISODateTimeFormat;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;

public final class LocalDate
extends BaseLocal
implements ReadablePartial,
Serializable {
    private static final long serialVersionUID = -8775358157899L;
    private static final int YEAR = 0;
    private static final int MONTH_OF_YEAR = 1;
    private static final int DAY_OF_MONTH = 2;
    private static final Set<DurationFieldType> DATE_DURATION_TYPES = new HashSet<DurationFieldType>();
    private final long iLocalMillis;
    private final Chronology iChronology;
    private volatile transient int iHash;

    public static LocalDate now() {
        return new LocalDate();
    }

    public static LocalDate now(DateTimeZone zone) {
        if (zone == null) {
            throw new NullPointerException("Zone must not be null");
        }
        return new LocalDate(zone);
    }

    public static LocalDate now(Chronology chronology) {
        if (chronology == null) {
            throw new NullPointerException("Chronology must not be null");
        }
        return new LocalDate(chronology);
    }

    public static LocalDate parse(String str) {
        return LocalDate.parse(str, ISODateTimeFormat.localDateParser());
    }

    public static LocalDate parse(String str, DateTimeFormatter formatter) {
        return formatter.parseLocalDate(str);
    }

    public static LocalDate fromCalendarFields(Calendar calendar) {
        if (calendar == null) {
            throw new IllegalArgumentException("The calendar must not be null");
        }
        int era = calendar.get(0);
        int yearOfEra = calendar.get(1);
        return new LocalDate(era == 1 ? yearOfEra : 1 - yearOfEra, calendar.get(2) + 1, calendar.get(5));
    }

    public static LocalDate fromDateFields(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        if (date.getTime() < 0L) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(date);
            return LocalDate.fromCalendarFields(cal);
        }
        return new LocalDate(date.getYear() + 1900, date.getMonth() + 1, date.getDate());
    }

    public LocalDate() {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance());
    }

    public LocalDate(DateTimeZone zone) {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance(zone));
    }

    public LocalDate(Chronology chronology) {
        this(DateTimeUtils.currentTimeMillis(), chronology);
    }

    public LocalDate(long instant) {
        this(instant, (Chronology)ISOChronology.getInstance());
    }

    public LocalDate(long instant, DateTimeZone zone) {
        this(instant, (Chronology)ISOChronology.getInstance(zone));
    }

    public LocalDate(long instant, Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology);
        long localMillis = chronology.getZone().getMillisKeepLocal(DateTimeZone.UTC, instant);
        chronology = chronology.withUTC();
        this.iLocalMillis = chronology.dayOfMonth().roundFloor(localMillis);
        this.iChronology = chronology;
    }

    public LocalDate(Object instant) {
        this(instant, (Chronology)null);
    }

    public LocalDate(Object instant, DateTimeZone zone) {
        PartialConverter converter = ConverterManager.getInstance().getPartialConverter(instant);
        Chronology chronology = converter.getChronology(instant, zone);
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        int[] values = converter.getPartialValues(this, instant, chronology, ISODateTimeFormat.localDateParser());
        this.iLocalMillis = this.iChronology.getDateTimeMillis(values[0], values[1], values[2], 0);
    }

    public LocalDate(Object instant, Chronology chronology) {
        PartialConverter converter = ConverterManager.getInstance().getPartialConverter(instant);
        chronology = converter.getChronology(instant, chronology);
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        int[] values = converter.getPartialValues(this, instant, chronology, ISODateTimeFormat.localDateParser());
        this.iLocalMillis = this.iChronology.getDateTimeMillis(values[0], values[1], values[2], 0);
    }

    public LocalDate(int year, int monthOfYear, int dayOfMonth) {
        this(year, monthOfYear, dayOfMonth, ISOChronology.getInstanceUTC());
    }

    public LocalDate(int year, int monthOfYear, int dayOfMonth, Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology).withUTC();
        long instant = chronology.getDateTimeMillis(year, monthOfYear, dayOfMonth, 0);
        this.iChronology = chronology;
        this.iLocalMillis = instant;
    }

    private Object readResolve() {
        if (this.iChronology == null) {
            return new LocalDate(this.iLocalMillis, (Chronology)ISOChronology.getInstanceUTC());
        }
        if (!DateTimeZone.UTC.equals(this.iChronology.getZone())) {
            return new LocalDate(this.iLocalMillis, this.iChronology.withUTC());
        }
        return this;
    }

    @Override
    public int size() {
        return 3;
    }

    @Override
    protected DateTimeField getField(int index, Chronology chrono) {
        switch (index) {
            case 0: {
                return chrono.year();
            }
            case 1: {
                return chrono.monthOfYear();
            }
            case 2: {
                return chrono.dayOfMonth();
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + index);
    }

    @Override
    public int getValue(int index) {
        switch (index) {
            case 0: {
                return this.getChronology().year().get(this.getLocalMillis());
            }
            case 1: {
                return this.getChronology().monthOfYear().get(this.getLocalMillis());
            }
            case 2: {
                return this.getChronology().dayOfMonth().get(this.getLocalMillis());
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + index);
    }

    @Override
    public int get(DateTimeFieldType fieldType) {
        if (fieldType == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        if (!this.isSupported(fieldType)) {
            throw new IllegalArgumentException("Field '" + fieldType + "' is not supported");
        }
        return fieldType.getField(this.getChronology()).get(this.getLocalMillis());
    }

    @Override
    public boolean isSupported(DateTimeFieldType type) {
        if (type == null) {
            return false;
        }
        DurationFieldType durType = type.getDurationType();
        if (DATE_DURATION_TYPES.contains(durType) || durType.getField(this.getChronology()).getUnitMillis() >= this.getChronology().days().getUnitMillis()) {
            return type.getField(this.getChronology()).isSupported();
        }
        return false;
    }

    public boolean isSupported(DurationFieldType type) {
        if (type == null) {
            return false;
        }
        DurationField field = type.getField(this.getChronology());
        if (DATE_DURATION_TYPES.contains(type) || field.getUnitMillis() >= this.getChronology().days().getUnitMillis()) {
            return field.isSupported();
        }
        return false;
    }

    @Override
    protected long getLocalMillis() {
        return this.iLocalMillis;
    }

    @Override
    public Chronology getChronology() {
        return this.iChronology;
    }

    @Override
    public boolean equals(Object partial) {
        if (this == partial) {
            return true;
        }
        if (partial instanceof LocalDate) {
            LocalDate other = (LocalDate)partial;
            if (this.iChronology.equals(other.iChronology)) {
                return this.iLocalMillis == other.iLocalMillis;
            }
        }
        return super.equals(partial);
    }

    @Override
    public int hashCode() {
        int hash = this.iHash;
        if (hash == 0) {
            hash = this.iHash = super.hashCode();
        }
        return hash;
    }

    @Override
    public int compareTo(ReadablePartial partial) {
        if (this == partial) {
            return 0;
        }
        if (partial instanceof LocalDate) {
            LocalDate other = (LocalDate)partial;
            if (this.iChronology.equals(other.iChronology)) {
                return this.iLocalMillis < other.iLocalMillis ? -1 : (this.iLocalMillis == other.iLocalMillis ? 0 : 1);
            }
        }
        return super.compareTo(partial);
    }

    public DateTime toDateTimeAtStartOfDay() {
        return this.toDateTimeAtStartOfDay(null);
    }

    public DateTime toDateTimeAtStartOfDay(DateTimeZone zone) {
        zone = DateTimeUtils.getZone(zone);
        Chronology chrono = this.getChronology().withZone(zone);
        long localMillis = this.getLocalMillis() + 21600000L;
        long instant = zone.convertLocalToUTC(localMillis, false);
        instant = chrono.dayOfMonth().roundFloor(instant);
        return new DateTime(instant, chrono);
    }

    @Deprecated
    public DateTime toDateTimeAtMidnight() {
        return this.toDateTimeAtMidnight(null);
    }

    @Deprecated
    public DateTime toDateTimeAtMidnight(DateTimeZone zone) {
        zone = DateTimeUtils.getZone(zone);
        Chronology chrono = this.getChronology().withZone(zone);
        return new DateTime(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), 0, 0, 0, 0, chrono);
    }

    public DateTime toDateTimeAtCurrentTime() {
        return this.toDateTimeAtCurrentTime(null);
    }

    public DateTime toDateTimeAtCurrentTime(DateTimeZone zone) {
        zone = DateTimeUtils.getZone(zone);
        Chronology chrono = this.getChronology().withZone(zone);
        long instantMillis = DateTimeUtils.currentTimeMillis();
        long resolved = chrono.set(this, instantMillis);
        return new DateTime(resolved, chrono);
    }

    @Deprecated
    public DateMidnight toDateMidnight() {
        return this.toDateMidnight(null);
    }

    @Deprecated
    public DateMidnight toDateMidnight(DateTimeZone zone) {
        zone = DateTimeUtils.getZone(zone);
        Chronology chrono = this.getChronology().withZone(zone);
        return new DateMidnight(this.getYear(), this.getMonthOfYear(), this.getDayOfMonth(), chrono);
    }

    public LocalDateTime toLocalDateTime(LocalTime time) {
        if (time == null) {
            throw new IllegalArgumentException("The time must not be null");
        }
        if (this.getChronology() != time.getChronology()) {
            throw new IllegalArgumentException("The chronology of the time does not match");
        }
        long localMillis = this.getLocalMillis() + time.getLocalMillis();
        return new LocalDateTime(localMillis, this.getChronology());
    }

    public DateTime toDateTime(LocalTime time) {
        return this.toDateTime(time, null);
    }

    public DateTime toDateTime(LocalTime time, DateTimeZone zone) {
        if (time != null && this.getChronology() != time.getChronology()) {
            throw new IllegalArgumentException("The chronology of the time does not match");
        }
        Chronology chrono = this.getChronology().withZone(zone);
        long instant = DateTimeUtils.currentTimeMillis();
        instant = chrono.set(this, instant);
        if (time != null) {
            instant = chrono.set(time, instant);
        }
        return new DateTime(instant, chrono);
    }

    public Interval toInterval() {
        return this.toInterval(null);
    }

    public Interval toInterval(DateTimeZone zone) {
        zone = DateTimeUtils.getZone(zone);
        DateTime start = this.toDateTimeAtStartOfDay(zone);
        DateTime end = this.plusDays(1).toDateTimeAtStartOfDay(zone);
        return new Interval((ReadableInstant)start, (ReadableInstant)end);
    }

    public Date toDate() {
        Date earlier;
        int dom = this.getDayOfMonth();
        Date date = new Date(this.getYear() - 1900, this.getMonthOfYear() - 1, dom);
        LocalDate check = LocalDate.fromDateFields(date);
        if (check.isBefore(this)) {
            while (!check.equals(this)) {
                date.setTime(date.getTime() + 3600000L);
                check = LocalDate.fromDateFields(date);
            }
            while (date.getDate() == dom) {
                date.setTime(date.getTime() - 1000L);
            }
            date.setTime(date.getTime() + 1000L);
        } else if (check.equals(this) && (earlier = new Date(date.getTime() - (long)TimeZone.getDefault().getDSTSavings())).getDate() == dom) {
            date = earlier;
        }
        return date;
    }

    LocalDate withLocalMillis(long newMillis) {
        newMillis = this.iChronology.dayOfMonth().roundFloor(newMillis);
        return newMillis == this.getLocalMillis() ? this : new LocalDate(newMillis, this.getChronology());
    }

    public LocalDate withFields(ReadablePartial partial) {
        if (partial == null) {
            return this;
        }
        return this.withLocalMillis(this.getChronology().set(partial, this.getLocalMillis()));
    }

    public LocalDate withField(DateTimeFieldType fieldType, int value) {
        if (fieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (!this.isSupported(fieldType)) {
            throw new IllegalArgumentException("Field '" + fieldType + "' is not supported");
        }
        long instant = fieldType.getField(this.getChronology()).set(this.getLocalMillis(), value);
        return this.withLocalMillis(instant);
    }

    public LocalDate withFieldAdded(DurationFieldType fieldType, int amount) {
        if (fieldType == null) {
            throw new IllegalArgumentException("Field must not be null");
        }
        if (!this.isSupported(fieldType)) {
            throw new IllegalArgumentException("Field '" + fieldType + "' is not supported");
        }
        if (amount == 0) {
            return this;
        }
        long instant = fieldType.getField(this.getChronology()).add(this.getLocalMillis(), amount);
        return this.withLocalMillis(instant);
    }

    public LocalDate withPeriodAdded(ReadablePeriod period, int scalar) {
        if (period == null || scalar == 0) {
            return this;
        }
        long instant = this.getLocalMillis();
        Chronology chrono = this.getChronology();
        for (int i = 0; i < period.size(); ++i) {
            long value = FieldUtils.safeMultiply(period.getValue(i), scalar);
            DurationFieldType type = period.getFieldType(i);
            if (!this.isSupported(type)) continue;
            instant = type.getField(chrono).add(instant, value);
        }
        return this.withLocalMillis(instant);
    }

    public LocalDate plus(ReadablePeriod period) {
        return this.withPeriodAdded(period, 1);
    }

    public LocalDate plusYears(int years) {
        if (years == 0) {
            return this;
        }
        long instant = this.getChronology().years().add(this.getLocalMillis(), years);
        return this.withLocalMillis(instant);
    }

    public LocalDate plusMonths(int months) {
        if (months == 0) {
            return this;
        }
        long instant = this.getChronology().months().add(this.getLocalMillis(), months);
        return this.withLocalMillis(instant);
    }

    public LocalDate plusWeeks(int weeks) {
        if (weeks == 0) {
            return this;
        }
        long instant = this.getChronology().weeks().add(this.getLocalMillis(), weeks);
        return this.withLocalMillis(instant);
    }

    public LocalDate plusDays(int days) {
        if (days == 0) {
            return this;
        }
        long instant = this.getChronology().days().add(this.getLocalMillis(), days);
        return this.withLocalMillis(instant);
    }

    public LocalDate minus(ReadablePeriod period) {
        return this.withPeriodAdded(period, -1);
    }

    public LocalDate minusYears(int years) {
        if (years == 0) {
            return this;
        }
        long instant = this.getChronology().years().subtract(this.getLocalMillis(), years);
        return this.withLocalMillis(instant);
    }

    public LocalDate minusMonths(int months) {
        if (months == 0) {
            return this;
        }
        long instant = this.getChronology().months().subtract(this.getLocalMillis(), months);
        return this.withLocalMillis(instant);
    }

    public LocalDate minusWeeks(int weeks) {
        if (weeks == 0) {
            return this;
        }
        long instant = this.getChronology().weeks().subtract(this.getLocalMillis(), weeks);
        return this.withLocalMillis(instant);
    }

    public LocalDate minusDays(int days) {
        if (days == 0) {
            return this;
        }
        long instant = this.getChronology().days().subtract(this.getLocalMillis(), days);
        return this.withLocalMillis(instant);
    }

    public Property property(DateTimeFieldType fieldType) {
        if (fieldType == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        if (!this.isSupported(fieldType)) {
            throw new IllegalArgumentException("Field '" + fieldType + "' is not supported");
        }
        return new Property(this, fieldType.getField(this.getChronology()));
    }

    public int getEra() {
        return this.getChronology().era().get(this.getLocalMillis());
    }

    public int getCenturyOfEra() {
        return this.getChronology().centuryOfEra().get(this.getLocalMillis());
    }

    public int getYearOfEra() {
        return this.getChronology().yearOfEra().get(this.getLocalMillis());
    }

    public int getYearOfCentury() {
        return this.getChronology().yearOfCentury().get(this.getLocalMillis());
    }

    public int getYear() {
        return this.getChronology().year().get(this.getLocalMillis());
    }

    public int getWeekyear() {
        return this.getChronology().weekyear().get(this.getLocalMillis());
    }

    public int getMonthOfYear() {
        return this.getChronology().monthOfYear().get(this.getLocalMillis());
    }

    public int getWeekOfWeekyear() {
        return this.getChronology().weekOfWeekyear().get(this.getLocalMillis());
    }

    public int getDayOfYear() {
        return this.getChronology().dayOfYear().get(this.getLocalMillis());
    }

    public int getDayOfMonth() {
        return this.getChronology().dayOfMonth().get(this.getLocalMillis());
    }

    public int getDayOfWeek() {
        return this.getChronology().dayOfWeek().get(this.getLocalMillis());
    }

    public LocalDate withEra(int era) {
        return this.withLocalMillis(this.getChronology().era().set(this.getLocalMillis(), era));
    }

    public LocalDate withCenturyOfEra(int centuryOfEra) {
        return this.withLocalMillis(this.getChronology().centuryOfEra().set(this.getLocalMillis(), centuryOfEra));
    }

    public LocalDate withYearOfEra(int yearOfEra) {
        return this.withLocalMillis(this.getChronology().yearOfEra().set(this.getLocalMillis(), yearOfEra));
    }

    public LocalDate withYearOfCentury(int yearOfCentury) {
        return this.withLocalMillis(this.getChronology().yearOfCentury().set(this.getLocalMillis(), yearOfCentury));
    }

    public LocalDate withYear(int year) {
        return this.withLocalMillis(this.getChronology().year().set(this.getLocalMillis(), year));
    }

    public LocalDate withWeekyear(int weekyear) {
        return this.withLocalMillis(this.getChronology().weekyear().set(this.getLocalMillis(), weekyear));
    }

    public LocalDate withMonthOfYear(int monthOfYear) {
        return this.withLocalMillis(this.getChronology().monthOfYear().set(this.getLocalMillis(), monthOfYear));
    }

    public LocalDate withWeekOfWeekyear(int weekOfWeekyear) {
        return this.withLocalMillis(this.getChronology().weekOfWeekyear().set(this.getLocalMillis(), weekOfWeekyear));
    }

    public LocalDate withDayOfYear(int dayOfYear) {
        return this.withLocalMillis(this.getChronology().dayOfYear().set(this.getLocalMillis(), dayOfYear));
    }

    public LocalDate withDayOfMonth(int dayOfMonth) {
        return this.withLocalMillis(this.getChronology().dayOfMonth().set(this.getLocalMillis(), dayOfMonth));
    }

    public LocalDate withDayOfWeek(int dayOfWeek) {
        return this.withLocalMillis(this.getChronology().dayOfWeek().set(this.getLocalMillis(), dayOfWeek));
    }

    public Property era() {
        return new Property(this, this.getChronology().era());
    }

    public Property centuryOfEra() {
        return new Property(this, this.getChronology().centuryOfEra());
    }

    public Property yearOfCentury() {
        return new Property(this, this.getChronology().yearOfCentury());
    }

    public Property yearOfEra() {
        return new Property(this, this.getChronology().yearOfEra());
    }

    public Property year() {
        return new Property(this, this.getChronology().year());
    }

    public Property weekyear() {
        return new Property(this, this.getChronology().weekyear());
    }

    public Property monthOfYear() {
        return new Property(this, this.getChronology().monthOfYear());
    }

    public Property weekOfWeekyear() {
        return new Property(this, this.getChronology().weekOfWeekyear());
    }

    public Property dayOfYear() {
        return new Property(this, this.getChronology().dayOfYear());
    }

    public Property dayOfMonth() {
        return new Property(this, this.getChronology().dayOfMonth());
    }

    public Property dayOfWeek() {
        return new Property(this, this.getChronology().dayOfWeek());
    }

    @Override
    public String toString() {
        return ISODateTimeFormat.date().print(this);
    }

    public String toString(String pattern) {
        if (pattern == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(pattern).print(this);
    }

    public String toString(String pattern, Locale locale) throws IllegalArgumentException {
        if (pattern == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(pattern).withLocale(locale).print(this);
    }

    static {
        DATE_DURATION_TYPES.add(DurationFieldType.days());
        DATE_DURATION_TYPES.add(DurationFieldType.weeks());
        DATE_DURATION_TYPES.add(DurationFieldType.months());
        DATE_DURATION_TYPES.add(DurationFieldType.weekyears());
        DATE_DURATION_TYPES.add(DurationFieldType.years());
        DATE_DURATION_TYPES.add(DurationFieldType.centuries());
        DATE_DURATION_TYPES.add(DurationFieldType.eras());
    }

    public static final class Property
    extends AbstractReadableInstantFieldProperty {
        private static final long serialVersionUID = -3193829732634L;
        private transient LocalDate iInstant;
        private transient DateTimeField iField;

        Property(LocalDate instant, DateTimeField field) {
            this.iInstant = instant;
            this.iField = field;
        }

        private void writeObject(ObjectOutputStream oos) throws IOException {
            oos.writeObject(this.iInstant);
            oos.writeObject(this.iField.getType());
        }

        private void readObject(ObjectInputStream oos) throws IOException, ClassNotFoundException {
            this.iInstant = (LocalDate)oos.readObject();
            DateTimeFieldType type = (DateTimeFieldType)oos.readObject();
            this.iField = type.getField(this.iInstant.getChronology());
        }

        @Override
        public DateTimeField getField() {
            return this.iField;
        }

        @Override
        protected long getMillis() {
            return this.iInstant.getLocalMillis();
        }

        @Override
        protected Chronology getChronology() {
            return this.iInstant.getChronology();
        }

        public LocalDate getLocalDate() {
            return this.iInstant;
        }

        public LocalDate addToCopy(int value) {
            return this.iInstant.withLocalMillis(this.iField.add(this.iInstant.getLocalMillis(), value));
        }

        public LocalDate addWrapFieldToCopy(int value) {
            return this.iInstant.withLocalMillis(this.iField.addWrapField(this.iInstant.getLocalMillis(), value));
        }

        public LocalDate setCopy(int value) {
            return this.iInstant.withLocalMillis(this.iField.set(this.iInstant.getLocalMillis(), value));
        }

        public LocalDate setCopy(String text, Locale locale) {
            return this.iInstant.withLocalMillis(this.iField.set(this.iInstant.getLocalMillis(), text, locale));
        }

        public LocalDate setCopy(String text) {
            return this.setCopy(text, null);
        }

        public LocalDate withMaximumValue() {
            return this.setCopy(this.getMaximumValue());
        }

        public LocalDate withMinimumValue() {
            return this.setCopy(this.getMinimumValue());
        }

        public LocalDate roundFloorCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundFloor(this.iInstant.getLocalMillis()));
        }

        public LocalDate roundCeilingCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundCeiling(this.iInstant.getLocalMillis()));
        }

        public LocalDate roundHalfFloorCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfFloor(this.iInstant.getLocalMillis()));
        }

        public LocalDate roundHalfCeilingCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfCeiling(this.iInstant.getLocalMillis()));
        }

        public LocalDate roundHalfEvenCopy() {
            return this.iInstant.withLocalMillis(this.iField.roundHalfEven(this.iInstant.getLocalMillis()));
        }
    }
}

