/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime;

import com.jn.langx.util.jodatime.Chronology;
import com.jn.langx.util.jodatime.DateTimeUtils;
import com.jn.langx.util.jodatime.Days;
import com.jn.langx.util.jodatime.Duration;
import com.jn.langx.util.jodatime.DurationFieldType;
import com.jn.langx.util.jodatime.Hours;
import com.jn.langx.util.jodatime.LocalTime;
import com.jn.langx.util.jodatime.Period;
import com.jn.langx.util.jodatime.PeriodType;
import com.jn.langx.util.jodatime.ReadableInstant;
import com.jn.langx.util.jodatime.ReadableInterval;
import com.jn.langx.util.jodatime.ReadablePartial;
import com.jn.langx.util.jodatime.ReadablePeriod;
import com.jn.langx.util.jodatime.Seconds;
import com.jn.langx.util.jodatime.Weeks;
import com.jn.langx.util.jodatime.base.BaseSingleFieldPeriod;
import com.jn.langx.util.jodatime.field.FieldUtils;
import com.jn.langx.util.jodatime.format.ISOPeriodFormat;
import com.jn.langx.util.jodatime.format.PeriodFormatter;

public final class Minutes
extends BaseSingleFieldPeriod {
    public static final Minutes ZERO = new Minutes(0);
    public static final Minutes ONE = new Minutes(1);
    public static final Minutes TWO = new Minutes(2);
    public static final Minutes THREE = new Minutes(3);
    public static final Minutes MAX_VALUE = new Minutes(Integer.MAX_VALUE);
    public static final Minutes MIN_VALUE = new Minutes(Integer.MIN_VALUE);
    private static final PeriodFormatter PARSER = ISOPeriodFormat.standard().withParseType(PeriodType.minutes());
    private static final long serialVersionUID = 87525275727380863L;

    public static Minutes minutes(int minutes) {
        switch (minutes) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 0x7FFFFFFF: {
                return MAX_VALUE;
            }
            case -2147483648: {
                return MIN_VALUE;
            }
        }
        return new Minutes(minutes);
    }

    public static Minutes minutesBetween(ReadableInstant start, ReadableInstant end) {
        int amount = BaseSingleFieldPeriod.between(start, end, DurationFieldType.minutes());
        return Minutes.minutes(amount);
    }

    public static Minutes minutesBetween(ReadablePartial start, ReadablePartial end) {
        if (start instanceof LocalTime && end instanceof LocalTime) {
            Chronology chrono = DateTimeUtils.getChronology(start.getChronology());
            int minutes = chrono.minutes().getDifference(((LocalTime)end).getLocalMillis(), ((LocalTime)start).getLocalMillis());
            return Minutes.minutes(minutes);
        }
        int amount = BaseSingleFieldPeriod.between(start, end, ZERO);
        return Minutes.minutes(amount);
    }

    public static Minutes minutesIn(ReadableInterval interval) {
        if (interval == null) {
            return ZERO;
        }
        int amount = BaseSingleFieldPeriod.between(interval.getStart(), interval.getEnd(), DurationFieldType.minutes());
        return Minutes.minutes(amount);
    }

    public static Minutes standardMinutesIn(ReadablePeriod period) {
        int amount = BaseSingleFieldPeriod.standardPeriodIn(period, 60000L);
        return Minutes.minutes(amount);
    }

    public static Minutes parseMinutes(String periodStr) {
        if (periodStr == null) {
            return ZERO;
        }
        Period p = PARSER.parsePeriod(periodStr);
        return Minutes.minutes(p.getMinutes());
    }

    private Minutes(int minutes) {
        super(minutes);
    }

    private Object readResolve() {
        return Minutes.minutes(this.getValue());
    }

    @Override
    public DurationFieldType getFieldType() {
        return DurationFieldType.minutes();
    }

    @Override
    public PeriodType getPeriodType() {
        return PeriodType.minutes();
    }

    public Weeks toStandardWeeks() {
        return Weeks.weeks(this.getValue() / 10080);
    }

    public Days toStandardDays() {
        return Days.days(this.getValue() / 1440);
    }

    public Hours toStandardHours() {
        return Hours.hours(this.getValue() / 60);
    }

    public Seconds toStandardSeconds() {
        return Seconds.seconds(FieldUtils.safeMultiply(this.getValue(), 60));
    }

    public Duration toStandardDuration() {
        long minutes = this.getValue();
        return new Duration(minutes * 60000L);
    }

    public int getMinutes() {
        return this.getValue();
    }

    public Minutes plus(int minutes) {
        if (minutes == 0) {
            return this;
        }
        return Minutes.minutes(FieldUtils.safeAdd(this.getValue(), minutes));
    }

    public Minutes plus(Minutes minutes) {
        if (minutes == null) {
            return this;
        }
        return this.plus(minutes.getValue());
    }

    public Minutes minus(int minutes) {
        return this.plus(FieldUtils.safeNegate(minutes));
    }

    public Minutes minus(Minutes minutes) {
        if (minutes == null) {
            return this;
        }
        return this.minus(minutes.getValue());
    }

    public Minutes multipliedBy(int scalar) {
        return Minutes.minutes(FieldUtils.safeMultiply(this.getValue(), scalar));
    }

    public Minutes dividedBy(int divisor) {
        if (divisor == 1) {
            return this;
        }
        return Minutes.minutes(this.getValue() / divisor);
    }

    public Minutes negated() {
        return Minutes.minutes(FieldUtils.safeNegate(this.getValue()));
    }

    public boolean isGreaterThan(Minutes other) {
        if (other == null) {
            return this.getValue() > 0;
        }
        return this.getValue() > other.getValue();
    }

    public boolean isLessThan(Minutes other) {
        if (other == null) {
            return this.getValue() < 0;
        }
        return this.getValue() < other.getValue();
    }

    @Override
    public String toString() {
        return "PT" + String.valueOf(this.getValue()) + "M";
    }
}

