/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime;

import com.jn.langx.util.jodatime.Chronology;
import com.jn.langx.util.jodatime.DateTimeUtils;
import com.jn.langx.util.jodatime.ReadWritableInterval;
import com.jn.langx.util.jodatime.ReadableDuration;
import com.jn.langx.util.jodatime.ReadableInstant;
import com.jn.langx.util.jodatime.ReadableInterval;
import com.jn.langx.util.jodatime.ReadablePeriod;
import com.jn.langx.util.jodatime.base.BaseInterval;
import com.jn.langx.util.jodatime.field.FieldUtils;
import java.io.Serializable;

public class MutableInterval
extends BaseInterval
implements ReadWritableInterval,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5982824024992428470L;

    public static MutableInterval parse(String str) {
        return new MutableInterval(str);
    }

    public MutableInterval() {
        super(0L, 0L, null);
    }

    public MutableInterval(long startInstant, long endInstant) {
        super(startInstant, endInstant, null);
    }

    public MutableInterval(long startInstant, long endInstant, Chronology chronology) {
        super(startInstant, endInstant, chronology);
    }

    public MutableInterval(ReadableInstant start, ReadableInstant end) {
        super(start, end);
    }

    public MutableInterval(ReadableInstant start, ReadableDuration duration) {
        super(start, duration);
    }

    public MutableInterval(ReadableDuration duration, ReadableInstant end) {
        super(duration, end);
    }

    public MutableInterval(ReadableInstant start, ReadablePeriod period) {
        super(start, period);
    }

    public MutableInterval(ReadablePeriod period, ReadableInstant end) {
        super(period, end);
    }

    public MutableInterval(Object interval) {
        super(interval, null);
    }

    public MutableInterval(Object interval, Chronology chronology) {
        super(interval, chronology);
    }

    @Override
    public void setInterval(long startInstant, long endInstant) {
        super.setInterval(startInstant, endInstant, this.getChronology());
    }

    @Override
    public void setInterval(ReadableInterval interval) {
        if (interval == null) {
            throw new IllegalArgumentException("Interval must not be null");
        }
        long startMillis = interval.getStartMillis();
        long endMillis = interval.getEndMillis();
        Chronology chrono = interval.getChronology();
        super.setInterval(startMillis, endMillis, chrono);
    }

    @Override
    public void setInterval(ReadableInstant start, ReadableInstant end) {
        if (start == null && end == null) {
            long now = DateTimeUtils.currentTimeMillis();
            this.setInterval(now, now);
        } else {
            long startMillis = DateTimeUtils.getInstantMillis(start);
            long endMillis = DateTimeUtils.getInstantMillis(end);
            Chronology chrono = DateTimeUtils.getInstantChronology(start);
            super.setInterval(startMillis, endMillis, chrono);
        }
    }

    @Override
    public void setChronology(Chronology chrono) {
        super.setInterval(this.getStartMillis(), this.getEndMillis(), chrono);
    }

    @Override
    public void setStartMillis(long startInstant) {
        super.setInterval(startInstant, this.getEndMillis(), this.getChronology());
    }

    @Override
    public void setStart(ReadableInstant start) {
        long startMillis = DateTimeUtils.getInstantMillis(start);
        super.setInterval(startMillis, this.getEndMillis(), this.getChronology());
    }

    @Override
    public void setEndMillis(long endInstant) {
        super.setInterval(this.getStartMillis(), endInstant, this.getChronology());
    }

    @Override
    public void setEnd(ReadableInstant end) {
        long endMillis = DateTimeUtils.getInstantMillis(end);
        super.setInterval(this.getStartMillis(), endMillis, this.getChronology());
    }

    public void setDurationAfterStart(long duration) {
        this.setEndMillis(FieldUtils.safeAdd(this.getStartMillis(), duration));
    }

    public void setDurationBeforeEnd(long duration) {
        this.setStartMillis(FieldUtils.safeAdd(this.getEndMillis(), -duration));
    }

    @Override
    public void setDurationAfterStart(ReadableDuration duration) {
        long durationMillis = DateTimeUtils.getDurationMillis(duration);
        this.setEndMillis(FieldUtils.safeAdd(this.getStartMillis(), durationMillis));
    }

    @Override
    public void setDurationBeforeEnd(ReadableDuration duration) {
        long durationMillis = DateTimeUtils.getDurationMillis(duration);
        this.setStartMillis(FieldUtils.safeAdd(this.getEndMillis(), -durationMillis));
    }

    @Override
    public void setPeriodAfterStart(ReadablePeriod period) {
        if (period == null) {
            this.setEndMillis(this.getStartMillis());
        } else {
            this.setEndMillis(this.getChronology().add(period, this.getStartMillis(), 1));
        }
    }

    @Override
    public void setPeriodBeforeEnd(ReadablePeriod period) {
        if (period == null) {
            this.setStartMillis(this.getEndMillis());
        } else {
            this.setStartMillis(this.getChronology().add(period, this.getEndMillis(), -1));
        }
    }

    public MutableInterval copy() {
        return (MutableInterval)this.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError("Clone error");
        }
    }
}

