/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime;

import com.jn.langx.util.jodatime.Chronology;
import com.jn.langx.util.jodatime.DateTimeUtils;
import com.jn.langx.util.jodatime.DurationFieldType;
import com.jn.langx.util.jodatime.Period;
import com.jn.langx.util.jodatime.PeriodType;
import com.jn.langx.util.jodatime.ReadWritablePeriod;
import com.jn.langx.util.jodatime.ReadableDuration;
import com.jn.langx.util.jodatime.ReadableInstant;
import com.jn.langx.util.jodatime.ReadableInterval;
import com.jn.langx.util.jodatime.ReadablePeriod;
import com.jn.langx.util.jodatime.base.BasePeriod;
import com.jn.langx.util.jodatime.field.FieldUtils;
import com.jn.langx.util.jodatime.format.ISOPeriodFormat;
import com.jn.langx.util.jodatime.format.PeriodFormatter;
import java.io.Serializable;

public class MutablePeriod
extends BasePeriod
implements ReadWritablePeriod,
Cloneable,
Serializable {
    private static final long serialVersionUID = 3436451121567212165L;

    public static MutablePeriod parse(String str) {
        return MutablePeriod.parse(str, ISOPeriodFormat.standard());
    }

    public static MutablePeriod parse(String str, PeriodFormatter formatter) {
        return formatter.parsePeriod(str).toMutablePeriod();
    }

    public MutablePeriod() {
        super(0L, (PeriodType)null, (Chronology)null);
    }

    public MutablePeriod(PeriodType type) {
        super(0L, type, (Chronology)null);
    }

    public MutablePeriod(int hours, int minutes, int seconds, int millis) {
        super(0, 0, 0, 0, hours, minutes, seconds, millis, PeriodType.standard());
    }

    public MutablePeriod(int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis) {
        super(years, months, weeks, days, hours, minutes, seconds, millis, PeriodType.standard());
    }

    public MutablePeriod(int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis, PeriodType type) {
        super(years, months, weeks, days, hours, minutes, seconds, millis, type);
    }

    public MutablePeriod(long duration) {
        super(duration);
    }

    public MutablePeriod(long duration, PeriodType type) {
        super(duration, type, (Chronology)null);
    }

    public MutablePeriod(long duration, Chronology chronology) {
        super(duration, (PeriodType)null, chronology);
    }

    public MutablePeriod(long duration, PeriodType type, Chronology chronology) {
        super(duration, type, chronology);
    }

    public MutablePeriod(long startInstant, long endInstant) {
        super(startInstant, endInstant, null, null);
    }

    public MutablePeriod(long startInstant, long endInstant, PeriodType type) {
        super(startInstant, endInstant, type, null);
    }

    public MutablePeriod(long startInstant, long endInstant, Chronology chrono) {
        super(startInstant, endInstant, null, chrono);
    }

    public MutablePeriod(long startInstant, long endInstant, PeriodType type, Chronology chrono) {
        super(startInstant, endInstant, type, chrono);
    }

    public MutablePeriod(ReadableInstant startInstant, ReadableInstant endInstant) {
        super(startInstant, endInstant, null);
    }

    public MutablePeriod(ReadableInstant startInstant, ReadableInstant endInstant, PeriodType type) {
        super(startInstant, endInstant, type);
    }

    public MutablePeriod(ReadableInstant startInstant, ReadableDuration duration) {
        super(startInstant, duration, null);
    }

    public MutablePeriod(ReadableInstant startInstant, ReadableDuration duration, PeriodType type) {
        super(startInstant, duration, type);
    }

    public MutablePeriod(ReadableDuration duration, ReadableInstant endInstant) {
        super(duration, endInstant, null);
    }

    public MutablePeriod(ReadableDuration duration, ReadableInstant endInstant, PeriodType type) {
        super(duration, endInstant, type);
    }

    public MutablePeriod(Object period) {
        super(period, null, null);
    }

    public MutablePeriod(Object period, PeriodType type) {
        super(period, type, null);
    }

    public MutablePeriod(Object period, Chronology chrono) {
        super(period, null, chrono);
    }

    public MutablePeriod(Object period, PeriodType type, Chronology chrono) {
        super(period, type, chrono);
    }

    @Override
    public void clear() {
        super.setValues(new int[this.size()]);
    }

    @Override
    public void setValue(int index, int value) {
        super.setValue(index, value);
    }

    @Override
    public void set(DurationFieldType field, int value) {
        super.setField(field, value);
    }

    @Override
    public void setPeriod(ReadablePeriod period) {
        super.setPeriod(period);
    }

    @Override
    public void setPeriod(int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis) {
        super.setPeriod(years, months, weeks, days, hours, minutes, seconds, millis);
    }

    @Override
    public void setPeriod(ReadableInterval interval) {
        if (interval == null) {
            this.setPeriod(0L);
        } else {
            Chronology chrono = DateTimeUtils.getChronology(interval.getChronology());
            this.setPeriod(interval.getStartMillis(), interval.getEndMillis(), chrono);
        }
    }

    public void setPeriod(ReadableInstant start, ReadableInstant end) {
        if (start == end) {
            this.setPeriod(0L);
        } else {
            long startMillis = DateTimeUtils.getInstantMillis(start);
            long endMillis = DateTimeUtils.getInstantMillis(end);
            Chronology chrono = DateTimeUtils.getIntervalChronology(start, end);
            this.setPeriod(startMillis, endMillis, chrono);
        }
    }

    public void setPeriod(long startInstant, long endInstant) {
        this.setPeriod(startInstant, endInstant, null);
    }

    public void setPeriod(long startInstant, long endInstant, Chronology chrono) {
        chrono = DateTimeUtils.getChronology(chrono);
        this.setValues(chrono.get(this, startInstant, endInstant));
    }

    public void setPeriod(ReadableDuration duration) {
        this.setPeriod(duration, null);
    }

    public void setPeriod(ReadableDuration duration, Chronology chrono) {
        long durationMillis = DateTimeUtils.getDurationMillis(duration);
        this.setPeriod(durationMillis, chrono);
    }

    public void setPeriod(long duration) {
        this.setPeriod(duration, null);
    }

    public void setPeriod(long duration, Chronology chrono) {
        chrono = DateTimeUtils.getChronology(chrono);
        this.setValues(chrono.get(this, duration));
    }

    @Override
    public void add(DurationFieldType field, int value) {
        super.addField(field, value);
    }

    @Override
    public void add(ReadablePeriod period) {
        super.addPeriod(period);
    }

    @Override
    public void add(int years, int months, int weeks, int days, int hours, int minutes, int seconds, int millis) {
        this.setPeriod(FieldUtils.safeAdd(this.getYears(), years), FieldUtils.safeAdd(this.getMonths(), months), FieldUtils.safeAdd(this.getWeeks(), weeks), FieldUtils.safeAdd(this.getDays(), days), FieldUtils.safeAdd(this.getHours(), hours), FieldUtils.safeAdd(this.getMinutes(), minutes), FieldUtils.safeAdd(this.getSeconds(), seconds), FieldUtils.safeAdd(this.getMillis(), millis));
    }

    @Override
    public void add(ReadableInterval interval) {
        if (interval != null) {
            this.add(interval.toPeriod(this.getPeriodType()));
        }
    }

    public void add(ReadableDuration duration) {
        if (duration != null) {
            this.add(new Period(duration.getMillis(), this.getPeriodType()));
        }
    }

    public void add(long duration) {
        this.add(new Period(duration, this.getPeriodType()));
    }

    public void add(long duration, Chronology chrono) {
        this.add(new Period(duration, this.getPeriodType(), chrono));
    }

    @Override
    public void mergePeriod(ReadablePeriod period) {
        super.mergePeriod(period);
    }

    public int getYears() {
        return this.getPeriodType().getIndexedField(this, PeriodType.YEAR_INDEX);
    }

    public int getMonths() {
        return this.getPeriodType().getIndexedField(this, PeriodType.MONTH_INDEX);
    }

    public int getWeeks() {
        return this.getPeriodType().getIndexedField(this, PeriodType.WEEK_INDEX);
    }

    public int getDays() {
        return this.getPeriodType().getIndexedField(this, PeriodType.DAY_INDEX);
    }

    public int getHours() {
        return this.getPeriodType().getIndexedField(this, PeriodType.HOUR_INDEX);
    }

    public int getMinutes() {
        return this.getPeriodType().getIndexedField(this, PeriodType.MINUTE_INDEX);
    }

    public int getSeconds() {
        return this.getPeriodType().getIndexedField(this, PeriodType.SECOND_INDEX);
    }

    public int getMillis() {
        return this.getPeriodType().getIndexedField(this, PeriodType.MILLI_INDEX);
    }

    @Override
    public void setYears(int years) {
        super.setField(DurationFieldType.years(), years);
    }

    @Override
    public void addYears(int years) {
        super.addField(DurationFieldType.years(), years);
    }

    @Override
    public void setMonths(int months) {
        super.setField(DurationFieldType.months(), months);
    }

    @Override
    public void addMonths(int months) {
        super.addField(DurationFieldType.months(), months);
    }

    @Override
    public void setWeeks(int weeks) {
        super.setField(DurationFieldType.weeks(), weeks);
    }

    @Override
    public void addWeeks(int weeks) {
        super.addField(DurationFieldType.weeks(), weeks);
    }

    @Override
    public void setDays(int days) {
        super.setField(DurationFieldType.days(), days);
    }

    @Override
    public void addDays(int days) {
        super.addField(DurationFieldType.days(), days);
    }

    @Override
    public void setHours(int hours) {
        super.setField(DurationFieldType.hours(), hours);
    }

    @Override
    public void addHours(int hours) {
        super.addField(DurationFieldType.hours(), hours);
    }

    @Override
    public void setMinutes(int minutes) {
        super.setField(DurationFieldType.minutes(), minutes);
    }

    @Override
    public void addMinutes(int minutes) {
        super.addField(DurationFieldType.minutes(), minutes);
    }

    @Override
    public void setSeconds(int seconds) {
        super.setField(DurationFieldType.seconds(), seconds);
    }

    @Override
    public void addSeconds(int seconds) {
        super.addField(DurationFieldType.seconds(), seconds);
    }

    @Override
    public void setMillis(int millis) {
        super.setField(DurationFieldType.millis(), millis);
    }

    @Override
    public void addMillis(int millis) {
        super.addField(DurationFieldType.millis(), millis);
    }

    public MutablePeriod copy() {
        return (MutablePeriod)this.clone();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError("Clone error");
        }
    }
}

