/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime;

import com.jn.langx.util.jodatime.Chronology;
import com.jn.langx.util.jodatime.DateTimeUtils;
import com.jn.langx.util.jodatime.DurationFieldType;
import com.jn.langx.util.jodatime.LocalDate;
import com.jn.langx.util.jodatime.Period;
import com.jn.langx.util.jodatime.PeriodType;
import com.jn.langx.util.jodatime.ReadableInstant;
import com.jn.langx.util.jodatime.ReadableInterval;
import com.jn.langx.util.jodatime.ReadablePartial;
import com.jn.langx.util.jodatime.base.BaseSingleFieldPeriod;
import com.jn.langx.util.jodatime.field.FieldUtils;
import com.jn.langx.util.jodatime.format.ISOPeriodFormat;
import com.jn.langx.util.jodatime.format.PeriodFormatter;

public final class Years
extends BaseSingleFieldPeriod {
    public static final Years ZERO = new Years(0);
    public static final Years ONE = new Years(1);
    public static final Years TWO = new Years(2);
    public static final Years THREE = new Years(3);
    public static final Years MAX_VALUE = new Years(Integer.MAX_VALUE);
    public static final Years MIN_VALUE = new Years(Integer.MIN_VALUE);
    private static final PeriodFormatter PARSER = ISOPeriodFormat.standard().withParseType(PeriodType.years());
    private static final long serialVersionUID = 87525275727380868L;

    public static Years years(int years) {
        switch (years) {
            case 0: {
                return ZERO;
            }
            case 1: {
                return ONE;
            }
            case 2: {
                return TWO;
            }
            case 3: {
                return THREE;
            }
            case 0x7FFFFFFF: {
                return MAX_VALUE;
            }
            case -2147483648: {
                return MIN_VALUE;
            }
        }
        return new Years(years);
    }

    public static Years yearsBetween(ReadableInstant start, ReadableInstant end) {
        int amount = BaseSingleFieldPeriod.between(start, end, DurationFieldType.years());
        return Years.years(amount);
    }

    public static Years yearsBetween(ReadablePartial start, ReadablePartial end) {
        if (start instanceof LocalDate && end instanceof LocalDate) {
            Chronology chrono = DateTimeUtils.getChronology(start.getChronology());
            int years = chrono.years().getDifference(((LocalDate)end).getLocalMillis(), ((LocalDate)start).getLocalMillis());
            return Years.years(years);
        }
        int amount = BaseSingleFieldPeriod.between(start, end, ZERO);
        return Years.years(amount);
    }

    public static Years yearsIn(ReadableInterval interval) {
        if (interval == null) {
            return ZERO;
        }
        int amount = BaseSingleFieldPeriod.between(interval.getStart(), interval.getEnd(), DurationFieldType.years());
        return Years.years(amount);
    }

    public static Years parseYears(String periodStr) {
        if (periodStr == null) {
            return ZERO;
        }
        Period p = PARSER.parsePeriod(periodStr);
        return Years.years(p.getYears());
    }

    private Years(int years) {
        super(years);
    }

    private Object readResolve() {
        return Years.years(this.getValue());
    }

    @Override
    public DurationFieldType getFieldType() {
        return DurationFieldType.years();
    }

    @Override
    public PeriodType getPeriodType() {
        return PeriodType.years();
    }

    public int getYears() {
        return this.getValue();
    }

    public Years plus(int years) {
        if (years == 0) {
            return this;
        }
        return Years.years(FieldUtils.safeAdd(this.getValue(), years));
    }

    public Years plus(Years years) {
        if (years == null) {
            return this;
        }
        return this.plus(years.getValue());
    }

    public Years minus(int years) {
        return this.plus(FieldUtils.safeNegate(years));
    }

    public Years minus(Years years) {
        if (years == null) {
            return this;
        }
        return this.minus(years.getValue());
    }

    public Years multipliedBy(int scalar) {
        return Years.years(FieldUtils.safeMultiply(this.getValue(), scalar));
    }

    public Years dividedBy(int divisor) {
        if (divisor == 1) {
            return this;
        }
        return Years.years(this.getValue() / divisor);
    }

    public Years negated() {
        return Years.years(FieldUtils.safeNegate(this.getValue()));
    }

    public boolean isGreaterThan(Years other) {
        if (other == null) {
            return this.getValue() > 0;
        }
        return this.getValue() > other.getValue();
    }

    public boolean isLessThan(Years other) {
        if (other == null) {
            return this.getValue() < 0;
        }
        return this.getValue() < other.getValue();
    }

    @Override
    public String toString() {
        return "P" + String.valueOf(this.getValue()) + "Y";
    }
}

