/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime.base;

import com.jn.langx.util.jodatime.Duration;
import com.jn.langx.util.jodatime.Period;
import com.jn.langx.util.jodatime.ReadableDuration;
import com.jn.langx.util.jodatime.format.FormatUtils;

public abstract class AbstractDuration
implements ReadableDuration {
    protected AbstractDuration() {
    }

    @Override
    public Duration toDuration() {
        return new Duration(this.getMillis());
    }

    @Override
    public Period toPeriod() {
        return new Period(this.getMillis());
    }

    @Override
    public int compareTo(ReadableDuration other) {
        long otherMillis;
        long thisMillis = this.getMillis();
        if (thisMillis < (otherMillis = other.getMillis())) {
            return -1;
        }
        if (thisMillis > otherMillis) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean isEqual(ReadableDuration duration) {
        if (duration == null) {
            duration = Duration.ZERO;
        }
        return this.compareTo(duration) == 0;
    }

    @Override
    public boolean isLongerThan(ReadableDuration duration) {
        if (duration == null) {
            duration = Duration.ZERO;
        }
        return this.compareTo(duration) > 0;
    }

    @Override
    public boolean isShorterThan(ReadableDuration duration) {
        if (duration == null) {
            duration = Duration.ZERO;
        }
        return this.compareTo(duration) < 0;
    }

    @Override
    public boolean equals(Object duration) {
        if (this == duration) {
            return true;
        }
        if (!(duration instanceof ReadableDuration)) {
            return false;
        }
        ReadableDuration other = (ReadableDuration)duration;
        return this.getMillis() == other.getMillis();
    }

    @Override
    public int hashCode() {
        long len = this.getMillis();
        return (int)(len ^ len >>> 32);
    }

    @Override
    public String toString() {
        long millis = this.getMillis();
        StringBuffer buf = new StringBuffer();
        buf.append("PT");
        boolean negative = millis < 0L;
        FormatUtils.appendUnpaddedInteger(buf, millis);
        while (buf.length() < (negative ? 7 : 6)) {
            buf.insert(negative ? 3 : 2, "0");
        }
        if (millis / 1000L * 1000L == millis) {
            buf.setLength(buf.length() - 3);
        } else {
            buf.insert(buf.length() - 3, ".");
        }
        buf.append('S');
        return buf.toString();
    }
}

