/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime.base;

import com.jn.langx.util.jodatime.Chronology;
import com.jn.langx.util.jodatime.DateTime;
import com.jn.langx.util.jodatime.DateTimeField;
import com.jn.langx.util.jodatime.DateTimeFieldType;
import com.jn.langx.util.jodatime.DateTimeUtils;
import com.jn.langx.util.jodatime.DateTimeZone;
import com.jn.langx.util.jodatime.Instant;
import com.jn.langx.util.jodatime.MutableDateTime;
import com.jn.langx.util.jodatime.ReadableInstant;
import com.jn.langx.util.jodatime.chrono.ISOChronology;
import com.jn.langx.util.jodatime.field.FieldUtils;
import com.jn.langx.util.jodatime.format.DateTimeFormatter;
import com.jn.langx.util.jodatime.format.ISODateTimeFormat;
import java.util.Date;

public abstract class AbstractInstant
implements ReadableInstant {
    protected AbstractInstant() {
    }

    @Override
    public DateTimeZone getZone() {
        return this.getChronology().getZone();
    }

    @Override
    public int get(DateTimeFieldType type) {
        if (type == null) {
            throw new IllegalArgumentException("The DateTimeFieldType must not be null");
        }
        return type.getField(this.getChronology()).get(this.getMillis());
    }

    @Override
    public boolean isSupported(DateTimeFieldType type) {
        if (type == null) {
            return false;
        }
        return type.getField(this.getChronology()).isSupported();
    }

    public int get(DateTimeField field) {
        if (field == null) {
            throw new IllegalArgumentException("The DateTimeField must not be null");
        }
        return field.get(this.getMillis());
    }

    @Override
    public Instant toInstant() {
        return new Instant(this.getMillis());
    }

    public DateTime toDateTime() {
        return new DateTime(this.getMillis(), this.getZone());
    }

    public DateTime toDateTimeISO() {
        return new DateTime(this.getMillis(), (Chronology)ISOChronology.getInstance(this.getZone()));
    }

    public DateTime toDateTime(DateTimeZone zone) {
        Chronology chrono = DateTimeUtils.getChronology(this.getChronology());
        chrono = chrono.withZone(zone);
        return new DateTime(this.getMillis(), chrono);
    }

    public DateTime toDateTime(Chronology chronology) {
        return new DateTime(this.getMillis(), chronology);
    }

    public MutableDateTime toMutableDateTime() {
        return new MutableDateTime(this.getMillis(), this.getZone());
    }

    public MutableDateTime toMutableDateTimeISO() {
        return new MutableDateTime(this.getMillis(), (Chronology)ISOChronology.getInstance(this.getZone()));
    }

    public MutableDateTime toMutableDateTime(DateTimeZone zone) {
        Chronology chrono = DateTimeUtils.getChronology(this.getChronology());
        chrono = chrono.withZone(zone);
        return new MutableDateTime(this.getMillis(), chrono);
    }

    public MutableDateTime toMutableDateTime(Chronology chronology) {
        return new MutableDateTime(this.getMillis(), chronology);
    }

    public Date toDate() {
        return new Date(this.getMillis());
    }

    @Override
    public boolean equals(Object readableInstant) {
        if (this == readableInstant) {
            return true;
        }
        if (!(readableInstant instanceof ReadableInstant)) {
            return false;
        }
        ReadableInstant otherInstant = (ReadableInstant)readableInstant;
        return this.getMillis() == otherInstant.getMillis() && FieldUtils.equals(this.getChronology(), otherInstant.getChronology());
    }

    @Override
    public int hashCode() {
        return (int)(this.getMillis() ^ this.getMillis() >>> 32) + this.getChronology().hashCode();
    }

    @Override
    public int compareTo(ReadableInstant other) {
        if (this == other) {
            return 0;
        }
        long otherMillis = other.getMillis();
        long thisMillis = this.getMillis();
        if (thisMillis == otherMillis) {
            return 0;
        }
        if (thisMillis < otherMillis) {
            return -1;
        }
        return 1;
    }

    public boolean isAfter(long instant) {
        return this.getMillis() > instant;
    }

    public boolean isAfterNow() {
        return this.isAfter(DateTimeUtils.currentTimeMillis());
    }

    @Override
    public boolean isAfter(ReadableInstant instant) {
        long instantMillis = DateTimeUtils.getInstantMillis(instant);
        return this.isAfter(instantMillis);
    }

    public boolean isBefore(long instant) {
        return this.getMillis() < instant;
    }

    public boolean isBeforeNow() {
        return this.isBefore(DateTimeUtils.currentTimeMillis());
    }

    @Override
    public boolean isBefore(ReadableInstant instant) {
        long instantMillis = DateTimeUtils.getInstantMillis(instant);
        return this.isBefore(instantMillis);
    }

    public boolean isEqual(long instant) {
        return this.getMillis() == instant;
    }

    public boolean isEqualNow() {
        return this.isEqual(DateTimeUtils.currentTimeMillis());
    }

    @Override
    public boolean isEqual(ReadableInstant instant) {
        long instantMillis = DateTimeUtils.getInstantMillis(instant);
        return this.isEqual(instantMillis);
    }

    @Override
    public String toString() {
        return ISODateTimeFormat.dateTime().print(this);
    }

    public String toString(DateTimeFormatter formatter) {
        if (formatter == null) {
            return this.toString();
        }
        return formatter.print(this);
    }
}

