/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime.base;

import com.jn.langx.util.jodatime.Chronology;
import com.jn.langx.util.jodatime.DateTimeUtils;
import com.jn.langx.util.jodatime.DateTimeZone;
import com.jn.langx.util.jodatime.ReadableDateTime;
import com.jn.langx.util.jodatime.base.AbstractDateTime;
import com.jn.langx.util.jodatime.chrono.ISOChronology;
import com.jn.langx.util.jodatime.convert.ConverterManager;
import com.jn.langx.util.jodatime.convert.InstantConverter;
import java.io.Serializable;

public abstract class BaseDateTime
extends AbstractDateTime
implements ReadableDateTime,
Serializable {
    private static final long serialVersionUID = -6728882245981L;
    private volatile long iMillis;
    private volatile Chronology iChronology;

    public BaseDateTime() {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance());
    }

    public BaseDateTime(DateTimeZone zone) {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)ISOChronology.getInstance(zone));
    }

    public BaseDateTime(Chronology chronology) {
        this(DateTimeUtils.currentTimeMillis(), chronology);
    }

    public BaseDateTime(long instant) {
        this(instant, (Chronology)ISOChronology.getInstance());
    }

    public BaseDateTime(long instant, DateTimeZone zone) {
        this(instant, (Chronology)ISOChronology.getInstance(zone));
    }

    public BaseDateTime(long instant, Chronology chronology) {
        this.iChronology = this.checkChronology(chronology);
        this.iMillis = this.checkInstant(instant, this.iChronology);
    }

    public BaseDateTime(Object instant, DateTimeZone zone) {
        Chronology chrono;
        InstantConverter converter = ConverterManager.getInstance().getInstantConverter(instant);
        this.iChronology = chrono = this.checkChronology(converter.getChronology(instant, zone));
        this.iMillis = this.checkInstant(converter.getInstantMillis(instant, chrono), chrono);
    }

    public BaseDateTime(Object instant, Chronology chronology) {
        InstantConverter converter = ConverterManager.getInstance().getInstantConverter(instant);
        this.iChronology = this.checkChronology(converter.getChronology(instant, chronology));
        this.iMillis = this.checkInstant(converter.getInstantMillis(instant, chronology), this.iChronology);
    }

    public BaseDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond) {
        this(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond, ISOChronology.getInstance());
    }

    public BaseDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond, DateTimeZone zone) {
        this(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond, ISOChronology.getInstance(zone));
    }

    public BaseDateTime(int year, int monthOfYear, int dayOfMonth, int hourOfDay, int minuteOfHour, int secondOfMinute, int millisOfSecond, Chronology chronology) {
        this.iChronology = this.checkChronology(chronology);
        long instant = this.iChronology.getDateTimeMillis(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
        this.iMillis = this.checkInstant(instant, this.iChronology);
    }

    protected Chronology checkChronology(Chronology chronology) {
        return DateTimeUtils.getChronology(chronology);
    }

    protected long checkInstant(long instant, Chronology chronology) {
        return instant;
    }

    @Override
    public long getMillis() {
        return this.iMillis;
    }

    @Override
    public Chronology getChronology() {
        return this.iChronology;
    }

    protected void setMillis(long instant) {
        this.iMillis = this.checkInstant(instant, this.iChronology);
    }

    protected void setChronology(Chronology chronology) {
        this.iChronology = this.checkChronology(chronology);
    }
}

