/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime.base;

import com.jn.langx.util.jodatime.Chronology;
import com.jn.langx.util.jodatime.DateTimeUtils;
import com.jn.langx.util.jodatime.Interval;
import com.jn.langx.util.jodatime.Period;
import com.jn.langx.util.jodatime.PeriodType;
import com.jn.langx.util.jodatime.ReadableDuration;
import com.jn.langx.util.jodatime.ReadableInstant;
import com.jn.langx.util.jodatime.base.AbstractDuration;
import com.jn.langx.util.jodatime.convert.ConverterManager;
import com.jn.langx.util.jodatime.convert.DurationConverter;
import com.jn.langx.util.jodatime.field.FieldUtils;
import java.io.Serializable;

public abstract class BaseDuration
extends AbstractDuration
implements ReadableDuration,
Serializable {
    private static final long serialVersionUID = 2581698638990L;
    private volatile long iMillis;

    protected BaseDuration(long duration) {
        this.iMillis = duration;
    }

    protected BaseDuration(long startInstant, long endInstant) {
        this.iMillis = FieldUtils.safeAdd(endInstant, -startInstant);
    }

    protected BaseDuration(ReadableInstant start, ReadableInstant end) {
        if (start == end) {
            this.iMillis = 0L;
        } else {
            long startMillis = DateTimeUtils.getInstantMillis(start);
            long endMillis = DateTimeUtils.getInstantMillis(end);
            this.iMillis = FieldUtils.safeAdd(endMillis, -startMillis);
        }
    }

    protected BaseDuration(Object duration) {
        DurationConverter converter = ConverterManager.getInstance().getDurationConverter(duration);
        this.iMillis = converter.getDurationMillis(duration);
    }

    @Override
    public long getMillis() {
        return this.iMillis;
    }

    protected void setMillis(long duration) {
        this.iMillis = duration;
    }

    public Period toPeriod(PeriodType type) {
        return new Period(this.getMillis(), type);
    }

    public Period toPeriod(Chronology chrono) {
        return new Period(this.getMillis(), chrono);
    }

    public Period toPeriod(PeriodType type, Chronology chrono) {
        return new Period(this.getMillis(), type, chrono);
    }

    public Period toPeriodFrom(ReadableInstant startInstant) {
        return new Period(startInstant, this);
    }

    public Period toPeriodFrom(ReadableInstant startInstant, PeriodType type) {
        return new Period(startInstant, this, type);
    }

    public Period toPeriodTo(ReadableInstant endInstant) {
        return new Period(this, endInstant);
    }

    public Period toPeriodTo(ReadableInstant endInstant, PeriodType type) {
        return new Period(this, endInstant, type);
    }

    public Interval toIntervalFrom(ReadableInstant startInstant) {
        return new Interval(startInstant, this);
    }

    public Interval toIntervalTo(ReadableInstant endInstant) {
        return new Interval(this, endInstant);
    }
}

