/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jodatime.base;

import com.jn.langx.util.jodatime.Chronology;
import com.jn.langx.util.jodatime.DateTimeField;
import com.jn.langx.util.jodatime.DateTimeUtils;
import com.jn.langx.util.jodatime.ReadablePartial;
import com.jn.langx.util.jodatime.base.AbstractPartial;
import com.jn.langx.util.jodatime.convert.ConverterManager;
import com.jn.langx.util.jodatime.convert.PartialConverter;
import com.jn.langx.util.jodatime.format.DateTimeFormat;
import com.jn.langx.util.jodatime.format.DateTimeFormatter;
import java.io.Serializable;
import java.util.Locale;

public abstract class BasePartial
extends AbstractPartial
implements ReadablePartial,
Serializable {
    private static final long serialVersionUID = 2353678632973660L;
    private final Chronology iChronology;
    private final int[] iValues;

    protected BasePartial() {
        this(DateTimeUtils.currentTimeMillis(), (Chronology)null);
    }

    protected BasePartial(Chronology chronology) {
        this(DateTimeUtils.currentTimeMillis(), chronology);
    }

    protected BasePartial(long instant) {
        this(instant, (Chronology)null);
    }

    protected BasePartial(long instant, Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        this.iValues = chronology.get(this, instant);
    }

    protected BasePartial(Object instant, Chronology chronology) {
        PartialConverter converter = ConverterManager.getInstance().getPartialConverter(instant);
        chronology = converter.getChronology(instant, chronology);
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        this.iValues = converter.getPartialValues(this, instant, chronology);
    }

    protected BasePartial(Object instant, Chronology chronology, DateTimeFormatter parser) {
        PartialConverter converter = ConverterManager.getInstance().getPartialConverter(instant);
        chronology = converter.getChronology(instant, chronology);
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        this.iValues = converter.getPartialValues(this, instant, chronology, parser);
    }

    protected BasePartial(int[] values, Chronology chronology) {
        chronology = DateTimeUtils.getChronology(chronology);
        this.iChronology = chronology.withUTC();
        chronology.validate(this, values);
        this.iValues = values;
    }

    protected BasePartial(BasePartial base, int[] values) {
        this.iChronology = base.iChronology;
        this.iValues = values;
    }

    protected BasePartial(BasePartial base, Chronology chrono) {
        this.iChronology = chrono.withUTC();
        this.iValues = base.iValues;
    }

    @Override
    public int getValue(int index) {
        return this.iValues[index];
    }

    @Override
    public int[] getValues() {
        return (int[])this.iValues.clone();
    }

    @Override
    public Chronology getChronology() {
        return this.iChronology;
    }

    protected void setValue(int index, int value) {
        DateTimeField field = this.getField(index);
        int[] values = field.set(this, index, this.iValues, value);
        System.arraycopy(values, 0, this.iValues, 0, this.iValues.length);
    }

    protected void setValues(int[] values) {
        this.getChronology().validate(this, values);
        System.arraycopy(values, 0, this.iValues, 0, this.iValues.length);
    }

    public String toString(String pattern) {
        if (pattern == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(pattern).print(this);
    }

    public String toString(String pattern, Locale locale) throws IllegalArgumentException {
        if (pattern == null) {
            return this.toString();
        }
        return DateTimeFormat.forPattern(pattern).withLocale(locale).print(this);
    }
}

